/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.config;

import com.dmarcotte.handlebars.config.Property;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HbConfig {
    public static boolean isAutoGenerateCloseTagEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTO_GENERATE_CLOSE_TAG);
    }

    public static void setAutoGenerateCloseTagEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTO_GENERATE_CLOSE_TAG, enabled);
    }

    public static boolean isAutocompleteMustachesEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTOCOMPLETE_MUSTACHES);
    }

    public static void setAutocompleteMustachesEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTOCOMPLETE_MUSTACHES, enabled);
    }

    public static boolean isFormattingEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.FORMATTER);
    }

    public static void setFormattingEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.FORMATTER, enabled);
    }

    public static boolean isAutoCollapseBlocksEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTO_COLLAPSE_BLOCKS);
    }

    public static void setAutoCollapseBlocks(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTO_COLLAPSE_BLOCKS, enabled);
    }

    @NotNull
    public static Language getCommenterLanguage() {
        Language id = Language.findLanguageByID((String)HbConfig.getStringPropertyValue(Property.COMMENTER_LANGUAGE_ID));
        Object object = id == null ? HTMLLanguage.INSTANCE : id;
        if (object == null) {
            HbConfig.$$$reportNull$$$0(0);
        }
        return object;
    }

    public static void setCommenterLanguage(Language language) {
        if (language == null) {
            HbConfig.setStringPropertyValue(Property.COMMENTER_LANGUAGE_ID, null);
        } else {
            HbConfig.setStringPropertyValue(Property.COMMENTER_LANGUAGE_ID, language.getID());
        }
    }

    public static String getRawOpenHtmlAsHandlebarsValue(Project project) {
        return HbConfig.getStringPropertyValue(Property.SHOULD_OPEN_HTML, project);
    }

    public static boolean shouldOpenHtmlAsHandlebars(Project project) {
        String value = HbConfig.getRawOpenHtmlAsHandlebarsValue(project);
        return "enabled".equals(value);
    }

    public static boolean setShouldOpenHtmlAsHandlebars(boolean value, Project project) {
        HbConfig.setBooleanPropertyValue(Property.SHOULD_OPEN_HTML, value, project);
        return true;
    }

    private static String getStringPropertyValue(Property property, Project project) {
        return HbConfig.getProperties(project).getValue(property.getStringName(), property.getDefault());
    }

    @NotNull
    private static PropertiesComponent getProperties(@Nullable Project project) {
        PropertiesComponent propertiesComponent = project == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent == null) {
            HbConfig.$$$reportNull$$$0(1);
        }
        return propertiesComponent;
    }

    private static void setStringPropertyValue(@NotNull Property property, @Nullable String value, @Nullable Project project) {
        if (property == null) {
            HbConfig.$$$reportNull$$$0(2);
        }
        HbConfig.getProperties(project).setValue(property.getStringName(), value, property.getDefault());
    }

    private static String getStringPropertyValue(Property property) {
        return HbConfig.getStringPropertyValue(property, null);
    }

    private static void setStringPropertyValue(Property property, String value) {
        HbConfig.setStringPropertyValue(property, value, null);
    }

    private static boolean getBooleanPropertyValue(Property property) {
        return "enabled".equals(HbConfig.getStringPropertyValue(property));
    }

    private static void setBooleanPropertyValue(@NotNull Property property, boolean enabled, @Nullable Project project) {
        if (property == null) {
            HbConfig.$$$reportNull$$$0(3);
        }
        HbConfig.setStringPropertyValue(property, enabled ? "enabled" : "disabled", project);
    }

    private static void setBooleanPropertyValue(Property property, boolean enabled) {
        HbConfig.setBooleanPropertyValue(property, enabled, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/config/HbConfig";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommenterLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/config/HbConfig";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStringPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBooleanPropertyValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

