/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.utils.registryUtils.impl;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.shared.utils.registryUtils.WindowsRegistryErrorTypes;
import com.jetbrains.rider.shared.utils.registryUtils.WindowsRegistryException;
import com.jetbrains.rider.shared.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/shared/utils/registryUtils/impl/PrivateRegistryRoot;", "Lcom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryRoot;", "file", "Ljava/io/File;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Ljava/io/File;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "Companion", "intellij.rider.shared"})
public final class PrivateRegistryRoot
extends RegistryRoot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private static final Map<File, PrivateRegistryRoot> openedRegFiles = new LinkedHashMap();

    private PrivateRegistryRoot(File file, Lifetime lifetime) {
        super(PrivateRegistryRoot.Companion.openPrivateRegistry(file), lifetime);
        this.file = file;
        lifetime.onTermination(() -> PrivateRegistryRoot._init_$lambda$0(this));
    }

    private static final Unit _init_$lambda$0(PrivateRegistryRoot this$0) {
        openedRegFiles.remove(this$0.file);
        return Unit.INSTANCE;
    }

    public /* synthetic */ PrivateRegistryRoot(File file, Lifetime lifetime, DefaultConstructorMarker $constructor_marker) {
        this(file, lifetime);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/shared/utils/registryUtils/impl/PrivateRegistryRoot$Companion;", "", "<init>", "()V", "openedRegFiles", "", "Ljava/io/File;", "Lcom/jetbrains/rider/shared/utils/registryUtils/impl/PrivateRegistryRoot;", "getOrCreate", "file", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getWindowsErrorText", "", "winCode", "", "openPrivateRegistry", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "intellij.rider.shared"})
    @SourceDebugExtension(value={"SMAP\nPrivateRegistryRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateRegistryRoot.kt\ncom/jetbrains/rider/shared/utils/registryUtils/impl/PrivateRegistryRoot$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,60:1\n382#2,7:61\n*S KotlinDebug\n*F\n+ 1 PrivateRegistryRoot.kt\ncom/jetbrains/rider/shared/utils/registryUtils/impl/PrivateRegistryRoot$Companion\n*L\n14#1:61,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PrivateRegistryRoot getOrCreate(@NotNull File file, @NotNull Lifetime lifetime) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Map map = openedRegFiles;
            File key$iv = file;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                PrivateRegistryRoot answer$iv = new PrivateRegistryRoot(file, lifetime, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (PrivateRegistryRoot)object;
        }

        private final String getWindowsErrorText(int winCode) {
            return switch (winCode) {
                case 32 -> "The process cannot access the file because it is being used by another process.";
                case 33 -> "The process cannot access the file because another process has locked a portion of the file.";
                case 123 -> "The filename, directory name, or volume label syntax is incorrect.";
                case 0 -> "Operation completed successfully.";
                default -> "Unknown Windows error: " + winCode;
            };
        }

        private final WinReg.HKEY openPrivateRegistry(File file) {
            WinReg.HKEYByReference hKEYByReference;
            try {
                hKEYByReference = Advapi32Util.registryLoadAppKey((String)file.getAbsolutePath(), (int)983103, (int)0);
            }
            catch (Win32Exception t) {
                throw new WindowsRegistryException(this.getWindowsErrorText(t.getErrorCode()), WindowsRegistryErrorTypes.CORRUPTED);
            }
            WinReg.HKEYByReference phKey = hKEYByReference;
            try {
                int len = Advapi32Util.registryQueryInfoKey((WinReg.HKEY)phKey.getValue(), (int)0).lpcMaxSubKeyLen.getValue();
                if (len == 0) {
                    throw new WindowsRegistryException("lpcMaxSubKeyLen == 0, possibly a bad file", WindowsRegistryErrorTypes.CORRUPTED);
                }
            }
            catch (Win32Exception win32Exception) {
                throw new WindowsRegistryException("Failed to query info key, registry is corrupted", WindowsRegistryErrorTypes.CORRUPTED);
            }
            WinReg.HKEY hKEY = phKey.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"getValue(...)");
            return hKEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

