/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.run;

import com.intellij.execution.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsOutputStream;", "Ljava/io/OutputStream;", "writeHandle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "<init>", "(Lcom/sun/jna/platform/win32/WinNT$HANDLE;)V", "buffer", "", "closed", "", "write", "", "b", "", "off", "len", "close", "intellij.rider.shared"})
public final class WindowsOutputStream
extends OutputStream {
    @NotNull
    private final WinNT.HANDLE writeHandle;
    @NotNull
    private final byte[] buffer;
    private boolean closed;

    public WindowsOutputStream(@NotNull WinNT.HANDLE writeHandle) {
        Intrinsics.checkNotNullParameter((Object)writeHandle, (String)"writeHandle");
        this.writeHandle = writeHandle;
        this.buffer = new byte[4096];
        if (!(Platform.current() == Platform.WINDOWS)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void write(int b) {
        this.buffer[0] = (byte)b;
        this.write(this.buffer, 0, 1);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        IntByReference bytesWritten = new IntByReference(0);
        int writeOffset = off;
        int remainingBytes = len;
        while (remainingBytes > 0) {
            int bytesToWrite = Math.min(this.buffer.length, remainingBytes);
            System.arraycopy(b, writeOffset, this.buffer, 0, bytesToWrite);
            if (!Kernel32.INSTANCE.WriteFile(this.writeHandle, this.buffer, bytesToWrite, bytesWritten, null)) {
                int errCode = Kernel32.INSTANCE.GetLastError();
                String msg = Kernel32Util.formatMessage((int)errCode);
                throw new IOException("WindowsOutputStream.write exception. Error code: " + errCode + ". Error message: " + msg);
            }
            remainingBytes -= bytesToWrite;
            writeOffset += bytesToWrite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (!Kernel32.INSTANCE.CloseHandle(this.writeHandle)) {
                int errCode = Kernel32.INSTANCE.GetLastError();
                String msg = Kernel32Util.formatMessage((int)errCode);
                throw new RuntimeException("WindowsOutputStream.Close exception. Error code: " + errCode + ". Error message: " + msg);
            }
        }
        finally {
            this.closed = true;
        }
    }
}

