/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.run;

import com.intellij.execution.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsInputStream;", "Ljava/io/InputStream;", "readHandle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "<init>", "(Lcom/sun/jna/platform/win32/WinNT$HANDLE;)V", "buffer", "", "closed", "", "read", "", "b", "off", "len", "available", "close", "", "intellij.rider.shared"})
public final class WindowsInputStream
extends InputStream {
    @NotNull
    private final WinNT.HANDLE readHandle;
    @NotNull
    private final byte[] buffer;
    private boolean closed;

    public WindowsInputStream(@NotNull WinNT.HANDLE readHandle) {
        Intrinsics.checkNotNullParameter((Object)readHandle, (String)"readHandle");
        this.readHandle = readHandle;
        this.buffer = new byte[4096];
        if (!(Platform.current() == Platform.WINDOWS)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int read() {
        int bytesRead = this.read(this.buffer, 0, 1);
        if (bytesRead == 1) {
            return this.buffer[0];
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        IntByReference bytesRead = new IntByReference(0);
        int bytesToRead = Math.min(this.buffer.length, len);
        if (!Kernel32.INSTANCE.ReadFile(this.readHandle, this.buffer, bytesToRead, bytesRead, null)) {
            int errCode = Kernel32.INSTANCE.GetLastError();
            if (errCode == 109) {
                return -1;
            }
            throw new IOException("WindowsInputStream.read exception. Error code: " + errCode + ". Error message: " + Kernel32Util.formatMessage((int)errCode));
        }
        int bytesReadVal = bytesRead.getValue();
        if (bytesReadVal == 0) {
            return -1;
        }
        System.arraycopy(this.buffer, 0, b, off, bytesReadVal);
        return bytesReadVal;
    }

    @Override
    public int available() {
        IntByReference availableBytes = new IntByReference(0);
        if (!Kernel32.INSTANCE.PeekNamedPipe(this.readHandle, null, 0, null, availableBytes, null)) {
            int errCode = Kernel32.INSTANCE.GetLastError();
            if (errCode == 109) {
                return 0;
            }
            String msg = Kernel32Util.formatMessage((int)errCode);
            throw new RuntimeException("WindowsInputStream.available exception. Error code: " + errCode + ". Error message: " + msg);
        }
        return availableBytes.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (!Kernel32.INSTANCE.CloseHandle(this.readHandle)) {
                int errCode = Kernel32.INSTANCE.GetLastError();
                String msg = Kernel32Util.formatMessage((int)errCode);
                throw new RuntimeException("WindowsInputStream.Close exception. Error code: " + errCode + ". Error message: " + msg);
            }
        }
        finally {
            this.closed = true;
        }
    }
}

