/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.run;

import com.intellij.execution.configurations.CommandLineWithSuspendedProcessCallback;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLine;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import com.jetbrains.rider.shared.run.IORedirectionMode;
import com.jetbrains.rider.shared.run.WindowsProcess;
import java.nio.file.Path;
import java.util.List;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/shared/run/SuspendableFormatPreservingCommandLine;", "Lcom/jetbrains/rider/shared/run/FormatPreservingCommandLine;", "Lcom/intellij/execution/configurations/CommandLineWithSuspendedProcessCallback;", "ioRedirectionMode", "Lcom/jetbrains/rider/shared/run/IORedirectionMode;", "isConsole", "", "<init>", "(Lcom/jetbrains/rider/shared/run/IORedirectionMode;Z)V", "winSuspendedProcessCallback", "Ljava/util/function/LongConsumer;", "startProcess", "Ljava/lang/Process;", "withWinSuspendedProcessCallback", "", "callback", "getWinSuspendedProcessCallback", "intellij.rider.shared"})
@SourceDebugExtension(value={"SMAP\nFormatPreservingCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatPreservingCommandLine.kt\ncom/jetbrains/rider/shared/run/SuspendableFormatPreservingCommandLine\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,287:1\n13#2:288\n*S KotlinDebug\n*F\n+ 1 FormatPreservingCommandLine.kt\ncom/jetbrains/rider/shared/run/SuspendableFormatPreservingCommandLine\n*L\n43#1:288\n*E\n"})
public final class SuspendableFormatPreservingCommandLine
extends FormatPreservingCommandLine
implements CommandLineWithSuspendedProcessCallback {
    @NotNull
    private final IORedirectionMode ioRedirectionMode;
    private final boolean isConsole;
    @Nullable
    private LongConsumer winSuspendedProcessCallback;

    public SuspendableFormatPreservingCommandLine(@NotNull IORedirectionMode ioRedirectionMode, boolean isConsole) {
        Intrinsics.checkNotNullParameter((Object)((Object)ioRedirectionMode), (String)"ioRedirectionMode");
        this.ioRedirectionMode = ioRedirectionMode;
        this.isConsole = isConsole;
    }

    @Override
    @NotNull
    protected Process startProcess() {
        if (SystemInfo.isWindows && !this.isProcessCreatorSet()) {
            List list = this.getCommandLineList(this.getExePath());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommandLineList(...)");
            Path path = this.getWorkingDirectory();
            return new WindowsProcess(this.isConsole, this.ioRedirectionMode, FormatPreservingCommandLineKt.access$getFormattedArguments(list), this.getEnvironment(), path != null ? ((Object)path).toString() : null, this.winSuspendedProcessCallback);
        }
        return super.startProcess();
    }

    public void withWinSuspendedProcessCallback(@NotNull LongConsumer callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LongConsumer safeCallback = arg_0 -> SuspendableFormatPreservingCommandLine.withWinSuspendedProcessCallback$lambda$0(callback, arg_0);
        if (this.winSuspendedProcessCallback == null) {
            this.winSuspendedProcessCallback = safeCallback;
        } else {
            LongConsumer longConsumer = this.winSuspendedProcessCallback;
            Intrinsics.checkNotNull((Object)longConsumer);
            this.winSuspendedProcessCallback = longConsumer.andThen(safeCallback);
        }
    }

    @Nullable
    public LongConsumer getWinSuspendedProcessCallback() {
        return this.winSuspendedProcessCallback;
    }

    private static final void withWinSuspendedProcessCallback$lambda$0(LongConsumer $callback, long pid) {
        try {
            $callback.accept(pid);
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SuspendableFormatPreservingCommandLine.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
        }
    }
}

