/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.models.role;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.ReplicationPartner;
import java.io.Serializable;

public class RedisReplicaInstance
implements RedisInstance,
Serializable {
    private ReplicationPartner upstream;
    private State state;

    public RedisReplicaInstance() {
    }

    RedisReplicaInstance(ReplicationPartner upstream, State state2) {
        LettuceAssert.notNull((Object)upstream, "Upstream must not be null");
        LettuceAssert.notNull((Object)state2, "State must not be null");
        this.upstream = upstream;
        this.state = state2;
    }

    @Override
    public RedisInstance.Role getRole() {
        return RedisInstance.Role.REPLICA;
    }

    public ReplicationPartner getUpstream() {
        return this.upstream;
    }

    public State getState() {
        return this.state;
    }

    public void setUpstream(ReplicationPartner upstream) {
        LettuceAssert.notNull((Object)upstream, "Master must not be null");
        this.upstream = upstream;
    }

    public void setState(State state2) {
        LettuceAssert.notNull((Object)state2, "State must not be null");
        this.state = state2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [master=").append(this.upstream);
        sb.append(", state=").append((Object)this.state);
        sb.append(']');
        return sb.toString();
    }

    public static enum State {
        NONE,
        UNKNOWN,
        HANDSHAKE,
        CONNECT,
        CONNECTING,
        SYNC,
        CONNECTED;

    }
}

