/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.json.DelegateJsonArray;
import io.lettuce.core.json.DelegateJsonObject;
import io.lettuce.core.json.JsonArray;
import io.lettuce.core.json.JsonObject;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.json.RedisJsonException;
import java.nio.ByteBuffer;

class DelegateJsonValue
implements JsonValue {
    protected JsonNode node;

    DelegateJsonValue(JsonNode node) {
        this.node = node;
    }

    @Override
    public String toString() {
        return this.node.toString();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        byte[] result2 = this.node.toString().getBytes();
        return ByteBuffer.wrap(result2);
    }

    @Override
    public boolean isJsonArray() {
        return this.node.isArray();
    }

    @Override
    public JsonArray asJsonArray() {
        return null;
    }

    @Override
    public boolean isJsonObject() {
        return this.node.isObject();
    }

    @Override
    public JsonObject asJsonObject() {
        return null;
    }

    @Override
    public boolean isString() {
        return this.node.isTextual();
    }

    @Override
    public String asString() {
        return this.node.isTextual() ? this.node.asText() : null;
    }

    @Override
    public boolean isNumber() {
        return this.node.isNumber();
    }

    @Override
    public Boolean asBoolean() {
        return this.node.isBoolean() ? Boolean.valueOf(this.node.asBoolean()) : null;
    }

    @Override
    public boolean isBoolean() {
        return this.node.isBoolean();
    }

    @Override
    public boolean isNull() {
        return this.node.isNull();
    }

    @Override
    public Number asNumber() {
        if (this.node.isNull()) {
            return null;
        }
        return this.node.numberValue();
    }

    protected JsonNode getNode() {
        return this.node;
    }

    @Override
    public <T> T toObject(Class<T> type) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.treeToValue((TreeNode)this.node, type);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new RedisJsonException("Unable to map the provided JsonValue to " + type.getName(), e);
        }
    }

    static JsonValue wrap(JsonNode root) {
        if (root.isObject()) {
            return new DelegateJsonObject(root);
        }
        if (root.isArray()) {
            return new DelegateJsonArray(root);
        }
        return new DelegateJsonValue(root);
    }
}

