/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.support;

import io.lettuce.core.dynamic.support.ParentTypeAwareTypeInformation;
import io.lettuce.core.dynamic.support.TypeDiscoverer;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeVariableTypeInformation<T>
extends ParentTypeAwareTypeInformation<T> {
    private final TypeVariable<?> variable;
    private final Type owningType;

    public TypeVariableTypeInformation(TypeVariable<?> variable, Type owningType, TypeDiscoverer<?> parent, Map<TypeVariable<?>, Type> typeVariableMap) {
        super(variable, parent, typeVariableMap);
        LettuceAssert.notNull(variable, "TypeVariable must not be null");
        this.variable = variable;
        this.owningType = owningType;
    }

    @Override
    public Class<T> getType() {
        int index = this.getIndex(this.variable);
        if (this.owningType instanceof ParameterizedType && index != -1) {
            Type fieldType = ((ParameterizedType)this.owningType).getActualTypeArguments()[index];
            return this.resolveClass(fieldType);
        }
        return this.resolveClass(this.variable);
    }

    private int getIndex(TypeVariable<?> variable) {
        Class rawType = this.resolveClass(this.owningType);
        TypeVariable<Class<S>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!variable.equals(typeParameters[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        ArrayList result2 = new ArrayList();
        Type type = this.resolveType(this.variable);
        if (type instanceof ParameterizedType) {
            for (Type typeArgument : ((ParameterizedType)type).getActualTypeArguments()) {
                result2.add(this.createInfo(typeArgument));
            }
        }
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeVariableTypeInformation)) {
            return false;
        }
        TypeVariableTypeInformation that = (TypeVariableTypeInformation)obj;
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.variable, this.owningType);
    }

    public String toString() {
        return this.variable.getName();
    }

    public String getVariableName() {
        return this.variable.getName();
    }
}

