/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.support;

import io.lettuce.core.dynamic.support.GenericTypeResolver;
import io.lettuce.core.dynamic.support.TypeDiscoverer;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ClassTypeInformation<S>
extends TypeDiscoverer<S> {
    public static final ClassTypeInformation<Collection> COLLECTION = new ClassTypeInformation<Collection>(Collection.class);
    public static final ClassTypeInformation<List> LIST = new ClassTypeInformation<List>(List.class);
    public static final ClassTypeInformation<Set> SET = new ClassTypeInformation<Set>(Set.class);
    public static final ClassTypeInformation<Map> MAP = new ClassTypeInformation<Map>(Map.class);
    public static final ClassTypeInformation<Object> OBJECT = new ClassTypeInformation<Object>(Object.class);
    private static final Map<Class<?>, Reference<ClassTypeInformation<?>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Class<S> type;

    public static <S> ClassTypeInformation<S> from(Class<S> type) {
        TypeInformation cachedTypeInfo;
        LettuceAssert.notNull(type, "Type must not be null!");
        Reference<ClassTypeInformation<?>> cachedReference = CACHE.get(type);
        TypeInformation typeInformation = cachedTypeInfo = cachedReference == null ? null : (TypeInformation)cachedReference.get();
        if (cachedTypeInfo != null) {
            return (ClassTypeInformation)cachedTypeInfo;
        }
        ClassTypeInformation<S> result2 = new ClassTypeInformation<S>(type);
        CACHE.put(type, new WeakReference<ClassTypeInformation<S>>(result2));
        return result2;
    }

    public static <S> TypeInformation<S> fromReturnTypeOf(Method method) {
        LettuceAssert.notNull((Object)method, "Method must not be null!");
        return new ClassTypeInformation(method.getDeclaringClass()).createInfo(method.getGenericReturnType());
    }

    public static <S> TypeInformation<S> fromMethodParameter(Method method, int index) {
        LettuceAssert.notNull((Object)method, "Method must not be null!");
        return new ClassTypeInformation(method.getDeclaringClass()).createInfo(method.getGenericParameterTypes()[index]);
    }

    ClassTypeInformation(Class<S> type) {
        super(ClassTypeInformation.getUserClass(type), ClassTypeInformation.getTypeVariableMap(type));
        this.type = type;
    }

    private static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz != null && clazz.getName().contains("$$") && (superclass = clazz.getSuperclass()) != null && Object.class != superclass) {
            return superclass;
        }
        return clazz;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> type) {
        return ClassTypeInformation.getTypeVariableMap(type, new HashSet<Type>());
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> type, Collection<Type> visited) {
        if (visited.contains(type)) {
            return Collections.emptyMap();
        }
        visited.add(type);
        Map<TypeVariable, Type> source = GenericTypeResolver.getTypeVariableMap(type);
        HashMap map = new HashMap(source.size());
        for (Map.Entry<TypeVariable, Type> entry : source.entrySet()) {
            Type value = entry.getValue();
            map.put(entry.getKey(), entry.getValue());
            if (!(value instanceof Class)) continue;
            map.putAll(ClassTypeInformation.getTypeVariableMap((Class)value, visited));
        }
        return map;
    }

    @Override
    public Class<S> getType() {
        return this.type;
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return this;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return this.getType().isAssignableFrom(target.getType());
    }

    public String toString() {
        return this.type.getName();
    }

    static {
        for (ClassTypeInformation info2 : Arrays.asList(COLLECTION, LIST, SET, MAP, OBJECT)) {
            CACHE.put(info2.getType(), new WeakReference<ClassTypeInformation>(info2));
        }
    }
}

