/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.dynamic.RedisCommandsMetadata;
import io.lettuce.core.internal.LettuceAssert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

class DefaultRedisCommandsMetadata
implements RedisCommandsMetadata {
    private static final char PACKAGE_SEPARATOR = '.';
    private final Class<?> apiInterface;

    DefaultRedisCommandsMetadata(Class<?> apiInterface) {
        this.apiInterface = apiInterface;
    }

    @Override
    public Class<?> getCommandsInterface() {
        return this.apiInterface;
    }

    @Override
    public Collection<Method> getMethods() {
        HashSet<Method> result2 = new HashSet<Method>();
        for (Method method : this.getCommandsInterface().getMethods()) {
            if (!this.isQueryMethodCandidate(method = DefaultRedisCommandsMetadata.getMostSpecificMethod(method, this.getCommandsInterface()))) continue;
            result2.add(method);
        }
        return Collections.unmodifiableSet(result2);
    }

    private boolean isQueryMethodCandidate(Method method) {
        return !method.isBridge() && !method.isDefault() && !Modifier.isStatic(method.getModifiers());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getCommandsInterface().getAnnotation(annotationClass);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.getCommandsInterface().getAnnotation(annotationClass) != null;
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && DefaultRedisCommandsMetadata.isOverridable(method, targetClass) && targetClass != null && targetClass != method.getDeclaringClass()) {
            try {
                try {
                    return targetClass.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException ex) {
                    return method;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    private static boolean isOverridable(Method method, Class<?> targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return DefaultRedisCommandsMetadata.getPackageName(method.getDeclaringClass()).equals(DefaultRedisCommandsMetadata.getPackageName(targetClass));
    }

    private static String getPackageName(Class<?> clazz) {
        LettuceAssert.notNull(clazz, "Class must not be null");
        return DefaultRedisCommandsMetadata.getPackageName(clazz.getName());
    }

    private static String getPackageName(String fqClassName) {
        LettuceAssert.notNull((Object)fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }
}

