/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.api.sync.Executions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

class SyncExecutionsImpl<T>
implements Executions<T> {
    private Map<RedisClusterNode, T> executions;

    public SyncExecutionsImpl(Map<RedisClusterNode, CompletionStage<? extends T>> executions) throws ExecutionException, InterruptedException {
        HashMap<RedisClusterNode, T> result2 = new HashMap<RedisClusterNode, T>(executions.size(), 1.0f);
        for (Map.Entry<RedisClusterNode, CompletionStage<T>> entry : executions.entrySet()) {
            result2.put(entry.getKey(), entry.getValue().toCompletableFuture().get());
        }
        this.executions = result2;
    }

    @Override
    public Map<RedisClusterNode, T> asMap() {
        return this.executions;
    }

    @Override
    public Collection<RedisClusterNode> nodes() {
        return this.executions.keySet();
    }

    @Override
    public T get(RedisClusterNode redisClusterNode) {
        return this.executions.get(redisClusterNode);
    }
}

