/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.protocol.ConnectionIntent;
import java.util.function.Function;

interface ClusterNodeConnectionFactory<K, V>
extends Function<ConnectionKey, ConnectionFuture<StatefulRedisConnection<K, V>>> {
    public void setPartitions(Partitions var1);

    public static class ConnectionKey {
        final ConnectionIntent connectionIntent;
        final String nodeId;
        final String host;
        final int port;

        public ConnectionKey(ConnectionIntent connectionIntent, String nodeId) {
            this.connectionIntent = connectionIntent;
            this.nodeId = nodeId;
            this.host = null;
            this.port = 0;
        }

        public ConnectionKey(ConnectionIntent connectionIntent, String host, int port) {
            this.connectionIntent = connectionIntent;
            this.host = host;
            this.port = port;
            this.nodeId = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey key = (ConnectionKey)o;
            if (this.port != key.port) {
                return false;
            }
            if (this.connectionIntent != key.connectionIntent) {
                return false;
            }
            if (this.nodeId != null ? !this.nodeId.equals(key.nodeId) : key.nodeId != null) {
                return false;
            }
            return !(this.host == null ? key.host != null : !this.host.equals(key.host));
        }

        public int hashCode() {
            int result2 = this.connectionIntent != null ? this.connectionIntent.name().hashCode() : 0;
            result2 = 31 * result2 + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result2 = 31 * result2 + (this.host != null ? this.host.hashCode() : 0);
            result2 = 31 * result2 + this.port;
            return result2;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [connectionIntent=").append((Object)this.connectionIntent);
            sb.append(", nodeId='").append(this.nodeId).append('\'');
            sb.append(", host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
            sb.append(']');
            return sb.toString();
        }
    }
}

