/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.authx;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.core.TokenAuthConfig;
import redis.clients.authentication.core.TokenListener;
import redis.clients.authentication.core.TokenManager;

public class TokenBasedRedisCredentialsProvider
implements RedisCredentialsProvider,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TokenBasedRedisCredentialsProvider.class);
    private final TokenManager tokenManager;
    private final Sinks.Many<RedisCredentials> credentialsSink = Sinks.many().replay().latest();

    private TokenBasedRedisCredentialsProvider(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    private void init() {
        TokenListener listener = new TokenListener(){

            @Override
            public void onTokenRenewed(Token token) {
                String username = token.getUser();
                char[] pass = token.getValue().toCharArray();
                RedisCredentials credentials = RedisCredentials.just(username, pass);
                TokenBasedRedisCredentialsProvider.this.credentialsSink.tryEmitNext(credentials);
            }

            @Override
            public void onError(Exception exception) {
                log.error("Token renew failed!", (Throwable)exception);
            }
        };
        try {
            this.tokenManager.start(listener, false);
        }
        catch (Exception e) {
            this.credentialsSink.tryEmitError(e);
            this.tokenManager.stop();
            throw new RuntimeException("Failed to start TokenManager", e);
        }
    }

    @Override
    public Mono<RedisCredentials> resolveCredentials() {
        return this.credentialsSink.asFlux().next();
    }

    @Override
    public Flux<RedisCredentials> credentials() {
        return this.credentialsSink.asFlux().onBackpressureLatest();
    }

    @Override
    public boolean supportsStreaming() {
        return true;
    }

    @Override
    public void close() {
        this.credentialsSink.tryEmitComplete();
        this.tokenManager.stop();
    }

    public static TokenBasedRedisCredentialsProvider create(TokenAuthConfig tokenAuthConfig) {
        return TokenBasedRedisCredentialsProvider.create(new TokenManager(tokenAuthConfig.getIdentityProviderConfig().getProvider(), tokenAuthConfig.getTokenManagerConfig()));
    }

    public static TokenBasedRedisCredentialsProvider create(TokenManager tokenManager) {
        TokenBasedRedisCredentialsProvider credentialManager = new TokenBasedRedisCredentialsProvider(tokenManager);
        credentialManager.init();
        return credentialManager;
    }
}

