/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm.openai.responses;

import com.intellij.ml.llm.matterhorn.configuration.BuildConfigKt;
import com.intellij.ml.llm.matterhorn.configuration.Env;
import com.intellij.ml.llm.matterhorn.configuration.EnvExtensionsKt;
import com.intellij.ml.llm.matterhorn.core.llm.LlmClient;
import com.intellij.ml.llm.matterhorn.core.llm.LlmRequest;
import com.intellij.ml.llm.matterhorn.core.llm.ToolInputSchemaKt;
import com.intellij.ml.llm.matterhorn.core.llm.openai.ParamUtilsKt;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.OpenAIResponsesRequest;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.CreateResponsePayload;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.FunctionCallOutput;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.FunctionTool;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.FunctionToolCall;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.InputContent;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.InputItem;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.InputMessage;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.OpenAIResponsesToolChoice;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.Reasoning;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.ReasoningAnswer;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.ReasoningEffort;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.ReasoningSummary;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.Role;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.TextProperties;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.TextVerbosity;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.schema.Tool;
import com.intellij.ml.llm.matterhorn.llm.MatterhornAssistantChatMessageWithToolUses;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChat;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageImagePart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageKind;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessagePart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageTextPart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageToolResultPart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatReasoning;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatReasoningWithId;
import com.intellij.ml.llm.matterhorn.llm.MatterhornMultiPartChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornTool;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolResult;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolUse;
import com.intellij.ml.llm.matterhorn.llm.MatterhornUserChatMessageWithToolResults;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.llm.ToolKind;
import com.intellij.ml.llm.matterhorn.llm.ToolRequestArgumentSchema;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPropertyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/matterhorn/core/llm/openai/responses/OpenAIResponsesClient;", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmClient;", "<init>", "()V", "createRequest", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmRequest;", "chat", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "propertyProvider", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;", "mapToInputItems", "", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatElement;", "inputItems", "", "Lcom/intellij/ml/llm/matterhorn/core/llm/openai/responses/schema/InputItem;", "toTool", "Lcom/intellij/ml/llm/matterhorn/core/llm/openai/responses/schema/Tool;", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornTool;", "toImageUrl", "", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatMessageImagePart;", "tryCleanupId", "tryGetCallId", "llm"})
@SourceDebugExtension(value={"SMAP\nOpenAIResponsesClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAIResponsesClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/openai/responses/OpenAIResponsesClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n1563#3:169\n1634#3,3:170\n1869#3,2:173\n1869#3,2:175\n1869#3,2:177\n1563#3:179\n1634#3,3:180\n*S KotlinDebug\n*F\n+ 1 OpenAIResponsesClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/openai/responses/OpenAIResponsesClient\n*L\n47#1:169\n47#1:170,3\n76#1:173,2\n100#1:175,2\n115#1:177,2\n130#1:179\n130#1:180,3\n*E\n"})
public final class OpenAIResponsesClient
implements LlmClient {
    @NotNull
    public static final OpenAIResponsesClient INSTANCE = new OpenAIResponsesClient();

    private OpenAIResponsesClient() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LlmRequest createRequest(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull MatterhornPropertyProvider propertyProvider) {
        Reasoning reasoning;
        TextProperties textProperties;
        OpenAIResponsesToolChoice openAIResponsesToolChoice;
        Collection collection;
        List list;
        TextVerbosity it;
        Iterator iterator;
        Map map;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        Intrinsics.checkNotNullParameter((Object)propertyProvider, (String)"propertyProvider");
        if (!ModelParameters.Companion.isOpenAIReasoningModel(modelParameters)) {
            map = modelParameters.getStop();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
        } else {
            map = MapsKt.emptyMap();
        }
        Map stopReasons = map;
        String string = modelParameters.getModel().getName();
        Object object = CollectionsKt.createListBuilder();
        List $this$createRequest_u24lambda_u240 = object;
        boolean bl = false;
        if (((CharSequence)chat.getSystem()).length() > 0 && chat.getPreviousAnswerChoiceId() == null) {
            $this$createRequest_u24lambda_u240.add(new InputMessage(Role.SYSTEM, new InputContent.SimpleText(chat.getSystem())));
        }
        Object object2 = chat.getMessages().iterator();
        while (object2.hasNext()) {
            MatterhornChatElement message = (MatterhornChatElement)object2.next();
            INSTANCE.mapToInputItems(message, $this$createRequest_u24lambda_u240);
        }
        List list2 = CollectionsKt.build((List)object);
        object = chat.getPreviousAnswerChoiceId();
        Object it2 = object2 = chat.getTools();
        boolean bl22 = false;
        Object object3 = !it2.isEmpty() ? object2 : null;
        if (object3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object3;
            boolean $i$f$map = false;
            Iterable bl22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                MatterhornTool matterhornTool = (MatterhornTool)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(INSTANCE.toTool((MatterhornTool)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list3 = list;
        Object object4 = chat.getTools();
        if (object4.isEmpty()) {
            boolean bl4 = false;
            collection = null;
        } else {
            collection = object4;
        }
        List list4 = (List)collection;
        if (list4 != null) {
            List it3 = list4;
            boolean bl5 = false;
            openAIResponsesToolChoice = OpenAIResponsesToolChoice.Companion.from(chat.getToolChoice());
        } else {
            openAIResponsesToolChoice = null;
        }
        OpenAIResponsesToolChoice openAIResponsesToolChoice2 = openAIResponsesToolChoice;
        object2 = !ModelParameters.Companion.isOpenAIReasoningModel(modelParameters) ? modelParameters.getTemperature() : null;
        object4 = modelParameters.getTopP();
        CreateResponsePayload.Truncation truncation = CreateResponsePayload.Truncation.Auto;
        Boolean bl6 = ParamUtilsKt.getParallelToolCalls(modelParameters, chat.getToolChoice(), !chat.getTools().isEmpty());
        if (ModelParameters.Companion.isOpenAIReasoningModel(modelParameters) && !ModelParameters.Companion.isO(modelParameters)) {
            TextVerbosity textVerbosity = TextVerbosity.Companion.fromString(modelParameters.getTextVerbosity());
            if (textVerbosity != null) {
                it = textVerbosity;
                boolean bl7 = false;
                textProperties = new TextProperties(null, it, 1, null);
            } else {
                textProperties = null;
            }
        } else {
            textProperties = null;
        }
        TextProperties textProperties2 = textProperties;
        Iterator iterator2 = iterator = ModelParameters.Companion.isOpenAIReasoningModel(modelParameters) && Intrinsics.areEqual((Object)modelParameters.getIncludeEncryptedContent(), (Object)true) ? CollectionsKt.listOf((Object)"reasoning.encrypted_content") : null;
        if (ModelParameters.Companion.isOpenAIReasoningModel(modelParameters)) {
            ReasoningEffort reasoningEffort = ReasoningEffort.Companion.fromString(modelParameters.getReasoningEffort());
            if (reasoningEffort != null) {
                ReasoningEffort it4 = reasoningEffort;
                boolean bl8 = false;
                reasoning = new Reasoning(it4);
            } else {
                reasoning = null;
            }
        } else {
            reasoning = null;
        }
        Reasoning reasoning2 = reasoning;
        boolean bl9 = Intrinsics.areEqual((Object)modelParameters.getStream(), (Object)true);
        boolean bl10 = modelParameters.getUseAnswerChoiceId();
        CreateResponsePayload body = new CreateResponsePayload(string, list2, (String)object, list3, (List)((Object)iterator), null, (Double)object2, (Double)object4, truncation, bl6, bl9, null, openAIResponsesToolChoice2, textProperties2, reasoning2, bl10, 2080, null);
        return new OpenAIResponsesRequest(body, stopReasons, modelParameters.getModel(), modelParameters.getModel().getProvider(), propertyProvider);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void mapToInputItems(MatterhornChatElement $this$mapToInputItems, List<InputItem> inputItems) {
        Iterator iterator;
        Collection destination$iv$iv;
        block25: {
            Iterator iterator22;
            block24: {
                block22: {
                    MatterhornChatElement matterhornChatElement;
                    block23: {
                        block21: {
                            List list = $this$mapToInputItems.getReasoning();
                            if (list != null) {
                                List it = list;
                                boolean iterator22 = false;
                                Iterable iterable = it;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : iterable) {
                                    MatterhornChatReasoning singleReasoning = (MatterhornChatReasoning)element$iv;
                                    boolean bl = false;
                                    if (!(singleReasoning instanceof MatterhornChatReasoningWithId)) continue;
                                    inputItems.add(new ReasoningAnswer(((MatterhornChatReasoningWithId)singleReasoning).getId(), CollectionsKt.listOf((Object)new ReasoningSummary("summary_text", "")), ((MatterhornChatReasoningWithId)singleReasoning).getEncryptedContent(), null, 8, null));
                                }
                            }
                            if ((matterhornChatElement = $this$mapToInputItems) instanceof MatterhornChatMessage) {
                                Role role = switch (WhenMappings.$EnumSwitchMapping$0[((MatterhornChatMessage)$this$mapToInputItems).getKind().ordinal()]) {
                                    case 1 -> Role.ASSISTANT;
                                    case 2 -> Role.USER;
                                    default -> throw new NoWhenBranchMatchedException();
                                };
                                inputItems.add(new InputMessage(role, new InputContent.SimpleText(((MatterhornChatMessage)$this$mapToInputItems).getContent())));
                                return;
                            }
                            if (!(matterhornChatElement instanceof MatterhornAssistantChatMessageWithToolUses)) break block21;
                            if (((CharSequence)((MatterhornAssistantChatMessageWithToolUses)$this$mapToInputItems).getContent()).length() > 0) {
                                inputItems.add(new InputMessage(Role.ASSISTANT, new InputContent.SimpleText(((MatterhornAssistantChatMessageWithToolUses)$this$mapToInputItems).getContent())));
                            }
                            break block22;
                        }
                        if (!(matterhornChatElement instanceof MatterhornUserChatMessageWithToolResults)) break block23;
                        Iterable $this$forEach$iv = ((MatterhornUserChatMessageWithToolResults)$this$mapToInputItems).getToolResults();
                        boolean $i$f$forEach = false;
                        iterator22 = $this$forEach$iv.iterator();
                        break block24;
                    }
                    if (!(matterhornChatElement instanceof MatterhornMultiPartChatMessage)) throw new NoWhenBranchMatchedException();
                    Iterable $this$map$iv = ((MatterhornMultiPartChatMessage)$this$mapToInputItems).getParts();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    iterator = iterable.iterator();
                    break block25;
                }
                Iterable $this$forEach$iv = ((MatterhornAssistantChatMessageWithToolUses)$this$mapToInputItems).getToolUses();
                boolean $i$f$forEach = false;
                Iterator iterator22 = $this$forEach$iv.iterator();
                while (iterator22.hasNext()) {
                    Object t = iterator22.next();
                    MatterhornToolUse toolUse = (MatterhornToolUse)t;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)toolUse.getName(), (Object)"computer_use_preview")) {
                        throw new IllegalArgumentException("Computer tool is not supported yet");
                    }
                    String string = toolUse.getCallId();
                    if (string == null && (string = INSTANCE.tryGetCallId(toolUse.getId())) == null) {
                        throw new IllegalArgumentException("Call id cannot be null for toolUse: " + toolUse);
                    }
                    ToolRequestArgumentSchema toolRequestArgumentSchema = toolUse.getInput();
                    FunctionToolCall toolCall = new FunctionToolCall(INSTANCE.tryCleanupId(toolUse.getId()), string, toolUse.getName(), String.valueOf(toolRequestArgumentSchema != null ? toolRequestArgumentSchema.getRawJsonObject() : null), null, null, 48, null);
                    inputItems.add(toolCall);
                }
                return;
            }
            while (iterator22.hasNext()) {
                FunctionCallOutput callOutput;
                block26: {
                    String string;
                    Object t = iterator22.next();
                    MatterhornToolResult toolResult = (MatterhornToolResult)t;
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$1[toolResult.getKind().ordinal()]) {
                        case 1: {
                            string = toolResult.getCallId();
                            if (string == null && (string = INSTANCE.tryGetCallId(toolResult.getId())) == null) {
                                throw new IllegalArgumentException("Call id cannot be null for toolResult: " + toolResult);
                            }
                        }
                        callOutput = new FunctionCallOutput(string, toolResult.getContent());
                        break block26;
                        case 2: {
                            throw new NotImplementedError("Computer tool call is not supported yet");
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                inputItems.add(callOutput);
            }
            if (!(((CharSequence)((MatterhornUserChatMessageWithToolResults)$this$mapToInputItems).getContent()).length() > 0)) return;
            inputItems.add(new InputMessage(Role.USER, new InputContent.SimpleText(((MatterhornUserChatMessageWithToolResults)$this$mapToInputItems).getContent())));
            return;
        }
        while (iterator.hasNext()) {
            InputContent.ContentPart contentPart;
            void part;
            Object item$iv$iv = iterator.next();
            MatterhornChatMessagePart bl = (MatterhornChatMessagePart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var14_33 = part;
            if (var14_33 instanceof MatterhornChatMessageTextPart) {
                contentPart = new InputContent.InputTextPart(((MatterhornChatMessageTextPart)part).getText());
            } else {
                if (!(var14_33 instanceof MatterhornChatMessageImagePart)) {
                    if (!(var14_33 instanceof MatterhornChatMessageToolResultPart)) throw new NoWhenBranchMatchedException();
                    throw new IllegalStateException("Tool result parts are not supported for OpenAI");
                }
                contentPart = new InputContent.InputImagePart(INSTANCE.toImageUrl((MatterhornChatMessageImagePart)part), null, 2, null);
            }
            collection.add(contentPart);
        }
        List contentParts = (List)destination$iv$iv;
        if (!(!((Collection)contentParts).isEmpty())) return;
        inputItems.add(new InputMessage(Role.USER, new InputContent.ContentParts(contentParts)));
    }

    private final Tool toTool(MatterhornTool $this$toTool) {
        MatterhornTool matterhornTool = $this$toTool;
        if (matterhornTool instanceof MatterhornTool.PredefinedTool) {
            throw new IllegalStateException("Predefined tools are not supported for OpenAI");
        }
        if (!(matterhornTool instanceof MatterhornTool.UserTool)) {
            throw new NoWhenBranchMatchedException();
        }
        return new FunctionTool(((MatterhornTool.UserTool)$this$toTool).getName(), ((MatterhornTool.UserTool)$this$toTool).getDescription(), ToolInputSchemaKt.toToolInputSchema(((MatterhornTool.UserTool)$this$toTool).getParams()).asJsonObject(), false, 8, null);
    }

    private final String toImageUrl(MatterhornChatMessageImagePart $this$toImageUrl) {
        return "data:" + $this$toImageUrl.getContentType() + ";base64," + $this$toImageUrl.getBase64();
    }

    private final String tryCleanupId(String $this$tryCleanupId) {
        String string;
        String[] stringArray = new String[]{":"};
        if (StringsKt.split$default((CharSequence)$this$tryCleanupId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() == 3) {
            stringArray = new String[]{":"};
            string = (String)StringsKt.split$default((CharSequence)$this$tryCleanupId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        } else {
            string = $this$tryCleanupId;
        }
        return string;
    }

    private final String tryGetCallId(String $this$tryGetCallId) {
        String string;
        String[] stringArray = new String[]{":"};
        if (StringsKt.split$default((CharSequence)$this$tryGetCallId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() == 3) {
            stringArray = new String[]{":"};
            string = (String)StringsKt.split$default((CharSequence)$this$tryGetCallId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(2);
        } else {
            string = null;
        }
        return string;
    }

    static {
        EnvExtensionsKt.assertHasMatterhornProxy((Env)BuildConfigKt.getConfig());
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MatterhornChatMessageKind.values().length];
            try {
                nArray[MatterhornChatMessageKind.Assistant.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatterhornChatMessageKind.User.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolKind.values().length];
            try {
                nArray[ToolKind.FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.COMPUTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

