/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm.openai;

import com.intellij.ml.llm.matterhorn.configuration.BuildConfigKt;
import com.intellij.ml.llm.matterhorn.configuration.Env;
import com.intellij.ml.llm.matterhorn.configuration.EnvExtensionsKt;
import com.intellij.ml.llm.matterhorn.core.llm.LlmClient;
import com.intellij.ml.llm.matterhorn.core.llm.LlmRequest;
import com.intellij.ml.llm.matterhorn.core.llm.ToolInputSchemaKt;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIChatRequest;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIFunction;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIFunctionDeclaration;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIFunctionTool;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIMessage;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIToolCall;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAiChatRequestBody;
import com.intellij.ml.llm.matterhorn.core.llm.openai.completion.OpenAIContent;
import com.intellij.ml.llm.matterhorn.llm.MatterhornAssistantChatMessageWithToolUses;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChat;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatAnswerFormat;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageImagePart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageKind;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessagePart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageTextPart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageToolResultPart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornMultiPartChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornTool;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolChoice;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolResult;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolUse;
import com.intellij.ml.llm.matterhorn.llm.MatterhornUserChatMessageWithToolResults;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.llm.StopSequenceType;
import com.intellij.ml.llm.matterhorn.llm.ToolRequestArgumentSchema;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPropertyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0005*\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAIChatCompletionsClient;", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmClient;", "<init>", "()V", "OPENAI_USER_ROLE", "", "OPENAI_ASSISTANT_ROLE", "OPENAI_SYSTEM", "OPENAI_FUNCTION", "createRequest", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmRequest;", "chat", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "propertyProvider", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;", "createOpenAIRequestBody", "Lcom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAiChatRequestBody;", "stopReasons", "", "Lcom/intellij/ml/llm/matterhorn/llm/StopSequenceType;", "createOpenAIRequestBody$llm", "toTool", "Lcom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAIFunctionTool;", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornTool;", "toOpenAIContent", "", "Lcom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAIMessage;", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatElement;", "toImageUrl", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatMessageImagePart;", "llm"})
@SourceDebugExtension(value={"SMAP\nOpenAIChatCompletionsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAIChatCompletionsClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAIChatCompletionsClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,133:1\n1869#2,2:134\n1563#2:137\n1634#2,3:138\n1563#2:147\n1634#2,3:148\n1563#2:151\n1634#2,3:152\n1563#2:155\n1634#2,3:156\n1#3:136\n29#4,2:141\n29#4,3:143\n31#4:146\n*S KotlinDebug\n*F\n+ 1 OpenAIChatCompletionsClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/openai/OpenAIChatCompletionsClient\n*L\n55#1:134,2\n59#1:137\n59#1:138,3\n97#1:147\n97#1:148,3\n107#1:151\n107#1:152,3\n119#1:155\n119#1:156,3\n63#1:141,2\n65#1:143,3\n63#1:146\n*E\n"})
public final class OpenAIChatCompletionsClient
implements LlmClient {
    @NotNull
    public static final OpenAIChatCompletionsClient INSTANCE = new OpenAIChatCompletionsClient();
    @NotNull
    public static final String OPENAI_USER_ROLE = "user";
    @NotNull
    public static final String OPENAI_ASSISTANT_ROLE = "assistant";
    @NotNull
    public static final String OPENAI_SYSTEM = "system";
    @NotNull
    public static final String OPENAI_FUNCTION = "function";

    private OpenAIChatCompletionsClient() {
    }

    @Override
    @NotNull
    public LlmRequest createRequest(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull MatterhornPropertyProvider propertyProvider) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        Intrinsics.checkNotNullParameter((Object)propertyProvider, (String)"propertyProvider");
        Map map = modelParameters.getStop();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map stopReasons = map;
        OpenAiChatRequestBody body = this.createOpenAIRequestBody$llm(chat, modelParameters, stopReasons);
        return new OpenAIChatRequest(body, stopReasons, modelParameters.getModel(), modelParameters.getModel().getProvider(), propertyProvider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OpenAiChatRequestBody createOpenAIRequestBody$llm(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull Map<String, ? extends StopSequenceType> stopReasons) {
        JsonObject jsonObject;
        Collection collection;
        List list;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        Intrinsics.checkNotNullParameter(stopReasons, (String)"stopReasons");
        String systemRole = ModelParameters.Companion.isO(modelParameters) ? OPENAI_ASSISTANT_ROLE : OPENAI_SYSTEM;
        List messages = new ArrayList();
        messages.add(new OpenAIMessage(systemRole, new OpenAIContent.OpenAIContentText(chat.getSystem()), null, null, null, 28, null));
        Iterable $this$forEach$iv = chat.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            MatterhornChatElement message = (MatterhornChatElement)element$iv2;
            boolean bl = false;
            messages.addAll((Collection)INSTANCE.toOpenAIContent(message));
        }
        Object it = element$iv2 = chat.getTools();
        boolean bl2 = false;
        Object object = !it.isEmpty() ? element$iv2 : null;
        if (object != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MatterhornTool matterhornTool = (MatterhornTool)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(INSTANCE.toTool((MatterhornTool)it2));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        Collection collection3 = CollectionsKt.toList((Iterable)stopReasons.keySet());
        if (collection3.isEmpty()) {
            boolean bl4 = false;
            collection = null;
        } else {
            collection = collection3;
        }
        List list3 = (List)collection;
        MatterhornChatAnswerFormat matterhornChatAnswerFormat = chat.getAnswerFormat();
        MatterhornChatAnswerFormat.JsonSchema jsonSchema = matterhornChatAnswerFormat instanceof MatterhornChatAnswerFormat.JsonSchema ? (MatterhornChatAnswerFormat.JsonSchema)matterhornChatAnswerFormat : null;
        if (jsonSchema != null) {
            void $this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245_u24lambda_u244;
            JsonObjectBuilder builder$iv;
            JsonObjectBuilder builder$iv2;
            MatterhornChatAnswerFormat.JsonSchema schema = jsonSchema;
            boolean bl5 = false;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245 = builder$iv2 = new JsonObjectBuilder();
            boolean bl6 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245, (String)"type", (String)"json_schema");
            boolean $i$f$buildJsonObject2 = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
            String string = "json_schema";
            JsonObjectBuilder jsonObjectBuilder2 = $this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245;
            boolean bl7 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245_u24lambda_u244, (String)"name", (String)schema.getName());
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245_u24lambda_u244, (String)"strict", (Boolean)true);
            $this$createOpenAIRequestBody_u24lambda_u246_u24lambda_u245_u24lambda_u244.put("schema", (JsonElement)schema.getSchema());
            Unit unit = Unit.INSTANCE;
            jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
            jsonObject = builder$iv2.build();
        } else {
            jsonObject = null;
        }
        collection3 = jsonObject;
        MatterhornToolChoice matterhornToolChoice = chat.getToolChoice();
        OpenAiChatRequestBody body = new OpenAiChatRequestBody(modelParameters, messages, matterhornToolChoice, list2, list3, (JsonObject)collection3);
        return body;
    }

    private final OpenAIFunctionTool toTool(MatterhornTool $this$toTool) {
        MatterhornTool matterhornTool = $this$toTool;
        if (matterhornTool instanceof MatterhornTool.PredefinedTool) {
            throw new IllegalStateException("Predefined tools are not supported for OpenAI");
        }
        if (!(matterhornTool instanceof MatterhornTool.UserTool)) {
            throw new NoWhenBranchMatchedException();
        }
        return new OpenAIFunctionTool(new OpenAIFunctionDeclaration(((MatterhornTool.UserTool)$this$toTool).getName(), ((MatterhornTool.UserTool)$this$toTool).getDescription(), ToolInputSchemaKt.toToolInputSchema(((MatterhornTool.UserTool)$this$toTool).getParams()).asJsonObject()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenAIMessage> toOpenAIContent(MatterhornChatElement $this$toOpenAIContent) {
        List list;
        String role = WhenMappings.$EnumSwitchMapping$0[$this$toOpenAIContent.getKind().ordinal()] == 1 ? OPENAI_USER_ROLE : OPENAI_ASSISTANT_ROLE;
        MatterhornChatElement matterhornChatElement = $this$toOpenAIContent;
        if (matterhornChatElement instanceof MatterhornChatMessage) {
            list = CollectionsKt.listOf((Object)new OpenAIMessage(role, new OpenAIContent.OpenAIContentText(((MatterhornChatMessage)$this$toOpenAIContent).getContent()), null, null, null, 28, null));
        } else if (matterhornChatElement instanceof MatterhornUserChatMessageWithToolResults) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((MatterhornUserChatMessageWithToolResults)$this$toOpenAIContent).getToolResults();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void toolResult;
                MatterhornToolResult matterhornToolResult = (MatterhornToolResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = toolResult.getId();
                OpenAIContent.OpenAIContentText openAIContentText = new OpenAIContent.OpenAIContentText(toolResult.getContent());
                collection.add(new OpenAIMessage("tool", openAIContentText, null, string, null, 20, null));
            }
            list = (List)destination$iv$iv;
        } else if (matterhornChatElement instanceof MatterhornAssistantChatMessageWithToolUses) {
            Collection<OpenAIToolCall> collection;
            Iterable $this$map$iv = ((MatterhornAssistantChatMessageWithToolUses)$this$toOpenAIContent).getToolUses();
            OpenAIContent openAIContent = new OpenAIContent.OpenAIContentText(((MatterhornAssistantChatMessageWithToolUses)$this$toOpenAIContent).getContent());
            String string = role;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void toolUse;
                MatterhornToolUse toolResult = (MatterhornToolUse)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ToolRequestArgumentSchema toolRequestArgumentSchema = toolUse.getInput();
                collection.add(new OpenAIToolCall(toolUse.getId(), OPENAI_FUNCTION, new OpenAIFunction(toolUse.getName(), String.valueOf(toolRequestArgumentSchema != null ? toolRequestArgumentSchema.getRawJsonObject() : null))));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 24;
            List list2 = null;
            String string2 = null;
            List list3 = collection;
            OpenAIContent openAIContent2 = openAIContent;
            String string3 = string;
            list = CollectionsKt.listOf((Object)new OpenAIMessage(string3, openAIContent2, list3, string2, list2, n, defaultConstructorMarker));
        } else if (matterhornChatElement instanceof MatterhornMultiPartChatMessage) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((MatterhornMultiPartChatMessage)$this$toOpenAIContent).getParts();
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OpenAIContent.OpenAIContentPart openAIContentPart;
                void part;
                MatterhornChatMessagePart bl = (MatterhornChatMessagePart)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                void var14_34 = part;
                if (var14_34 instanceof MatterhornChatMessageTextPart) {
                    openAIContentPart = new OpenAIContent.OpenAIContentPartText(((MatterhornChatMessageTextPart)part).getText());
                } else if (var14_34 instanceof MatterhornChatMessageImagePart) {
                    openAIContentPart = new OpenAIContent.OpenAIContentPartImage(new OpenAIContent.ImageUrl(INSTANCE.toImageUrl((MatterhornChatMessageImagePart)part), null, 2, null));
                } else {
                    if (var14_34 instanceof MatterhornChatMessageToolResultPart) {
                        throw new IllegalStateException("Tool result parts are not supported for OpenAI");
                    }
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(openAIContentPart);
            }
            List contentParts = (List)destination$iv$iv2;
            list = CollectionsKt.listOf((Object)new OpenAIMessage(role, new OpenAIContent.OpenAIContentParts(contentParts), null, null, null, 28, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final String toImageUrl(MatterhornChatMessageImagePart $this$toImageUrl) {
        return "data:" + $this$toImageUrl.getContentType() + ";base64," + $this$toImageUrl.getBase64();
    }

    static {
        EnvExtensionsKt.assertHasMatterhornProxy((Env)BuildConfigKt.getConfig());
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatterhornChatMessageKind.values().length];
            try {
                nArray[MatterhornChatMessageKind.User.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

