/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm.anthropic;

import com.intellij.ml.llm.matterhorn.core.llm.LlmClient;
import com.intellij.ml.llm.matterhorn.core.llm.LlmRequest;
import com.intellij.ml.llm.matterhorn.core.llm.ToolInputSchemaKt;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicBaseKt;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicChatMessage;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicChatRequest;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicChatRequestBody;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicContent;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicToolChoiceParam;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicToolParam;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChat;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatKt;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageKind;
import com.intellij.ml.llm.matterhorn.llm.MatterhornTool;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolArgument;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolChoice;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPropertyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/matterhorn/core/llm/anthropic/AnthropicClient;", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmClient;", "<init>", "()V", "checkChatForAnthropic", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;", "separator", "", "createRequest", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmRequest;", "chat", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "propertyProvider", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;", "llm"})
@SourceDebugExtension(value={"SMAP\nAnthropicClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/anthropic/AnthropicClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1#2:112\n1193#3,2:113\n1267#3,4:115\n*S KotlinDebug\n*F\n+ 1 AnthropicClient.kt\ncom/intellij/ml/llm/matterhorn/core/llm/anthropic/AnthropicClient\n*L\n65#1:113,2\n65#1:115,4\n*E\n"})
public final class AnthropicClient
implements LlmClient {
    @NotNull
    public static final AnthropicClient INSTANCE = new AnthropicClient();

    private AnthropicClient() {
    }

    @NotNull
    public final MatterhornChat checkChatForAnthropic(@NotNull MatterhornChat $this$checkChatForAnthropic, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChatForAnthropic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        List newMessages = new ArrayList();
        for (MatterhornChatElement message : $this$checkChatForAnthropic.getMessages()) {
            boolean bl;
            if (message instanceof MatterhornChatMessage) {
                CharSequence charSequence;
                CharSequence charSequence2 = ((MatterhornChatMessage)message).getContent();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = "<empty>";
                } else {
                    charSequence = charSequence2;
                }
                String content = (String)charSequence;
                Object object = CollectionsKt.lastOrNull((List)newMessages);
                MatterhornChatMessage matterhornChatMessage = object instanceof MatterhornChatMessage ? (MatterhornChatMessage)object : null;
                if ((matterhornChatMessage != null ? matterhornChatMessage.getKind() : null) == ((MatterhornChatMessage)message).getKind()) {
                    Object e = newMessages.removeLast();
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage");
                    MatterhornChatMessage last = (MatterhornChatMessage)e;
                    bl = newMessages.add(new MatterhornChatMessage(last.getContent() + separator + content, ((MatterhornChatMessage)message).getKind(), null, null, null, 28, null));
                    continue;
                }
                bl = newMessages.add(new MatterhornChatMessage(content, ((MatterhornChatMessage)message).getKind(), null, null, null, 28, null));
                continue;
            }
            bl = newMessages.add(message);
        }
        return MatterhornChat.copy$default((MatterhornChat)$this$checkChatForAnthropic, null, (List)CollectionsKt.toList((Iterable)newMessages), null, null, null, null, null, (int)125, null);
    }

    public static /* synthetic */ MatterhornChat checkChatForAnthropic$default(AnthropicClient anthropicClient, MatterhornChat matterhornChat, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "\n----------------------------\n";
        }
        return anthropicClient.checkChatForAnthropic(matterhornChat, string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LlmRequest createRequest(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull MatterhornPropertyProvider propertyProvider) {
        Collection collection;
        Collection collection2;
        String string;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        Intrinsics.checkNotNullParameter((Object)propertyProvider, (String)"propertyProvider");
        MatterhornChat safe = AnthropicClient.checkChatForAnthropic$default(this, chat, null, 1, null);
        if (chat.getAnswerFormat() != null) {
            throw new UnsupportedOperationException("Answer format for anthropic models is not supported.");
        }
        List messages = new ArrayList();
        List tools = new ArrayList();
        MatterhornToolChoice it = safe.getToolChoice();
        boolean bl = false;
        Object object = it;
        if (object instanceof MatterhornToolChoice.Auto) {
            string = "auto";
        } else if (object instanceof MatterhornToolChoice.Any) {
            string = "any";
        } else if (object instanceof MatterhornToolChoice.Tool) {
            string = "tool";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        MatterhornToolChoice.Tool tool = it instanceof MatterhornToolChoice.Tool ? (MatterhornToolChoice.Tool)it : null;
        AnthropicToolChoiceParam toolChoiceParam = new AnthropicToolChoiceParam(string, tool != null ? tool.getName() : null, !it.getAllowMultiple());
        for (Object tool2 : safe.getTools()) {
            boolean bl2;
            if (tool2 instanceof MatterhornTool.PredefinedTool) {
                Map map;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                object = ((MatterhornTool.PredefinedTool)tool2).getSettings();
                JsonObject jsonObject = null;
                String string2 = ((MatterhornTool.PredefinedTool)tool2).getDescription();
                String string3 = ((MatterhornTool.PredefinedTool)tool2).getType();
                String string4 = ((MatterhornTool.PredefinedTool)tool2).getName();
                List list = tools;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var14_22 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    MatterhornToolArgument it2 = (MatterhornToolArgument)element$iv$iv;
                    boolean bl3 = false;
                    Pair pair = TuplesKt.to((Object)it2.getName(), (Object)it2.toJsonElement());
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map map3 = map = destination$iv$iv;
                JsonObject jsonObject2 = jsonObject;
                String string5 = string2;
                String string6 = string3;
                String string7 = string4;
                bl2 = list.add(new AnthropicToolParam(string7, string6, string5, jsonObject2, map3));
                continue;
            }
            bl2 = tools.add(new AnthropicToolParam(tool2.getName(), null, tool2.getDescription(), ToolInputSchemaKt.toToolInputSchema(tool2.getParams()).asJsonObject(), null, 18, null));
        }
        int userMessageOffset = 0;
        for (MatterhornChatElement message : safe.getMessages()) {
            boolean shouldCache = MatterhornChatKt.shouldAddCachePoint((List)safe.getMessages(), (ModelParameters)modelParameters, (MatterhornChatElement)message, (int)userMessageOffset);
            List<AnthropicContent> messagesContent = AnthropicBaseKt.toAnthropicContent(message, shouldCache);
            String role = switch (WhenMappings.$EnumSwitchMapping$0[message.getKind().ordinal()]) {
                case 1 -> "user";
                case 2 -> "assistant";
                default -> throw new NoWhenBranchMatchedException();
            };
            messages.add(new AnthropicChatMessage(role, messagesContent));
            userMessageOffset += WhenMappings.$EnumSwitchMapping$0[message.getKind().ordinal()] == 1 ? 1 : 0;
        }
        Map map = modelParameters.getStop();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map stopReasons = map;
        object = safe.getSystem();
        Object object2 = tools;
        if (object2.isEmpty()) {
            boolean bl4 = false;
            collection2 = null;
        } else {
            collection2 = object2;
        }
        List list = (List)collection2;
        Object object3 = toolChoiceParam;
        AnthropicToolChoiceParam it3 = object3;
        boolean bl5 = false;
        object2 = !tools.isEmpty() ? object3 : null;
        Collection collection3 = CollectionsKt.toList((Iterable)stopReasons.keySet());
        if (collection3.isEmpty()) {
            boolean bl6 = false;
            collection = null;
        } else {
            collection = collection3;
        }
        object3 = (List)collection;
        AnthropicChatRequestBody body = new AnthropicChatRequestBody(modelParameters, (String)object, messages, list, (AnthropicToolChoiceParam)object2, (List<String>)object3);
        return new AnthropicChatRequest(body, stopReasons, modelParameters, modelParameters.getPromptCacheEnabled(), propertyProvider);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatterhornChatMessageKind.values().length];
            try {
                nArray[MatterhornChatMessageKind.User.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatterhornChatMessageKind.Assistant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

