/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm;

import com.intellij.ml.llm.matterhorn.core.llm.AICache;
import com.intellij.ml.llm.matterhorn.core.llm.LlmClient;
import com.intellij.ml.llm.matterhorn.core.llm.MatterhornLlmClientProvider;
import com.intellij.ml.llm.matterhorn.core.llm.anthropic.AnthropicLlmClientProvider;
import com.intellij.ml.llm.matterhorn.core.llm.openai.OpenAIChatCompletionsClient;
import com.intellij.ml.llm.matterhorn.core.llm.openai.responses.OpenAIResponsesClient;
import com.intellij.ml.llm.matterhorn.llm.LLM;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.utils.DelayStrategy;
import com.intellij.ml.llm.matterhorn.utils.EnvUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u001a\b\u0010\u000f\u001a\u00020\u000eH\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "buildLlmClientsMapping", "", "Lcom/intellij/ml/llm/matterhorn/llm/LLM;", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmClient;", "modelProviders", "", "Lcom/intellij/ml/llm/matterhorn/core/llm/MatterhornLlmClientProvider;", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "getDefaultDelayStrategy", "Lcom/intellij/ml/llm/matterhorn/utils/DelayStrategy;", "getDefaultDelayStrategyForRateLimit", "llm"})
@SourceDebugExtension(value={"SMAP\nMatterhornAIProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatterhornAIProxy.kt\ncom/intellij/ml/llm/matterhorn/core/llm/MatterhornAIProxyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n827#3:202\n855#3,2:203\n*S KotlinDebug\n*F\n+ 1 MatterhornAIProxy.kt\ncom/intellij/ml/llm/matterhorn/core/llm/MatterhornAIProxyKt\n*L\n182#1:202\n182#1:203,2\n*E\n"})
public final class MatterhornAIProxyKt {
    private static final Logger logger = LoggerFactory.getLogger(AICache.class);

    /*
     * WARNING - void declaration
     */
    private static final Map<LLM, LlmClient> buildLlmClientsMapping(List<? extends MatterhornLlmClientProvider> modelProviders, ModelParameters modelParameters) {
        void $this$filterNotTo$iv$iv;
        Map map;
        Map $this$buildLlmClientsMapping_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (MatterhornLlmClientProvider provider : CollectionsKt.plus((Collection)modelProviders, (Object)new AnthropicLlmClientProvider())) {
            LlmClient client = provider.getClient();
            for (LLM llm : provider.getLLMs()) {
                if (!(!$this$buildLlmClientsMapping_u24lambda_u242.containsKey(llm))) {
                    boolean bl2 = false;
                    String string = "LLM " + llm.getName() + " already registered with " + Reflection.getOrCreateKotlinClass(MapsKt.getValue((Map)$this$buildLlmClientsMapping_u24lambda_u242, (Object)llm).getClass()).getSimpleName() + " client";
                    throw new IllegalArgumentException(string.toString());
                }
                $this$buildLlmClientsMapping_u24lambda_u242.put(llm, client);
            }
        }
        Iterable $this$filterNot$iv = LLM.Companion.getKnownModels();
        boolean $i$f$filterNot = false;
        Object object = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            LLM it = (LLM)element$iv$iv;
            boolean bl3 = false;
            if ($this$buildLlmClientsMapping_u24lambda_u242.containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LLM llm : (List)destination$iv$iv) {
            Map map2 = $this$buildLlmClientsMapping_u24lambda_u242;
            object = Intrinsics.areEqual((Object)modelParameters.getModeApiVersion(), (Object)"openai-responses") ? (LlmClient)OpenAIResponsesClient.INSTANCE : (LlmClient)OpenAIChatCompletionsClient.INSTANCE;
            map2.put(llm, object);
        }
        return MapsKt.build((Map)map);
    }

    private static final DelayStrategy getDefaultDelayStrategy() {
        return EnvUtilsKt.isOnTeamcityEval() ? (DelayStrategy)new DelayStrategy.Constant(4, 30000) : (DelayStrategy)new DelayStrategy.RandomExponential(3, 500, 2.0);
    }

    private static final DelayStrategy getDefaultDelayStrategyForRateLimit() {
        return EnvUtilsKt.isOnTeamcityEval() ? (DelayStrategy)new DelayStrategy.Constant(1000, 30000) : (DelayStrategy)new DelayStrategy.RandomExponential(16, 500, Math.sqrt(2.0));
    }

    public static final /* synthetic */ DelayStrategy access$getDefaultDelayStrategy() {
        return MatterhornAIProxyKt.getDefaultDelayStrategy();
    }

    public static final /* synthetic */ DelayStrategy access$getDefaultDelayStrategyForRateLimit() {
        return MatterhornAIProxyKt.getDefaultDelayStrategyForRateLimit();
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ Map access$buildLlmClientsMapping(List modelProviders, ModelParameters modelParameters) {
        return MatterhornAIProxyKt.buildLlmClientsMapping(modelProviders, modelParameters);
    }
}

