/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm;

import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.CustomArtifactEvent;
import com.intellij.ml.llm.matterhorn.LLMContextLengthExceeded;
import com.intellij.ml.llm.matterhorn.LLMCountryForbiddenException;
import com.intellij.ml.llm.matterhorn.LLMPaymentRequiredException;
import com.intellij.ml.llm.matterhorn.LLMRateLimitError;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.ml.llm.matterhorn.configuration.BuildConfigKt;
import com.intellij.ml.llm.matterhorn.configuration.Env;
import com.intellij.ml.llm.matterhorn.configuration.EnvExtensionsKt;
import com.intellij.ml.llm.matterhorn.core.llm.AICache;
import com.intellij.ml.llm.matterhorn.core.llm.LLMAccess;
import com.intellij.ml.llm.matterhorn.core.llm.LlmClient;
import com.intellij.ml.llm.matterhorn.core.llm.LlmRequest;
import com.intellij.ml.llm.matterhorn.core.llm.MatterhornAIProxy;
import com.intellij.ml.llm.matterhorn.core.llm.MatterhornAIProxyKt;
import com.intellij.ml.llm.matterhorn.core.llm.MatterhornLlmClientProvider;
import com.intellij.ml.llm.matterhorn.llm.AIAnswer;
import com.intellij.ml.llm.matterhorn.llm.LLM;
import com.intellij.ml.llm.matterhorn.llm.LLMProxyImpl;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChat;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPropertyProvider;
import com.intellij.ml.llm.matterhorn.utils.DelayStrategy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0016J2\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00142\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0096@\u00a2\u0006\u0002\u0010*J\u001e\u0010+\u001a\u00020)2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010,J2\u0010-\u001a\u00020\"2\"\u0010.\u001a\u001e\b\u0001\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"01\u0012\u0006\u0012\u0004\u0018\u0001020/H\u0082@\u00a2\u0006\u0002\u00103R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/matterhorn/core/llm/MatterhornAIProxy;", "Lcom/intellij/ml/llm/matterhorn/llm/LLMProxyImpl;", "llmAccess", "Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;", "matterhornCaches", "Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "propertyProvider", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;", "delayStrategy", "Lcom/intellij/ml/llm/matterhorn/utils/DelayStrategy;", "delayStrategyForRateLimit", "modelProviders", "", "Lcom/intellij/ml/llm/matterhorn/core/llm/MatterhornLlmClientProvider;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;Lcom/intellij/ml/llm/matterhorn/utils/DelayStrategy;Lcom/intellij/ml/llm/matterhorn/utils/DelayStrategy;Ljava/util/List;)V", "getLlmAccess", "()Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;", "llmClients", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "", "Lcom/intellij/ml/llm/matterhorn/llm/LLM;", "Lcom/intellij/ml/llm/matterhorn/core/llm/LlmClient;", "nonCachedRequests", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "imagesSupported", "", "getImagesSupported", "()Z", "toString", "", "sendChat", "Lcom/intellij/ml/llm/matterhorn/llm/AIAnswer;", "chat", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;", "modelParameters", "eventHandler", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/matterhorn/CustomArtifactEvent;", "", "(Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logNonCachedRequest", "(Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChat;Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendWithRecovery", "send", "Lkotlin/Function2;", "", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "llm"})
public final class MatterhornAIProxy
extends LLMProxyImpl {
    @NotNull
    private final LLMAccess llmAccess;
    @NotNull
    private final MatterhornCaches matterhornCaches;
    @NotNull
    private final MatterhornPropertyProvider propertyProvider;
    @NotNull
    private final DelayStrategy delayStrategy;
    @NotNull
    private final DelayStrategy delayStrategyForRateLimit;
    @NotNull
    private final List<MatterhornLlmClientProvider> modelProviders;
    @NotNull
    private final ConcurrentHashMap<ModelParameters, Map<LLM, LlmClient>> llmClients;
    @NotNull
    private final StringBuilder nonCachedRequests;

    public MatterhornAIProxy(@NotNull LLMAccess llmAccess, @NotNull MatterhornCaches matterhornCaches, @NotNull MatterhornPropertyProvider propertyProvider, @NotNull DelayStrategy delayStrategy, @NotNull DelayStrategy delayStrategyForRateLimit, @NotNull List<? extends MatterhornLlmClientProvider> modelProviders) {
        Intrinsics.checkNotNullParameter((Object)llmAccess, (String)"llmAccess");
        Intrinsics.checkNotNullParameter((Object)matterhornCaches, (String)"matterhornCaches");
        Intrinsics.checkNotNullParameter((Object)propertyProvider, (String)"propertyProvider");
        Intrinsics.checkNotNullParameter((Object)delayStrategy, (String)"delayStrategy");
        Intrinsics.checkNotNullParameter((Object)delayStrategyForRateLimit, (String)"delayStrategyForRateLimit");
        Intrinsics.checkNotNullParameter(modelProviders, (String)"modelProviders");
        this.llmAccess = llmAccess;
        this.matterhornCaches = matterhornCaches;
        this.propertyProvider = propertyProvider;
        this.delayStrategy = delayStrategy;
        this.delayStrategyForRateLimit = delayStrategyForRateLimit;
        this.modelProviders = modelProviders;
        EnvExtensionsKt.assertHasMatterhornProxy((Env)BuildConfigKt.getConfig());
        this.llmClients = new ConcurrentHashMap();
        this.nonCachedRequests = new StringBuilder();
    }

    public /* synthetic */ MatterhornAIProxy(LLMAccess lLMAccess, MatterhornCaches matterhornCaches, MatterhornPropertyProvider matterhornPropertyProvider, DelayStrategy delayStrategy, DelayStrategy delayStrategy2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            delayStrategy = MatterhornAIProxyKt.access$getDefaultDelayStrategy();
        }
        if ((n & 0x10) != 0) {
            delayStrategy2 = MatterhornAIProxyKt.access$getDefaultDelayStrategyForRateLimit();
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(lLMAccess, matterhornCaches, matterhornPropertyProvider, delayStrategy, delayStrategy2, list);
    }

    @NotNull
    public final LLMAccess getLlmAccess() {
        return this.llmAccess;
    }

    public boolean getImagesSupported() {
        return BuildConfigKt.getConfig().getBinaryAttachments();
    }

    @NotNull
    public String toString() {
        return "MatterhornAIProxy(" + this.llmAccess.getClass().getSimpleName() + ")";
    }

    @Nullable
    public Object sendChat(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull Function1<? super CustomArtifactEvent, Unit> eventHandler, @NotNull Continuation<? super AIAnswer> $completion) {
        if (ModelParameters.Companion.isServerMode(modelParameters)) {
            throw new NotImplementedError("Server mode not implemented. See MatterhornEnvironmentServer if you need it.");
        }
        Map map = this.llmClients.computeIfAbsent(modelParameters, arg_0 -> MatterhornAIProxy.sendChat$lambda$1(arg_0 -> MatterhornAIProxy.sendChat$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map clients = map;
        Object v = clients.get(modelParameters.getModel());
        if (v == null) {
            boolean bl = false;
            String string = "LLM client not found for model: " + modelParameters.getModel().getName();
            throw new IllegalArgumentException(string.toString());
        }
        LlmClient client = (LlmClient)v;
        return this.sendWithRecovery((Function2<? super Integer, ? super Continuation<? super AIAnswer>, ? extends Object>)((Function2)new Function2<Integer, Continuation<? super AIAnswer>, Object>(this, chat, modelParameters, eventHandler, client, null){
            int label;
            /* synthetic */ int I$0;
            final /* synthetic */ MatterhornAIProxy this$0;
            final /* synthetic */ MatterhornChat $chat;
            final /* synthetic */ ModelParameters $modelParameters;
            final /* synthetic */ Function1<CustomArtifactEvent, Unit> $eventHandler;
            final /* synthetic */ LlmClient $client;
            {
                this.this$0 = $receiver;
                this.$chat = $chat;
                this.$modelParameters = $modelParameters;
                this.$eventHandler = $eventHandler;
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int currentAttempt = this.I$0;
                        this.label = 1;
                        Object object3 = MatterhornAIProxy.access$withArtifactEvents(this.this$0, this.$chat, this.$modelParameters, this.$eventHandler, currentAttempt, (Function1)new Function1<Continuation<? super AIAnswer>, Object>(this.$client, this.$chat, this.$modelParameters, this.this$0, null){
                            int label;
                            final /* synthetic */ LlmClient $client;
                            final /* synthetic */ MatterhornChat $chat;
                            final /* synthetic */ ModelParameters $modelParameters;
                            final /* synthetic */ MatterhornAIProxy this$0;
                            {
                                this.$client = $client;
                                this.$chat = $chat;
                                this.$modelParameters = $modelParameters;
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        LlmRequest request = this.$client.createRequest(this.$chat, this.$modelParameters, MatterhornAIProxy.access$getPropertyProvider$p(this.this$0));
                                        this.label = 1;
                                        Object object3 = request.send(this.this$0.getLlmAccess(), (Continuation<? super AIAnswer>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super AIAnswer> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.I$0 = ((Number)value).intValue();
                return (Continuation)var3_3;
            }

            public final Object invoke(int p1, Continuation<? super AIAnswer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object logNonCachedRequest(@NotNull MatterhornChat chat, @NotNull ModelParameters modelParameters, @NotNull Continuation<? super Unit> $completion) {
        StringBuilder stringBuilder = this.nonCachedRequests;
        synchronized (stringBuilder) {
            boolean bl = false;
            StringBuilder stringBuilder2 = this.nonCachedRequests.append(AICache.Companion.getQueryHash(chat, modelParameters)).append('\n');
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MatterhornAIProxy this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MatterhornCaches matterhornCaches = MatterhornAIProxy.access$getMatterhornCaches$p(this.this$0);
                        String string = MatterhornAIProxy.access$getNonCachedRequests$p(this.this$0).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        matterhornCaches.saveSingle(CacheType.NonCachedRequests, string);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendWithRecovery(Function2<? super Integer, ? super Continuation<? super AIAnswer>, ? extends Object> var1_1, Continuation<? super AIAnswer> $completion) {
        block19: {
            if (!($completion instanceof sendWithRecovery.1)) ** GOTO lbl-1000
            var8_3 = $completion;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MatterhornAIProxy this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return MatterhornAIProxy.access$sendWithRecovery(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    currentAttempt = 0;
                    delaysValues = this.delayStrategy.getDelays().iterator();
                    delaysValuesForRateLimit = this.delayStrategyForRateLimit.getDelays().iterator();
lbl16:
                    // 4 sources

                    while (true) {
                        $continuation.L$0 = send;
                        $continuation.L$1 = delaysValues;
                        $continuation.L$2 = delaysValuesForRateLimit;
                        $continuation.I$0 = currentAttempt;
                        $continuation.label = 1;
                        v0 = send.invoke((Object)Boxing.boxInt((int)currentAttempt), (Object)$continuation);
                        ** if (v0 != var9_5) goto lbl27
lbl26:
                        // 1 sources

                        return var9_5;
lbl27:
                        // 1 sources

                        ** GOTO lbl37
                        break;
                    }
                }
                case 1: {
                    currentAttempt = $continuation.I$0;
                    delaysValuesForRateLimit = (Iterator)$continuation.L$2;
                    delaysValues = (Iterator)$continuation.L$1;
                    send = (Function2)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl37:
                        // 2 sources

                        return v0;
                    }
                    catch (LLMPaymentRequiredException e) {
                        throw e;
                    }
                    catch (LLMCountryForbiddenException e) {
                        throw e;
                    }
                    catch (LLMContextLengthExceeded e) {
                        throw e;
                    }
                    catch (LLMRateLimitError e) {
                        if (!delaysValuesForRateLimit.hasNext()) break;
                        MatterhornAIProxyKt.access$getLogger$p().warn(e.getMessage());
                        $continuation.L$0 = send;
                        $continuation.L$1 = delaysValues;
                        $continuation.L$2 = delaysValuesForRateLimit;
                        $continuation.I$0 = currentAttempt;
                        $continuation.label = 2;
                        v1 = DelayKt.delay((long)((Number)delaysValuesForRateLimit.next()).longValue(), (Continuation)$continuation);
                        if (v1 != var9_5) ** GOTO lbl16
                        return var9_5;
                    }
                }
                case 2: {
                    currentAttempt = $continuation.I$0;
                    delaysValuesForRateLimit = (Iterator)$continuation.L$2;
                    delaysValues = (Iterator)$continuation.L$1;
                    send = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl16
                }
            }
            throw e;
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (!delaysValues.hasNext()) break block19;
                MatterhornAIProxyKt.access$getLogger$p().warn("sendWithRecovery failed with exception", (Throwable)e);
                $continuation.L$0 = send;
                $continuation.L$1 = delaysValues;
                $continuation.L$2 = delaysValuesForRateLimit;
                $continuation.I$0 = ++currentAttempt;
                $continuation.label = 3;
                v2 = DelayKt.delay((long)((Number)delaysValues.next()).longValue(), (Continuation)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl85
            }
            {
                case 3: {
                    currentAttempt = $continuation.I$0;
                    delaysValuesForRateLimit = (Iterator)$continuation.L$2;
                    delaysValues = (Iterator)$continuation.L$1;
                    send = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl85:
                    // 2 sources

                    ** continue;
                }
            }
        }
        throw e;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Map sendChat$lambda$0(MatterhornAIProxy this$0, ModelParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return MatterhornAIProxyKt.access$buildLlmClientsMapping(this$0.modelProviders, params);
    }

    private static final Map sendChat$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$withArtifactEvents(MatterhornAIProxy $this, MatterhornChat chat, ModelParameters modelParameters, Function1 eventHandler, int currentAttempt, Function1 request, Continuation $completion) {
        return $this.withArtifactEvents(chat, modelParameters, eventHandler, currentAttempt, request, $completion);
    }

    public static final /* synthetic */ MatterhornPropertyProvider access$getPropertyProvider$p(MatterhornAIProxy $this) {
        return $this.propertyProvider;
    }

    public static final /* synthetic */ MatterhornCaches access$getMatterhornCaches$p(MatterhornAIProxy $this) {
        return $this.matterhornCaches;
    }

    public static final /* synthetic */ StringBuilder access$getNonCachedRequests$p(MatterhornAIProxy $this) {
        return $this.nonCachedRequests;
    }

    public static final /* synthetic */ Object access$sendWithRecovery(MatterhornAIProxy $this, Function2 send2, Continuation $completion) {
        return $this.sendWithRecovery((Function2<? super Integer, ? super Continuation<? super AIAnswer>, ? extends Object>)send2, (Continuation<? super AIAnswer>)$completion);
    }
}

