/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.core.llm;

import com.intellij.ml.llm.matterhorn.configuration.BuildConfigKt;
import com.intellij.ml.llm.matterhorn.configuration.Env;
import com.intellij.ml.llm.matterhorn.configuration.EnvExtensionsKt;
import com.intellij.ml.llm.matterhorn.core.llm.KeyNotFoundException;
import com.intellij.ml.llm.matterhorn.core.llm.LLMAccess;
import com.intellij.ml.llm.matterhorn.core.llm.LlmProviderKt;
import com.intellij.ml.llm.matterhorn.core.llm.SecretModelNameCoroutineElement;
import com.intellij.ml.llm.matterhorn.core.llm.SecretModelNameKey;
import com.intellij.ml.llm.matterhorn.core.llm.UrlNotFoundException;
import com.intellij.ml.llm.matterhorn.core.llm.ingrazzio.IngrazzioAccessToken;
import com.intellij.ml.llm.matterhorn.llm.LlmProvider;
import com.intellij.ml.llm.matterhorn.settings.CoreProperties;
import com.intellij.ml.llm.matterhorn.settings.MatterhornProperty;
import com.intellij.ml.llm.matterhorn.settings.MatterhornPropertyProvider;
import io.ktor.client.request.BuildersKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.UtilsKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0002\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\r\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u0010\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0012\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a(\u0010\u0015\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a.\u0010\u0019\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0080@\u00a2\u0006\u0002\u0010\u001d\u001aZ\u0010\u001e\u001a\u00020\u0014\"\u0006\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010 \u001a\u0002H\u001f2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050#0\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0080H\u00a2\u0006\u0002\u0010&\u001aG\u0010'\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0002\b+H\u0080@\u00a2\u0006\u0002\u0010,\u001a\u001c\u0010-\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006."}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "getDefaultUrl", "", "Lcom/intellij/ml/llm/matterhorn/llm/LlmProvider;", "getUrlPropertyName", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornProperty;", "getKeyProperty", "getUrlSafe", "propertyProvider", "Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;", "(Lcom/intellij/ml/llm/matterhorn/llm/LlmProvider;Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getKeySafe", "getUrl", "getKey", "getIngrazzioUrl", "(Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBaseHttpRequestBuilder", "Lio/ktor/client/request/HttpRequestBuilder;", "createDirectRequestBuilder", "chatApiUrl", "path", "key", "createIngrazzioRequestBuilder", "ingrazzioUrl", "token", "Lcom/intellij/ml/llm/matterhorn/core/llm/ingrazzio/IngrazzioAccessToken;", "(Lcom/intellij/ml/llm/matterhorn/llm/LlmProvider;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/core/llm/ingrazzio/IngrazzioAccessToken;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequest", "T", "body", "additionalHeaders", "", "Lkotlin/Pair;", "llmAccess", "Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;", "(Lcom/intellij/ml/llm/matterhorn/llm/LlmProvider;Ljava/lang/Object;Ljava/util/List;Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequestBuilder", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/ml/llm/matterhorn/llm/LlmProvider;Lcom/intellij/ml/llm/matterhorn/settings/MatterhornPropertyProvider;Lcom/intellij/ml/llm/matterhorn/core/llm/LLMAccess;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCustomPathUrl", "llm"})
@SourceDebugExtension(value={"SMAP\nLlmProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmProvider.kt\ncom/intellij/ml/llm/matterhorn/core/llm/LlmProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class LlmProviderKt {
    private static final Logger logger = LoggerFactory.getLogger(LlmProvider.class);

    private static final String getDefaultUrl(LlmProvider $this$getDefaultUrl) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getDefaultUrl.ordinal()]) {
            case 1 -> "https://api.openai.com/v1/chat/completions";
            case 2 -> "https://api.openai.com/v1/chat/completions";
            case 3 -> "https://api.anthropic.com/v1/messages";
            case 4 -> "http://195.242.16.31/openai/api/v1/chat/completions";
            case 5 -> "https://api.studio.nebius.com/v1/chat/completions";
            case 6 -> "https://api.deepseek.com/v1/chat/completions";
            case 7 -> "https://generativelanguage.googleapis.com/v1beta/openai/chat/completions";
            case 8 -> "https://api.mistral.ai/v1/chat/completions";
            case 9 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final MatterhornProperty getUrlPropertyName(LlmProvider $this$getUrlPropertyName) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getUrlPropertyName.ordinal()]) {
            case 1 -> CoreProperties.INSTANCE.getOPENAI_API_URL();
            case 2 -> CoreProperties.INSTANCE.getOPENAI_API_URL();
            case 3 -> CoreProperties.INSTANCE.getANTHROPIC_API_URL();
            case 4 -> CoreProperties.INSTANCE.getNEBIUS_API_URL();
            case 5 -> CoreProperties.INSTANCE.getNEBIUS_PROD_API_URL();
            case 6 -> CoreProperties.INSTANCE.getDEEPSEEK_API_URL();
            case 7 -> CoreProperties.INSTANCE.getGOOGLE_MODEL_URL();
            case 8 -> CoreProperties.INSTANCE.getMISTRAL_MODEL_URL();
            case 9 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final MatterhornProperty getKeyProperty(LlmProvider $this$getKeyProperty) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getKeyProperty.ordinal()]) {
            case 1 -> CoreProperties.INSTANCE.getOPENAI_MODEL_KEY();
            case 2 -> CoreProperties.INSTANCE.getOPENAI_MODEL_KEY();
            case 3 -> CoreProperties.INSTANCE.getANTHROPIC_MODEL_KEY();
            case 4 -> CoreProperties.INSTANCE.getNEBIUS_MODEL_KEY();
            case 5 -> CoreProperties.INSTANCE.getNEBIUS_PROD_MODEL_KEY();
            case 6 -> CoreProperties.INSTANCE.getDEEPSEEK_MODEL_KEY();
            case 7 -> CoreProperties.INSTANCE.getGOOGLE_MODEL_KEY();
            case 8 -> CoreProperties.INSTANCE.getMISTRAL_MODEL_KEY();
            case 9 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final Object getUrlSafe(@NotNull LlmProvider $this$getUrlSafe, @NotNull MatterhornPropertyProvider propertyProvider, @NotNull Continuation<? super String> $completion) {
        MatterhornProperty matterhornProperty = LlmProviderKt.getUrlPropertyName($this$getUrlSafe);
        Intrinsics.checkNotNull((Object)matterhornProperty);
        MatterhornProperty urlProperty = matterhornProperty;
        String string = propertyProvider.getProperty(urlProperty);
        if (string == null) {
            string = LlmProviderKt.getDefaultUrl($this$getUrlSafe);
        }
        return string;
    }

    @Nullable
    public static final Object getKeySafe(@NotNull LlmProvider $this$getKeySafe, @NotNull MatterhornPropertyProvider propertyProvider, @NotNull Continuation<? super String> $completion) {
        String string;
        MatterhornProperty keyProperty;
        MatterhornProperty matterhornProperty = keyProperty = LlmProviderKt.getKeyProperty($this$getKeySafe);
        if (matterhornProperty != null) {
            MatterhornProperty it = matterhornProperty;
            boolean bl = false;
            string = propertyProvider.getProperty(keyProperty);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final Object getUrl(@NotNull LlmProvider $this$getUrl, @NotNull MatterhornPropertyProvider propertyProvider, @NotNull Continuation<? super String> $completion) {
        MatterhornProperty matterhornProperty = LlmProviderKt.getUrlPropertyName($this$getUrl);
        Intrinsics.checkNotNull((Object)matterhornProperty);
        MatterhornProperty urlProperty = matterhornProperty;
        String string = propertyProvider.getProperty(urlProperty);
        if (string == null && (string = LlmProviderKt.getDefaultUrl($this$getUrl)) == null) {
            throw new UrlNotFoundException(urlProperty.getName());
        }
        return string;
    }

    @Nullable
    public static final Object getKey(@NotNull LlmProvider $this$getKey, @NotNull MatterhornPropertyProvider propertyProvider, @NotNull Continuation<? super String> $completion) {
        MatterhornProperty matterhornProperty = LlmProviderKt.getKeyProperty($this$getKey);
        Intrinsics.checkNotNull((Object)matterhornProperty);
        MatterhornProperty keyProperty = matterhornProperty;
        String string = propertyProvider.getProperty(keyProperty);
        if (string == null) {
            throw new KeyNotFoundException(keyProperty.getName());
        }
        return string;
    }

    @Nullable
    public static final Object getIngrazzioUrl(@NotNull MatterhornPropertyProvider propertyProvider, @NotNull Continuation<? super String> $completion) {
        String string = propertyProvider.getProperty(CoreProperties.INSTANCE.getINGRAZZIO_URL());
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (string == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        return string;
    }

    private static final HttpRequestBuilder createBaseHttpRequestBuilder() {
        return BuildersKt.request(LlmProviderKt::createBaseHttpRequestBuilder$lambda$1);
    }

    @NotNull
    public static final HttpRequestBuilder createDirectRequestBuilder(@NotNull LlmProvider $this$createDirectRequestBuilder, @NotNull String chatApiUrl, @Nullable String path, @NotNull String key) {
        String string;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$createDirectRequestBuilder, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)chatApiUrl, (String)"chatApiUrl");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                string = path;
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                String string2 = LlmProviderKt.getCustomPathUrl($this$createDirectRequestBuilder, chatApiUrl, it);
                string = string2;
                if (string2 != null) break block6;
            }
            string = chatApiUrl;
        }
        String url = string;
        EnvExtensionsKt.assertHasDirectAccess((Env)BuildConfigKt.getConfig());
        String string3 = key.substring(Math.max(0, key.length() - 5));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        logger.info("Sending request to " + url + ", key: " + string3 + "...");
        HttpRequestBuilder builder = LlmProviderKt.createBaseHttpRequestBuilder();
        HttpRequestKt.url((HttpRequestBuilder)builder, (String)url);
        if (WhenMappings.$EnumSwitchMapping$0[$this$createDirectRequestBuilder.ordinal()] == 3) {
            builder.getHeaders().append("x-api-key", key);
        } else {
            UtilsKt.bearerAuth((HttpMessageBuilder)((HttpMessageBuilder)builder), (String)key);
        }
        return builder;
    }

    public static /* synthetic */ HttpRequestBuilder createDirectRequestBuilder$default(LlmProvider llmProvider, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return LlmProviderKt.createDirectRequestBuilder(llmProvider, string, string2, string3);
    }

    @Nullable
    public static final Object createIngrazzioRequestBuilder(@NotNull LlmProvider $this$createIngrazzioRequestBuilder, @NotNull String ingrazzioUrl, @Nullable String path, @NotNull IngrazzioAccessToken token, @NotNull Continuation<? super HttpRequestBuilder> $completion) {
        String string;
        Object object;
        block10: {
            block9: {
                EnvExtensionsKt.assertHasIngrazzio((Env)BuildConfigKt.getConfig());
                object = path;
                if (object == null) break block9;
                String it = object;
                boolean bl = false;
                String string2 = StringsKt.removeSuffix((String)ingrazzioUrl, (CharSequence)"/") + it;
                object = string2;
                if (string2 != null) break block10;
            }
            object = ingrazzioUrl;
        }
        String url = object;
        HttpRequestBuilder builder = LlmProviderKt.createBaseHttpRequestBuilder();
        logger.info("Sending request to ingrazzio...");
        HttpRequestKt.url((HttpRequestBuilder)builder, (String)url);
        UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)builder), (String)"Authorization", (Object)token.getAuthorizationHeaderValue());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$createIngrazzioRequestBuilder.ordinal()]) {
            case 3: {
                string = "anthropic";
                break;
            }
            case 1: {
                string = "openai";
                break;
            }
            case 2: {
                SecretModelNameCoroutineElement secretModelNameCoroutineElement = (SecretModelNameCoroutineElement)$completion.getContext().get((CoroutineContext.Key)SecretModelNameKey.INSTANCE);
                String modelName = secretModelNameCoroutineElement != null ? secretModelNameCoroutineElement.getName() : null;
                string = modelName;
                if (string != null) break;
                string = "openai";
                break;
            }
            default: {
                throw new IllegalStateException("Nebius is not supported".toString());
            }
        }
        String modelName = string;
        builder.getHeaders().append("X-LLM-Model", modelName);
        if (path != null) {
            builder.getHeaders().append("X-Keep-Path", "true");
        }
        return builder;
    }

    public static /* synthetic */ Object createIngrazzioRequestBuilder$default(LlmProvider llmProvider, String string, String string2, IngrazzioAccessToken ingrazzioAccessToken, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return LlmProviderKt.createIngrazzioRequestBuilder(llmProvider, string, string2, ingrazzioAccessToken, (Continuation<? super HttpRequestBuilder>)continuation);
    }

    public static final /* synthetic */ <T> Object createRequest(LlmProvider $this$createRequest, T body, List<Pair<String, String>> additionalHeaders, MatterhornPropertyProvider propertyProvider, LLMAccess llmAccess, String path, Continuation<? super HttpRequestBuilder> $completion) {
        boolean $i$f$createRequest = false;
        Intrinsics.needClassReification();
        Function1 function1 = (Function1)new Function1<HttpRequestBuilder, Unit>(additionalHeaders, body){
            final /* synthetic */ List<Pair<String, String>> $additionalHeaders;
            final /* synthetic */ T $body;
            {
                this.$additionalHeaders = $additionalHeaders;
                this.$body = $body;
            }

            public final void invoke(HttpRequestBuilder $this$createRequestBuilder) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)$this$createRequestBuilder, (String)"$this$createRequestBuilder");
                Iterable $this$forEach$iv = this.$additionalHeaders;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    pair = (Pair)element$iv;
                    boolean bl = false;
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    $this$createRequestBuilder.getHeaders().append(name, value);
                }
                $this$forEach$iv = $this$createRequestBuilder;
                T body$iv = this.$body;
                boolean $i$f$setBody = false;
                T t = body$iv;
                if (t == null) {
                    KType kType;
                    $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                    pair = $this$setBody$iv;
                    $i$f$typeInfo = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    var8_10 = Reflection.getOrCreateKotlinClass(Object.class);
                    boolean $i$f$typeOfOrNull = false;
                    try {
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                        kType = null;
                    }
                    catch (Throwable throwable) {
                        kType = null;
                    }
                    KType kType2 = kType;
                    KClass kClass = var8_10;
                    pair.setBodyType(new TypeInfo(kClass, kType2));
                } else if (t instanceof OutgoingContent) {
                    $this$setBody$iv.setBody(body$iv);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    KType kType;
                    $this$setBody$iv.setBody(body$iv);
                    pair = $this$setBody$iv;
                    $i$f$typeInfo = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    var8_10 = Reflection.getOrCreateKotlinClass(Object.class);
                    boolean $i$f$typeOfOrNull = false;
                    try {
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                        kType = null;
                    }
                    catch (Throwable throwable) {
                        kType = null;
                    }
                    KType kType3 = kType;
                    KClass kClass = var8_10;
                    pair.setBodyType(new TypeInfo(kClass, kType3));
                }
            }
        };
        InlineMarker.mark((int)0);
        Object object = LlmProviderKt.createRequestBuilder($this$createRequest, propertyProvider, llmAccess, path, (Function1<? super HttpRequestBuilder, Unit>)function1, $completion);
        InlineMarker.mark((int)1);
        return object;
    }

    public static /* synthetic */ Object createRequest$default(LlmProvider $this$createRequest_u24default, Object body, List additionalHeaders, MatterhornPropertyProvider propertyProvider, LLMAccess llmAccess, String path, Continuation $completion, int n, Object object) {
        if ((n & 2) != 0) {
            additionalHeaders = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        boolean $i$f$createRequest = false;
        Intrinsics.needClassReification();
        Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
        InlineMarker.mark((int)0);
        Object object2 = LlmProviderKt.createRequestBuilder($this$createRequest_u24default, propertyProvider, llmAccess, path, (Function1<? super HttpRequestBuilder, Unit>)function1, (Continuation<? super HttpRequestBuilder>)$completion);
        InlineMarker.mark((int)1);
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object createRequestBuilder(@NotNull LlmProvider var0, @NotNull MatterhornPropertyProvider var1_1, @NotNull LLMAccess var2_2, @Nullable String var3_3, @NotNull Function1<? super HttpRequestBuilder, Unit> var4_4, @NotNull Continuation<? super HttpRequestBuilder> $completion) {
        if (!($completion instanceof createRequestBuilder.1)) ** GOTO lbl-1000
        var8_6 = $completion;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LlmProviderKt.createRequestBuilder(null, null, null, null, null, (Continuation<? super HttpRequestBuilder>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = block;
                $continuation.label = 1;
                v0 = var2_2.createRequestBuilder(var0, var1_1, (String)path, (Continuation<? super HttpRequestBuilder>)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl22
            }
            case 1: {
                block = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                builder = (HttpRequestBuilder)v0;
                block.invoke((Object)builder);
                return builder;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object createRequestBuilder$default(LlmProvider llmProvider, MatterhornPropertyProvider matterhornPropertyProvider, LLMAccess lLMAccess, String string, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return LlmProviderKt.createRequestBuilder(llmProvider, matterhornPropertyProvider, lLMAccess, string, (Function1<? super HttpRequestBuilder, Unit>)function1, (Continuation<? super HttpRequestBuilder>)continuation);
    }

    private static final String getCustomPathUrl(LlmProvider $this$getCustomPathUrl, String chatApiUrl, String path) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getCustomPathUrl.ordinal()]) {
            case 1: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 2: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 3: {
                string = LlmProviderKt.getCustomPathUrl$replacePath(chatApiUrl, "/v1/messages", path);
                break;
            }
            case 4: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 5: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 6: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 7: {
                String v1ApiPath = StringsKt.removePrefix((String)path, (CharSequence)"/v1/");
                if (Intrinsics.areEqual((Object)v1ApiPath, (Object)path)) {
                    throw new IllegalArgumentException("Google only supports v1 api paths");
                }
                return LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, "/v1beta/" + v1ApiPath);
            }
            case 8: {
                string = LlmProviderKt.getCustomPathUrl$replaceOpenAIPath(chatApiUrl, path);
                break;
            }
            case 9: {
                throw new IllegalArgumentException("Server mode does not support base url");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final Unit createBaseHttpRequestBuilder$lambda$1(HttpRequestBuilder $this$request) {
        Intrinsics.checkNotNullParameter((Object)$this$request, (String)"$this$request");
        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$request), (ContentType)ContentType.Application.INSTANCE.getJson());
        UtilsKt.accept((HttpMessageBuilder)((HttpMessageBuilder)$this$request), (ContentType)ContentType.Text.INSTANCE.getEventStream());
        $this$request.setMethod(HttpMethod.Companion.getPost());
        return Unit.INSTANCE;
    }

    private static final String getCustomPathUrl$replacePath(String url, String expectedPath, String path) {
        String baseUrl = StringsKt.removeSuffix((String)url, (CharSequence)expectedPath);
        if (((CharSequence)expectedPath).length() > 0 && Intrinsics.areEqual((Object)baseUrl, (Object)url)) {
            throw new IllegalArgumentException("Url " + url + " does not end with " + expectedPath);
        }
        return baseUrl + path;
    }

    private static final String getCustomPathUrl$replaceOpenAIPath(String url, String path) {
        return LlmProviderKt.getCustomPathUrl$replacePath(url, "/v1/chat/completions", path);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LlmProvider.values().length];
            try {
                nArray[LlmProvider.OpenAI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.OpenAI_SECRET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.Anthropic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.Nebius.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.NebiusProd.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.DeepSeek.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.Google.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.Mistral.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LlmProvider.ServerMode.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

