/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FileBasedIndexSupport;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSElementTypesImpl;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.gist.JSCachedDataService;
import com.intellij.lang.javascript.index.gist.JSStubElementGistSupport;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedDataBuilder;
import com.intellij.lang.javascript.psi.impl.JSFunctionNodesVisitor;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReturnedExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.structure.JSTypeStructure;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionBaseImpl<T extends JSFunctionStubBase<?>>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSFunction,
JSCachingNamespaceOwner {
    private String name;
    private static final Key<ParameterizedCachedValue<JSVariable, JSFunctionBaseImpl<?>>> ARGUMENTS_VAR_KEY = Key.create((String)"js.arguments.var");
    private static final ParameterizedCachedValueProvider<JSVariable, JSFunctionBaseImpl<?>> ARGUMENTS_VAR_PROVIDER = fun -> {
        String type = fun.getArgumentsClassName();
        JSParameterList parameterList = fun.getParameterList();
        ImplicitJSVariableImpl argumentsVar = new ImplicitJSVariableImpl("arguments", type, (PsiElement)(parameterList != null ? parameterList : fun));
        return CachedValueProvider.Result.create((Object)argumentsVar, (Object[])new Object[]{fun});
    };
    private static final Key<ParameterizedCachedValue<JSFunctionCachedData, JSFunctionBaseImpl<?>>> DATA_KEY = Key.create((String)"js.function.base.cached.data");
    private static final ParameterizedCachedValueProvider<JSFunctionCachedData, JSFunctionBaseImpl<?>> DATA_PROVIDER = psi -> {
        JSFunctionCachedData value = JSCachedDataService.getInstance(psi.getProject()).getData((JSFunctionBaseImpl<?>)psi);
        return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{psi.getContainingFile()});
    };
    private static final Key<ParameterizedCachedValue<JSType, JSFunctionBaseImpl<?>>> TYPE_KEY = Key.create((String)"js.function.base.type");
    private static final ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>> TYPE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>>(){

        @NotNull
        public CachedValueProvider.Result<JSType> compute(JSFunctionBaseImpl<?> psi) {
            CachedValueProvider.Result<JSType> result = 2.captureCompute(psi);
            if (result == null) {
                2.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static <StubT extends JSFunctionStubBase<?>> CachedValueProvider.Result<JSType> captureCompute(JSFunctionBaseImpl<StubT> psi) {
            JSType typeFromDeclaration;
            JSFunctionStubBase stub = (JSFunctionStubBase)psi.getGreenStub();
            JSType returnType = stub != null ? ((typeFromDeclaration = psi.getReturnTypeFromDeclaration()) != null ? typeFromDeclaration : psi.getCachedData().getReturnType(psi)) : psi.initReturnType(null);
            return CachedValueProvider.Result.create((Object)returnType, (Object[])new Object[]{psi});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$2", "compute"));
        }
    };

    public JSFunctionBaseImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionBaseImpl(T stub, IElementType type) {
        super(stub, type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.name = null;
        JSParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            for (JSParameter p : parameterList.getParameterVariables()) {
                ((JSParameterImpl)p).clearCaches();
            }
        }
    }

    @Override
    @Nullable
    public JSBlockStatement getBlock() {
        ASTNode[] blocks = this.getNode().getChildren(JSElementTypes.BLOCK_STATEMENTS);
        return blocks.length == 1 ? (JSBlockStatement)ObjectUtils.tryCast((Object)blocks[0].getPsi(), JSBlockStatement.class) : null;
    }

    @Override
    public JSParameterList getParameterList() {
        return this.getStubOrPsiChild(JSElementTypesImpl.PARAMETER_LIST);
    }

    @Override
    public PsiElement getReturnTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(0);
        }
        if (JSVariableBaseImpl.setComputedPropertyName(name, this)) {
            return this;
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode newNameElement = JSChangeUtil.createPropertyNameWithContext(name, nameIdentifier);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, newNameElement);
        }
        this.name = null;
        return this;
    }

    protected boolean canHaveAccessorKeywordAfterFunctionName() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this);
        return holder != null && holder.hasFeature(JSLanguageFeature.E4X);
    }

    @Override
    public boolean isGetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGetProperty();
        }
        return this.checkIsModifier(JSAttributeList.ModifierType.GET, JSTokenTypes.GET_KEYWORD);
    }

    private boolean checkIsModifier(@NotNull JSAttributeList.ModifierType modifierType, @NotNull IElementType elementType) {
        JSAttributeList attributeList;
        if (modifierType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(2);
        }
        if ((attributeList = this.getAttributeList()) != null && attributeList.hasModifier(modifierType)) {
            return true;
        }
        if (!this.canHaveAccessorKeywordAfterFunctionName()) {
            return false;
        }
        ASTNode node = this.getNode().findChildByType(elementType);
        return node != null && node != this.findNameIdentifier();
    }

    @Override
    public boolean isSetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isSetProperty();
        }
        return this.checkIsModifier(JSAttributeList.ModifierType.SET, JSTokenTypes.SET_KEYWORD);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.doGetName();
        }
        return this.name;
    }

    protected String doGetName() {
        String nameFromComputed;
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)((Object)this)).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        ASTNode name = this.findNameIdentifier();
        boolean computed = false;
        if (name == null) {
            name = JSPsiImplUtils.getComputedNameOfFunction(this.getNode(), false);
            computed = true;
        }
        if (name != null) {
            if (computed) {
                PsiElement psi = name.getPsi();
                if (psi instanceof ES6ComputedName) {
                    return ((ES6ComputedName)psi).getExpressionAsPropertyName();
                }
                return JSPsiImplUtils.getNameFromIdentifier(name);
            }
            return JSPsiImplUtils.getNameFromIdentifier(name);
        }
        return null;
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSPsiImplUtils.findNameIdentifierOfFunction(this.getNode());
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(5);
        }
        if ((funInternalDefsProcessingOptions = JSFunctionBaseImpl.getProcessingOptions(processor)).toProcessFunctionBodyDeclarations(lastParent, this)) {
            return this.processInnerAndBodyDeclarations(processor, state, lastParent, place, funInternalDefsProcessingOptions);
        }
        return this.processOuterDeclarations(processor, state, place);
    }

    protected boolean processOuterDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(8);
        }
        processor.handleEvent(ResolveProcessor.SCOPE_CHANGE, (Object)this);
        return processor.execute((PsiElement)this, state);
    }

    protected boolean processInnerAndBodyDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions) {
        boolean result;
        boolean b;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(11);
        }
        if (place instanceof JSReferenceExpression && (!(b = JSImportHandlingUtil.tryResolveImports(processor, this, place)) || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place))) {
            return b;
        }
        if (funInternalDefsProcessingOptions.toProcessFunctionArguments()) {
            JSParameterList parameterList = this.getParameterList();
            if (!this.processArguments(parameterList, processor, state, lastParent, place)) {
                return false;
            }
            if (!this.processImplicitArguments(processor, state)) {
                return false;
            }
        }
        if (result = JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place)) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        }
        return result;
    }

    protected boolean processImplicitArguments(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(13);
        }
        JSVariable argumentsVar = this.getImplicitArgumentsVar();
        return processor.execute((PsiElement)argumentsVar, state);
    }

    @NotNull
    private JSVariable getImplicitArgumentsVar() {
        JSVariable jSVariable = (JSVariable)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, ARGUMENTS_VAR_KEY, ARGUMENTS_VAR_PROVIDER, false, (Object)this);
        if (jSVariable == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(14);
        }
        return jSVariable;
    }

    public boolean processArguments(@Nullable JSParameterList parameterList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(17);
        }
        if (parameterList != null) {
            for (JSParameter param : parameterList.getParameterVariables()) {
                if (param.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    protected static ResolveProcessor.ProcessingOptions getProcessingOptions(@NotNull PsiScopeProcessor processor) {
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(18);
        }
        if (processor instanceof JSResolveProcessorEx) {
            JSResolveProcessorEx processorEx = (JSResolveProcessorEx)processor;
            funInternalDefsProcessingOptions = processorEx.getProcessingOptions();
        } else {
            funInternalDefsProcessingOptions = ResolveProcessor.DEFAULT_RESOLVE;
        }
        return funInternalDefsProcessingOptions;
    }

    protected String getArgumentsClassName() {
        return "IArguments";
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(19);
        }
        if (anchor == this.getFirstChild() && element instanceof JSAttributeList && anchor.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            return JSChangeUtil.doDoAddBefore(this, element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    @Override
    @NotNull
    public JSFunction.FunctionKind getKind() {
        if (this.isGetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.GETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(20);
            }
            return functionKind;
        }
        if (this.isSetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(21);
            }
            return functionKind;
        }
        if (this.isConstructor()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.CONSTRUCTOR;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(22);
            }
            return functionKind;
        }
        JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SIMPLE;
        if (functionKind == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(23);
        }
        return functionKind;
    }

    @Override
    public boolean isDeprecated() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated(this);
    }

    @Override
    public boolean isReferencesArguments() {
        return this.getCachedData().isReferencesArguments();
    }

    @Override
    public boolean constructorCanBeInvokedWithoutNew() {
        return this.getCachedData().constructorCanBeInvokedWithoutNew();
    }

    @Override
    public boolean isReferencesThis() {
        return this.getCachedData().referencesThis();
    }

    @Override
    public JSParameterListElement @NotNull [] getParameters() {
        JSParameterList parameterList = this.getParameterList();
        JSParameterListElement[] jSParameterListElementArray = parameterList != null ? parameterList.getParameters() : JSParameter.EMPTY_ARRAY;
        if (jSParameterListElementArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(24);
        }
        return jSParameterListElementArray;
    }

    @Override
    public JSParameter @NotNull [] getParameterVariables() {
        JSParameterList parameterList = this.getParameterList();
        JSParameter[] jSParameterArray = parameterList != null ? parameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
        if (jSParameterArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(25);
        }
        return jSParameterArray;
    }

    @NotNull
    public JSFunctionCachedDataBuilder getCachedDataBuilder() {
        JSFunctionCachedDataBuilder jSFunctionCachedDataBuilder = (JSFunctionCachedDataBuilder)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result((Object)this.initCachedDataBuilder(), new Object[]{this}));
        if (jSFunctionCachedDataBuilder == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(26);
        }
        return jSFunctionCachedDataBuilder;
    }

    @NotNull
    private JSFunctionCachedDataBuilder initCachedDataBuilder() {
        JSType evaluated;
        if (JSStubElementGistSupport.getInstance().useStubElementGists() && FileBasedIndexSupport.getInstance().getFileBeingCurrentlyIndexed() != null) {
            Logger.getInstance(JSFunctionBaseImpl.class).error(JSFunctionCachedDataBuilder.class.getSimpleName() + " must not be built during indexing");
        }
        JSFunctionCachedDataBuilder cachedData = new JSFunctionCachedDataBuilder();
        ArrayList<JSFunction> nestedFuns = new ArrayList<JSFunction>(2);
        JSFunctionNodesVisitor cachedDataEvaluator = this.createCachingVisitor(cachedData, nestedFuns);
        cachedDataEvaluator.visitElement(this.getNode());
        cachedDataEvaluator.summarizeNamesUsages();
        JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(this);
        if (expression != null) {
            cachedDataEvaluator.appendReturnType(expression.getNode(), expression);
        }
        for (JSFunction f : nestedFuns) {
            JSParameter[] fun = (JSParameter[])f;
            for (Map.Entry<String, EnumSet<JSFunctionCachedData.ReferenceStatus>> entry : fun.getCachedDataBuilder().referencedVariableNames.entrySet()) {
                String name = entry.getKey();
                EnumSet<JSFunctionCachedData.ReferenceStatus> status = entry.getValue();
                if (cachedData.declaredVariableNames.contains(name)) continue;
                EnumSet<JSFunctionCachedData.ReferenceStatus> baseStatus = cachedData.referencedVariableNames.get(name);
                if (baseStatus == null) {
                    baseStatus = EnumSet.noneOf(JSFunctionCachedData.ReferenceStatus.class);
                    cachedData.referencedVariableNames.put(name, baseStatus);
                }
                baseStatus.addAll(status);
            }
        }
        this.fillInfoFromDocComment(cachedData);
        PsiElement element = this.getReturnTypeElement();
        boolean hasExplicitType = false;
        if (element != null) {
            hasExplicitType = true;
            if (DialectDetector.isActionScript(this)) {
                cachedData.returnTypeToSerialize = JSPsiImplUtils.getTypeFromElement(element, this);
            }
        }
        for (JSParameter p : this.getParameterVariables()) {
            JSParameterTypeDecorator parameterType;
            boolean explicitlyDeclared;
            String parameterName = p.getName();
            if (parameterName == null) continue;
            JSParameterTypeDecorator typeDecorator = this.getParameterTypeDecorator(cachedData, p);
            JSType type = typeDecorator != null ? typeDecorator.getSimpleType() : null;
            boolean optional = typeDecorator != null && typeDecorator.isOptional();
            boolean rest = typeDecorator != null && typeDecorator.isRest();
            boolean bl = explicitlyDeclared = typeDecorator != null && typeDecorator.isExplicitlyDeclared();
            if (type == null && (parameterType = JSDocumentationUtils.getParameterTypeFromPrecedingComment(p)) != null) {
                type = parameterType.getSimpleType();
                optional = parameterType.isOptional();
                rest = parameterType.isRest();
                explicitlyDeclared = true;
            }
            if (type != null) {
                type = JSTypeBaseImpl.replaceEmptySourceRecursive(type, JSTypeSourceFactory.createTypeSource((PsiElement)p, true));
            }
            if (type == null && !optional && !rest) continue;
            cachedData.parameterTypes.put(parameterName, new JSParameterTypeDecoratorImpl(parameterName, type, optional, rest, explicitlyDeclared));
        }
        if (!cachedData.declaredVariableNames.contains("arguments") && cachedData.referencedVariableNames.containsKey("arguments")) {
            cachedData.referencesArguments = true;
            cachedData.referencedVariableNames.remove("arguments");
        }
        if (cachedData.returnTypeToSerialize == null && !hasExplicitType) {
            cachedData.returnTypeToSerialize = JSDocumentationUtils.getTypeFromReturnTypeComment(this);
        }
        JSType declaredType = cachedData.returnTypeToSerialize;
        if (!hasExplicitType && JSFunctionBaseImpl.useEvaluatedTypeInsteadOfDeclared(declaredType) && (evaluated = cachedDataEvaluator.getReturnTypeFromEvaluated()) != null) {
            cachedData.returnTypeToSerialize = evaluated;
        }
        JSFunctionCachedDataBuilder jSFunctionCachedDataBuilder = cachedData;
        if (jSFunctionCachedDataBuilder == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(27);
        }
        return jSFunctionCachedDataBuilder;
    }

    private static boolean useEvaluatedTypeInsteadOfDeclared(@Nullable JSType declaredType) {
        if (declaredType == null) {
            return true;
        }
        if (!(declaredType.getSourceElement() instanceof JSDocComment)) {
            return false;
        }
        return declaredType instanceof JSObjectType || declaredType instanceof JSPrimitiveFunctionType;
    }

    @NotNull
    protected JSFunctionNodesVisitor createCachingVisitor(JSFunctionCachedDataBuilder cachedData, List<JSFunction> nestedFuns) {
        return new JSFunctionNodesVisitor(this, cachedData, nestedFuns){
            private int myVisitedReturnedExpressions;
            {
                this.myVisitedReturnedExpressions = 0;
            }

            @Override
            @NotNull
            protected JSType getTypeFromReturnedExpression(@NotNull ASTNode context, @Nullable JSExpression expression) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expression = JSUtils.unparenthesize(expression)) != null && JSReturnedExpressionType.isCountableReturnedExpression(expression)) {
                    ++this.myVisitedReturnedExpressions;
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(JSFunctionBaseImpl.this, true);
                    return new JSReturnedExpressionType(this.myVisitedReturnedExpressions - 1, typeSource);
                }
                if (expression == null) {
                    JSVoidType jSVoidType = JSNamedTypeFactory.createVoidType(JSTypeSourceFactory.createTypeSource(context.getPsi(), true));
                    if (jSVoidType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSVoidType;
                }
                JSType type = super.getTypeFromReturnedExpression(context, expression);
                JSType jSType = type != null ? type : JSAnyType.get(context.getPsi());
                if (jSType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeFromReturnedExpression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeFromReturnedExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    protected JSFunctionCachedData getCachedData() {
        JSFunctionCachedData jSFunctionCachedData = (JSFunctionCachedData)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, DATA_KEY, DATA_PROVIDER, false, (Object)this);
        if (jSFunctionCachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(28);
        }
        return jSFunctionCachedData;
    }

    public void addReferencedExternalNames(@NotNull Set<String> names) {
        if (names == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(29);
        }
        names.addAll(this.getCachedDataBuilder().referencedVariableNames.keySet());
    }

    public void addWrittenExternalNames(@NotNull Set<String> names) {
        if (names == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(30);
        }
        for (Map.Entry<String, EnumSet<JSFunctionCachedData.ReferenceStatus>> entry : this.getCachedDataBuilder().referencedVariableNames.entrySet()) {
            if (!entry.getValue().contains((Object)JSFunctionCachedData.ReferenceStatus.Write)) continue;
            names.add(entry.getKey());
        }
    }

    protected boolean seemsToBePropertyAccessor() {
        if (this.isGetProperty() || this.isSetProperty()) {
            return true;
        }
        String name = this.getName();
        return name != null && (name.startsWith("get") || name.startsWith("set"));
    }

    protected void fillInfoFromDocComment(@NotNull JSFunctionCachedDataBuilder cachedFunctionData) {
        JSType typeFromTrailingComment;
        PsiElement docComment;
        if (cachedFunctionData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(31);
        }
        if ((docComment = this.findFunctionOrPropertyDocComment()) != null) {
            JSTypeSource functionTypeSource = JSTypeSourceFactory.createTypeSource(docComment, true);
            MyJSDocumentationProcessor processor = new MyJSDocumentationProcessor(docComment, cachedFunctionData, functionTypeSource, !(this instanceof JSExpression));
            JSDocumentationUtils.processDocumentationTextFromComment(docComment, docComment.getNode(), processor);
        }
        if ((typeFromTrailingComment = JSDocumentationUtils.getTypeFromTrailingComment(this)) != null && cachedFunctionData.returnTypeToSerialize == null) {
            cachedFunctionData.returnTypeToSerialize = typeFromTrailingComment;
        }
    }

    @Nullable
    protected JSType getReturnTypeFromDeclaration() {
        PsiElement typeElement = this.getReturnTypeElement();
        return JSPsiImplUtils.getTypeFromElement(typeElement, this);
    }

    private PsiElement findFunctionOrPropertyDocComment() {
        PsiComment docComment = JSDocumentationUtils.findFunctionComment(this);
        if (docComment == null && this.seemsToBePropertyAccessor()) {
            JSExpression rOperand;
            JSExpression expression;
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)this, JSStatement.class);
            JSStatement prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, JSStatement.class);
            JSFunctionBaseImpl prevFunction = null;
            if (prevStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)prevStatement).getExpression()) instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSFunctionBaseImpl) {
                prevFunction = (JSFunctionBaseImpl)((Object)rOperand);
            }
            if (prevFunction != null && prevFunction.seemsToBePropertyAccessor()) {
                docComment = JSDocumentationUtils.findFunctionComment(prevFunction);
            }
        }
        return docComment;
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement docComment = this.findFunctionOrPropertyDocComment();
        return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasConstructorLikeTag();
    }

    @Override
    public boolean isOverride() {
        return this.getCachedData().isOverride();
    }

    public boolean isOptional(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedDataBuilder(), parameter);
        return decorator != null && decorator.isOptional();
    }

    public boolean isRest(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedDataBuilder(), parameter);
        return decorator != null && decorator.isRest();
    }

    public boolean isTypeExplicitlyDeclared(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedDataBuilder(), parameter);
        return decorator != null && decorator.isExplicitlyDeclared();
    }

    @Nullable
    private JSParameterTypeDecorator getParameterTypeDecorator(@NotNull JSFunctionCachedDataBuilder cachedData, @NotNull JSParameterItem parameterItem) {
        if (cachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(32);
        }
        if (parameterItem == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(33);
        }
        if (parameterItem instanceof JSParameter) {
            JSParameterTypeDecorator decorator;
            JSParameter jsParameter = (JSParameter)parameterItem;
            String name = jsParameter.getName();
            JSParameterTypeDecorator jSParameterTypeDecorator = decorator = name != null ? cachedData.parameterTypes.get(jsParameter.getName()) : null;
            if (decorator != null) {
                return decorator;
            }
            if (JSDestructuringUtil.isDestructuring(jsParameter.getParent())) {
                JSParameterTypeDecorator appliedContext;
                JSParameterTypeDecorator dummyTypeDecorator;
                JSDestructuringContext destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)jsParameter, JSDestructuringParameter.class::isInstance);
                JSDestructuringParameter destructuringParameter = (JSDestructuringParameter)destructuringContext.getOuterElement();
                if (destructuringParameter != null && (dummyTypeDecorator = this.getDestructuringParameterTypeDecorator(cachedData, destructuringParameter)) != null && (appliedContext = destructuringContext.applyToOuterParameterTypeDecorator(dummyTypeDecorator)).getSimpleType() != null) {
                    return appliedContext;
                }
            }
        } else if (parameterItem instanceof JSDestructuringParameter) {
            return this.getDestructuringParameterTypeDecorator(cachedData, (JSDestructuringParameter)parameterItem);
        }
        return null;
    }

    @Nullable
    private JSParameterTypeDecorator getDestructuringParameterTypeDecorator(@NotNull JSFunctionCachedDataBuilder cachedData, @NotNull JSDestructuringParameter destructuringParameter) {
        PsiElement comment;
        if (cachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(34);
        }
        if (destructuringParameter == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(35);
        }
        if (!((comment = this.findFunctionOrPropertyDocComment()) instanceof JSDocComment)) {
            return null;
        }
        JSDocComment docComment = (JSDocComment)comment;
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        JSDocumentationUtils.JSTagToParameterMap tagToParameterMap = JSDocumentationUtils.getTagToParameterMap(docComment, this, tagNames);
        int tagIndex = tagToParameterMap.getTagForParameter(destructuringParameter);
        if (tagIndex >= 0) {
            String dummyName = (String)tagNames.get(tagIndex);
            return cachedData.parameterTypes.get(dummyName);
        }
        return null;
    }

    @Nullable
    public JSType getTypeFromComments(@NotNull JSParameterItem jsParameter) {
        JSParameterTypeDecorator decorator;
        if (jsParameter == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(36);
        }
        return (decorator = this.getParameterTypeDecorator(this.getCachedDataBuilder(), jsParameter)) != null ? decorator.getSimpleType() : null;
    }

    protected static boolean isInJS(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent == null || parent.getElementType().getLanguage() instanceof JavascriptLanguage;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    private JSType initReturnType(@Nullable JSFunctionCachedDataBuilder builderIfAvailable) {
        PsiElement element = this.getReturnTypeElement();
        JSType returnType = element != null ? JSPsiImplUtils.getTypeFromElement(element, this) : (builderIfAvailable != null ? builderIfAvailable.returnTypeToSerialize : this.getCachedData().getReturnType(this));
        return returnType;
    }

    @Override
    @Nullable
    public JSTypeStructure getReturnTypeStructure() {
        PsiElement returnTypeElement = this.getReturnTypeElement();
        if (returnTypeElement instanceof JSTypeDeclaration) {
            JSTypeDeclaration typeAnnotation = (JSTypeDeclaration)returnTypeElement;
            return typeAnnotation;
        }
        if (returnTypeElement != null) {
            return null;
        }
        JSType fromCachedData = this.getCachedData().getReturnType(this);
        return fromCachedData != null && fromCachedData.getSourceElement() instanceof JSDocComment || fromCachedData instanceof JSVoidType ? fromCachedData : null;
    }

    @Override
    @Nullable
    public JSType getReturnType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
    }

    @Override
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(37);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(38);
        }
        return accessType;
    }

    @Override
    public boolean isPrivateName() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isPrivateName();
        }
        return JSPsiImplUtils.isPrivateName(this);
    }

    @Override
    public boolean isAnonymousFunctionCall() {
        return false;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(39);
            }
            return jSContext;
        }
        JSContext jSContext = JSSymbolUtil.getContext(this, this.useTypesFromJSDoc());
        if (jSContext == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(40);
        }
        return jSContext;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    @Override
    public boolean isGenerator() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGenerator();
        }
        JSAttributeList list = this.getAttributeList();
        if (list != null && list.hasModifier(JSAttributeList.ModifierType.GENERATOR)) {
            return true;
        }
        return this.getNode().findChildByType(JSTokenTypes.MULT) != null;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSElementBase.ClassOrInterface classOrInterface = stub.isClassOrInterface();
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(41);
            }
            return classOrInterface;
        }
        if (this.getParent() instanceof JSClass) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(42);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = super.isClassOrInterface();
        JSElementBase.ClassOrInterface classOrInterface2 = classOrInterface != JSElementBase.ClassOrInterface.NONE ? classOrInterface : (this.isConstructor() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface2 == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(43);
        }
        return classOrInterface2;
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return true;
    }

    @Override
    public boolean isArrowFunction() {
        return false;
    }

    @Override
    public boolean isShorthandArrowFunction() {
        return false;
    }

    @Override
    public boolean hasExplicitlyDeclaredReturnType() {
        return this.getCachedData().hasExplicitlyDeclaredReturnType();
    }

    public boolean initHasExplicitlyDeclaredReturnType(@NotNull JSFunctionCachedDataBuilder builderIfAvailable) {
        PsiElement element;
        if (builderIfAvailable == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(44);
        }
        if ((element = this.getReturnTypeElement()) != null) {
            return true;
        }
        JSType returnType = this.initReturnType(builderIfAvailable);
        if (returnType == null) {
            return false;
        }
        PsiElement sourceElement = returnType.getSource().getSourceElement();
        return sourceElement instanceof PsiComment || sourceElement instanceof JSTypeDeclaration || returnType.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 20, 21, 22, 23, 24, 25, 26, 27, 28, 37, 38, 39, 40, 41, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedFunctionData";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterItem";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringParameter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderIfAvailable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitArgumentsVar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterVariables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedDataBuilder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "initCachedDataBuilder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkIsModifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processOuterDeclarations";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processInnerAndBodyDeclarations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitArguments";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProcessingOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addReferencedExternalNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addWrittenExternalNames";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoFromDocComment";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeDecorator";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDestructuringParameterTypeDecorator";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromComments";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "initHasExplicitlyDeclaredReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 20, 21, 22, 23, 24, 25, 26, 27, 28, 37, 38, 39, 40, 41, 42, 43 -> new IllegalStateException(string);
        };
    }

    private static final class MyJSDocumentationProcessor
    implements JSDocCommentVisitor {
        @NotNull
        private final Set<JSQualifiedName> myOptionalParameters;
        @NotNull
        private final Map<String, JSParameterTypeDecorator> myParameterTypes;
        @NotNull
        private final Map<JSQualifiedName, String> myParameterProperties;
        @NotNull
        private final JSTypeSource myFunctionTypeSource;
        @NotNull
        private final JSFunctionCachedDataBuilder myCachedFunctionData;
        private final PsiElement myDocComment;
        @Nullable
        private @Nullable Map<@NotNull String, @Nullable String> genericParameters;
        private boolean docCommentHasOverrides;
        private final boolean treatTypeAsReturnType;

        MyJSDocumentationProcessor(@NotNull PsiElement docComment, @NotNull JSFunctionCachedDataBuilder cachedFunctionData, @NotNull JSTypeSource functionTypeSource, boolean treatTypeAsReturnType) {
            if (docComment == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(0);
            }
            if (cachedFunctionData == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(1);
            }
            if (functionTypeSource == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(2);
            }
            this.myDocComment = docComment;
            this.myOptionalParameters = new HashSet<JSQualifiedName>();
            this.myCachedFunctionData = cachedFunctionData;
            this.myFunctionTypeSource = functionTypeSource;
            this.myParameterTypes = new LinkedHashMap<String, JSParameterTypeDecorator>();
            this.myParameterProperties = new LinkedHashMap<JSQualifiedName, String>();
            this.treatTypeAsReturnType = treatTypeAsReturnType;
        }

        @Override
        public void visitParamTag(@NotNull JSDocTag tag) {
            JSDocTagNamepath namepathPsi;
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(3);
            }
            if ((namepathPsi = tag.getNamepath()) != null) {
                String namepath = namepathPsi.getNamepathText();
                String type = tag.getTypeText();
                this.registerParameter(namepath, type, namepathPsi.isOptional());
            }
        }

        @Override
        public void visitOverrideTag(@NotNull JSDocTag tag) {
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(4);
            }
            this.docCommentHasOverrides = true;
        }

        @Override
        public void visitInheritDocTag(@NotNull JSDocTag tag) {
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(5);
            }
            this.docCommentHasOverrides = true;
        }

        @Override
        public void visitTemplateTag(@NotNull JSDocTag tag) {
            JSDocTagNamepath[] generics;
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(6);
            }
            if ((generics = (JSDocTagNamepath[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JSDocTagNamepath.class)) != null) {
                if (this.genericParameters == null) {
                    this.genericParameters = new HashMap<String, String>();
                }
                String type = tag.getTypeText();
                for (JSDocTagNamepath generic : generics) {
                    this.genericParameters.put(generic.getNamepathText(), type);
                }
            }
        }

        @Override
        public void visitReturnsTag(@NotNull JSDocTag tag) {
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(7);
            }
            this.myCachedFunctionData.returnTypeToSerialize = JSTypeParser.createTypeFromJSDoc(this.myDocComment.getProject(), tag.getTypeText(), this.myFunctionTypeSource);
        }

        @Override
        public void visitTypeTag(@NotNull JSDocTag tag) {
            JSType jsType;
            if (tag == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(8);
            }
            if ((jsType = JSTypeParser.createTypeFromJSDoc(this.myDocComment.getProject(), tag.getTypeText(), this.myFunctionTypeSource)) != null) {
                if (!this.treatTypeAsReturnType) {
                    jsType = new JSApplyCallType(jsType, this.myFunctionTypeSource);
                }
                this.myCachedFunctionData.returnTypeToSerialize = jsType;
            }
        }

        private void registerParameter(@NotNull String namepath, @Nullable String type, boolean isOptional) {
            boolean parameterIsOptional;
            if (namepath == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(9);
            }
            JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(namepath);
            JSParameterTypeDecorator parameterType = JSTypeParser.createParameterType(this.myDocComment.getProject(), type, this.myFunctionTypeSource, false, true);
            boolean bl = parameterIsOptional = isOptional || parameterType != null && parameterType.isOptional();
            if (qName.getParent() == null) {
                String name;
                JSParameterTypeDecorator oldType;
                if (parameterIsOptional) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(namepath));
                }
                if ((oldType = this.myParameterTypes.get(name = qName.getName())) == null || oldType.getSimpleType() == null && parameterType != null && parameterType.getSimpleType() != null) {
                    this.myParameterTypes.put(name, parameterType);
                } else if (parameterType != null) {
                    JSType composite = oldType.getSimpleType() == null ? parameterType.getSimpleType() : (parameterType.getSimpleType() == null ? oldType.getSimpleType() : JSCompositeTypeFactory.createUnionType(this.myFunctionTypeSource, oldType.getSimpleType(), parameterType.getSimpleType()));
                    JSParameterTypeDecoratorImpl newDecorator = new JSParameterTypeDecoratorImpl(composite, oldType.isOptional() || parameterType.isOptional(), oldType.isRest() || parameterType.isRest(), true);
                    this.myParameterTypes.put(namepath, newDecorator);
                }
            } else {
                if (parameterIsOptional) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(namepath));
                }
                this.myParameterProperties.put(qName, type);
            }
        }

        @Override
        public void finishVisiting(@Nullable JSDocTag lastTag) {
            this.myCachedFunctionData.overrides = this.docCommentHasOverrides;
            LinkedHashMap<String, JSType> evaluatedTypes = new LinkedHashMap<String, JSType>();
            HashSet<String> restParameters = new HashSet<String>();
            for (Map.Entry<String, JSParameterTypeDecorator> entry : this.myParameterTypes.entrySet()) {
                JSParameterTypeDecorator parameterType = entry.getValue();
                if (parameterType == null) continue;
                evaluatedTypes.put(entry.getKey(), parameterType.getSimpleType());
                if (parameterType.isOptional()) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.create(entry.getKey(), null));
                }
                if (!parameterType.isRest()) continue;
                restParameters.add(entry.getKey());
            }
            if (!this.myParameterProperties.isEmpty()) {
                JSRecordType dummyType = JSTypeUtils.buildRecordTypeFromProperties(this.myDocComment.getProject(), this.myParameterProperties, this.myOptionalParameters, this.myFunctionTypeSource);
                assert (dummyType != null);
                for (JSRecordType.TypeMember typeMember : dummyType.getTypeMembers()) {
                    assert (typeMember instanceof JSRecordType.PropertySignature);
                    String name = ((JSRecordType.PropertySignature)typeMember).getMemberName();
                    JSType rawType = (JSType)evaluatedTypes.get(name);
                    JSType propertyType = ((JSRecordType.PropertySignature)typeMember).getJSType();
                    Ref objectReplaced = Ref.create((Object)false);
                    if (rawType != null && propertyType != null) {
                        JSType typeWithObjectReplaced = JSTypeUtils.applyCompositeMapping(rawType, (Function<? super JSType, ? extends JSType>)((Function)type -> {
                            if (type instanceof JSObjectType && !((Boolean)objectReplaced.get()).booleanValue()) {
                                objectReplaced.set((Object)true);
                                return propertyType;
                            }
                            return type;
                        }));
                        if (((Boolean)objectReplaced.get()).booleanValue()) {
                            evaluatedTypes.put(name, typeWithObjectReplaced);
                        }
                    } else if (rawType == null && propertyType != null) {
                        evaluatedTypes.put(name, propertyType);
                        objectReplaced.set((Object)true);
                    }
                    if (((Boolean)objectReplaced.get()).booleanValue() || rawType == null || propertyType == null) continue;
                    JSType compositeType = JSCompositeTypeFactory.createUnionType(this.myFunctionTypeSource, rawType, propertyType);
                    evaluatedTypes.put(name, compositeType);
                }
            }
            HashSet declaredParameters = new HashSet(evaluatedTypes.keySet());
            for (JSQualifiedName optionalParameter : this.myOptionalParameters) {
                if (optionalParameter.getParent() != null) continue;
                declaredParameters.add(optionalParameter.getName());
            }
            this.addGenericParameters(evaluatedTypes);
            for (String parameter : declaredParameters) {
                JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl((JSType)evaluatedTypes.get(parameter), this.myOptionalParameters.contains(JSQualifiedNameImpl.fromQualifiedName(parameter)), restParameters.contains(parameter), true);
                this.myCachedFunctionData.parameterTypes.put(parameter, decorator);
            }
        }

        private void addGenericParameters(@NotNull Map<String, JSType> types) {
            if (types == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(10);
            }
            if (this.genericParameters == null) {
                return;
            }
            for (Map.Entry<String, JSType> entry : types.entrySet()) {
                JSType type = entry.getValue();
                if (type == null || this.genericParameters.isEmpty()) continue;
                entry.setValue(JSTypeUtils.addJSGenericParameters(this.myDocComment.getProject(), type, this.genericParameters));
            }
            if (this.myCachedFunctionData.returnTypeToSerialize != null && !this.genericParameters.isEmpty()) {
                this.myCachedFunctionData.returnTypeToSerialize = JSTypeUtils.addJSGenericParameters(this.myDocComment.getProject(), this.myCachedFunctionData.returnTypeToSerialize, this.genericParameters);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docComment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedFunctionData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionTypeSource";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namepath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$MyJSDocumentationProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParamTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOverrideTag";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInheritDocTag";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTemplateTag";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnsTag";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeTag";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerParameter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGenericParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

