/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceProjectErrors;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class TypeScriptStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(0);
        }
        this.runActivityImpl(project);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.invokeLater(() -> {
            ToolWindow window = toolWindowManager.getToolWindow("Problems View");
            if (window != null && window.isVisible()) {
                TypeScriptStartupActivity.reloadProjectErrors(project, this);
            }
        });
        project.getMessageBus().connect((Disposable)JSDisposable.getInstance((Project)project)).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if (toolWindow == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("Problems View".equals(toolWindow.getId())) {
                    TypeScriptStartupActivity.reloadProjectErrors(project, this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/lang/typescript/settings/exclude/TypeScriptStartupActivity$1", "toolWindowShown"));
            }
        });
    }

    private static void reloadProjectErrors(@NotNull Project project, Object reason) {
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(1);
        }
        if (!Boolean.TRUE.equals(project.getUserData(TypeScriptServiceProjectErrors.TOOL_WINDOW_IS_SHOWN))) {
            project.putUserData(TypeScriptServiceProjectErrors.TOOL_WINDOW_IS_SHOWN, (Object)true);
            DaemonCodeAnalyzer.getInstance((Project)project).restart(reason);
        }
    }

    @Nullable
    public CancellablePromise<?> runActivityImpl(@NotNull Project project) {
        TypeScriptExcludeManager generatedFilesManager;
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(2);
        }
        if (!(generatedFilesManager = TypeScriptExcludeManager.getInstance(project)).isProjectProcessed()) {
            return TypeScriptStartupActivity.addPlainJavaScriptAndDeclarationFilesToExclude(project, generatedFilesManager);
        }
        return null;
    }

    public static void updateProject(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager, @NotNull Collection<VirtualFile> filesToIndex) {
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(3);
        }
        if (filesToIndex == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(4);
        }
        TransactionGuard.submitTransaction((Disposable)JSDisposable.getInstance((Project)project), () -> generatedFilesManager.updateProject(filesToIndex));
    }

    public static CancellablePromise<?> addPlainJavaScriptAndDeclarationFilesToExclude(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager) {
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(5);
        }
        ThrowableComputable action = () -> {
            if (!generatedFilesManager.isExcludeGeneratedFiles()) {
                return Collections.emptyList();
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            ArrayList toExcludeFiles = new ArrayList();
            FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, file -> TypeScriptStartupActivity.addFileToExclude(toExcludeFiles, file), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            FileTypeIndex.processFiles((FileType)TypeScriptJSXFileType.INSTANCE, file -> TypeScriptStartupActivity.addFileToExclude(toExcludeFiles, file), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            return toExcludeFiles;
        };
        return ReadAction.nonBlocking(() -> ((ThrowableComputable)action).compute()).inSmartMode(project).finishOnUiThread(ModalityState.defaultModalityState(), el -> TypeScriptStartupActivity.processFiles(project, generatedFilesManager, el)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static void processFiles(@NotNull Project project, @NotNull TypeScriptExcludeManager generatedFilesManager, @NotNull List<VirtualFile> toExcludeFiles) {
        if (project == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(6);
        }
        if (generatedFilesManager == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(7);
        }
        if (toExcludeFiles == null) {
            TypeScriptStartupActivity.$$$reportNull$$$0(8);
        }
        generatedFilesManager.setFiles(toExcludeFiles);
        generatedFilesManager.updateVersion();
        if (!toExcludeFiles.isEmpty()) {
            Logger.getInstance(TypeScriptStartupActivity.class).info("Exclude " + toExcludeFiles.size() + " generated js files");
            TypeScriptStartupActivity.updateProject(project, generatedFilesManager, Collections.emptyList());
        }
    }

    private static boolean addFileToExclude(ArrayList<VirtualFile> toExcludeFiles, VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        CharSequence fileName = file.getNameSequence();
        String extension = JSFileReferencesUtil.findExtension((CharSequence)fileName, (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        if (StringUtil.isEmpty((String)extension) || ArrayUtil.contains((String)extension, (String[])TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS)) {
            return true;
        }
        VirtualFile directory = file.getParent();
        CharSequence tsFileNameWithoutExtension = JSFileReferencesUtil.trimExistingExtension((CharSequence)fileName, (String)extension);
        if (!StringUtil.isEmpty((CharSequence)tsFileNameWithoutExtension)) {
            for (String dtsExtension : Holder.JS_DTS_MAP_EXTENSIONS) {
                VirtualFile candidate = directory.findChild(String.valueOf(tsFileNameWithoutExtension) + dtsExtension);
                if (candidate == null) continue;
                toExcludeFiles.add(candidate);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFilesManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExcludeFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadProjectErrors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivityImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPlainJavaScriptAndDeclarationFilesToExclude";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Holder {
        public static final String[] JS_DTS_MAP_EXTENSIONS = Holder.mergeAllDtsAndJsWithMap();

        Holder() {
        }

        private static String[] mergeAllDtsAndJsWithMap() {
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (String extension : TypeScriptUtil.JAVASCRIPT_EXTENSIONS) {
                result2.add(extension);
                result2.add(extension + ".map");
            }
            for (String extension : TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS) {
                result2.add(extension);
                result2.add(extension + ".map");
            }
            return (String[])result2.toArray(String[]::new);
        }
    }
}

