/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.serializers;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/stubs/serializers/JSStubSerializer;", "Stub", "Lcom/intellij/lang/javascript/psi/stubs/JSStubElement;", "Psi", "Lcom/intellij/lang/javascript/psi/JSElement;", "Lcom/intellij/psi/stubs/StubSerializer;", "elementTypeSupplier", "Lkotlin/Function0;", "Lcom/intellij/lang/javascript/psi/JSElementType;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "elementType", "getElementType", "()Lcom/intellij/lang/javascript/psi/JSElementType;", "elementType$delegate", "Lkotlin/Lazy;", "getExternalId", "", "indexStub", "", "stub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "(Lcom/intellij/lang/javascript/psi/stubs/JSStubElement;Lcom/intellij/psi/stubs/IndexSink;)V", "serialize", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "(Lcom/intellij/lang/javascript/psi/stubs/JSStubElement;Lcom/intellij/psi/stubs/StubOutputStream;)V", "intellij.javascript.analysis.impl"})
public abstract class JSStubSerializer<Stub extends JSStubElement<Psi>, Psi extends JSElement>
implements StubSerializer<Stub> {
    @NotNull
    private final Lazy elementType$delegate;

    public JSStubSerializer(@NotNull Function0<? extends JSElementType<Psi>> elementTypeSupplier) {
        Intrinsics.checkNotNullParameter(elementTypeSupplier, (String)"elementTypeSupplier");
        this.elementType$delegate = LazyKt.lazy(elementTypeSupplier);
    }

    @NotNull
    public final JSElementType<Psi> getElementType() {
        Lazy lazy = this.elementType$delegate;
        return (JSElementType)lazy.getValue();
    }

    @NotNull
    public String getExternalId() {
        String string = this.getElementType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void indexStub(@NotNull Stub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        stub.index(sink);
    }

    public void serialize(@NotNull Stub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        stub.serialize(dataStream);
    }
}

