/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class JSIncompatibleTypesComparisonInspection
extends JSInspection {
    @Override
    public boolean isCoveredByTypeScriptServiceHighlighting() {
        return true;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        PsiFile file;
        if (holder == null) {
            JSIncompatibleTypesComparisonInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSIncompatibleTypesComparisonInspection.$$$reportNull$$$0(1);
        }
        final TypeScriptAnnotatorCheckerProvider provider = DialectDetector.isTypeScript((PsiElement)(file = holder.getFile())) ? TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file) : null;
        return new JSElementVisitor(this){

            public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.isAcceptable(node)) {
                    JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> ValidateTypesUtil.checkTypesInComparison(node, JSAnalysisHandlersFactory.forElement((PsiElement)node).getTypeChecker(holder)));
                }
            }

            public boolean isAcceptable(@NotNull JSBinaryExpression element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (provider != null && provider.skipErrors((PsiElement)element2)) {
                    return false;
                }
                return !DialectDetector.isFlow((PsiElement)element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIncompatibleTypesComparisonInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSBinaryExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAcceptable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSIncompatibleTypesComparisonInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

