/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigImpl;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FlowJSConfigServiceImpl
implements FlowJSConfigService {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<Collection<FlowJSConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Collection<FlowJSConfig>>> myConfigsOfFile;

    public FlowJSConfigServiceImpl(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        final FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
        CachedValueProvider configsProvider = () -> (CachedValueProvider.Result)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CachedValueProvider.Result<Collection<FlowJSConfig>>>(){

            public CachedValueProvider.Result<Collection<FlowJSConfig>> compute() {
                Object[] files = FilenameIndex.getFilesByName((Project)FlowJSConfigServiceImpl.this.myProject, (String)".flowconfig", (GlobalSearchScope)GlobalSearchScope.allScope((Project)FlowJSConfigServiceImpl.this.myProject));
                List configs = ContainerUtil.mapNotNull((Object[])files, el -> FlowJSConfigImpl.getConfig((PsiFile)el, (boolean)fileIndexFacade.isInContent(el.getVirtualFile())));
                ArrayList<ModificationTracker> depends = new ArrayList<ModificationTracker>();
                depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
                ContainerUtil.addAll(depends, (Object[])files);
                return CachedValueProvider.Result.create((Object)configs, depends);
            }
        });
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myConfigsOfFile = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @NotNull
    public Collection<FlowJSConfig> getConfigOfFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(1);
        }
        return this.getConfigOfFile(file, false);
    }

    @NotNull
    private Collection<FlowJSConfig> getConfigOfFile(@NotNull VirtualFile file, boolean includeLibraries) {
        ConcurrentMap fileConfigsIncludeCache;
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if ((fileConfigsIncludeCache = (ConcurrentMap)this.myConfigsOfFile.getValue()).containsKey(file)) {
            return FlowJSConfigServiceImpl.filterLibraryConfigs((Collection)fileConfigsIncludeCache.get(file), includeLibraries);
        }
        Collection<FlowJSConfig> configOfFile = this.getConfigOfFileImpl(file);
        fileConfigsIncludeCache.put(file, configOfFile);
        return FlowJSConfigServiceImpl.filterLibraryConfigs(configOfFile, includeLibraries);
    }

    @NotNull
    private static Collection<FlowJSConfig> filterLibraryConfigs(@NotNull Collection<FlowJSConfig> result2, boolean includeLibraries) {
        if (result2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(3);
        }
        if (includeLibraries) {
            Collection<FlowJSConfig> collection = result2;
            if (collection == null) {
                FlowJSConfigServiceImpl.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List list = ((StreamEx)StreamEx.of(result2).filter(el -> el.isProjectConfig())).toList();
        if (list == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private Collection<FlowJSConfig> getConfigOfFileImpl(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(6);
        }
        Collection<FlowJSConfig> allConfigs = this.getConfigFiles();
        ArrayList<FlowJSConfig> configOfFile = new ArrayList<FlowJSConfig>();
        allConfigs.forEach(config -> {
            if (config.isFileIncluded(file) && !config.isFileIgnored(file)) {
                configOfFile.add((FlowJSConfig)config);
            }
        });
        ArrayList<FlowJSConfig> arrayList = configOfFile;
        if (arrayList == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public Collection<FlowJSConfig> getConfigFiles() {
        Collection value = (Collection)this.myConfigs.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public FlowJSConfig getNearestConfig(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(9);
        }
        return this.getNearestConfig(file, false);
    }

    @Nullable
    public FlowJSConfig getNearestConfig(@NotNull VirtualFile file, boolean includeLibraries) {
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(10);
        }
        Collection<FlowJSConfig> configCollection = this.getConfigOfFile(file, includeLibraries);
        return FlowJSConfigServiceImpl.getNearestConfig(configCollection, file);
    }

    @NotNull
    public @Unmodifiable Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope2) {
        if (fileType == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(12);
        }
        Collection collection = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope2);
        if (collection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    private static FlowJSConfig getNearestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file) {
        if (configCollection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(15);
        }
        Optional<FlowJSConfig> nearestConfig = configCollection.stream().min(Comparator.comparingInt(config -> {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)config.getConfigDirectory());
            if (relativePath == null) {
                return Integer.MAX_VALUE;
            }
            return StringUtil.countChars((CharSequence)relativePath, (char)'/');
        }));
        return nearestConfig.orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLibraryConfigs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigOfFileImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigOfFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterLibraryConfigs";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigOfFileImpl";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNearestConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 13 -> new IllegalStateException(string);
        };
    }
}

