/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependencyTreeLoader;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel.YarnPnpEntityHelperKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class YarnPnpFile {
    private static final Logger LOG = Logger.getInstance(YarnPnpFile.class);
    private final VirtualFile myPnpFile;
    private final Project myProject;
    private volatile YarnPnpWorkspaceList myWorkspaceList;
    private final AtomicBoolean myRefreshing;
    private ExecutionException myLastException;
    private volatile @Unmodifiable Map<String, YarnPnpSyntheticLibrary> myLibrariesCache;

    YarnPnpFile(@NotNull VirtualFile pnpJsFile, @NotNull Project project) {
        if (pnpJsFile == null) {
            YarnPnpFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            YarnPnpFile.$$$reportNull$$$0(1);
        }
        this.myRefreshing = new AtomicBoolean(false);
        this.myLibrariesCache = Map.of();
        this.myPnpFile = pnpJsFile;
        this.myProject = project;
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            YarnPnpFile.$$$reportNull$$$0(2);
        }
        return project;
    }

    boolean refresh() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Shouldn't be invoked under read action");
        if (this.myRefreshing.compareAndSet(false, true)) {
            boolean changed;
            YarnPnpWorkspaceList oldWorkspaceList = this.myWorkspaceList;
            YarnPnpWorkspaceList newWorkspaceList = this.loadWorkspaceList();
            boolean bl = changed = !Objects.equals(oldWorkspaceList, newWorkspaceList);
            if (changed) {
                this.setWorkspaceList(newWorkspaceList);
            }
            this.myRefreshing.set(false);
            return changed;
        }
        return false;
    }

    @Nullable
    private YarnPnpWorkspaceList loadWorkspaceList() {
        try {
            this.myLastException = null;
            if (!TrustedProjects.isProjectTrusted((Project)this.myProject)) {
                throw new ExecutionException("Cannot load Yarn PnP for " + this.myPnpFile.getPath() + " in the untrusted project");
            }
            return new YarnPnpDependencyTreeLoader(this).load();
        }
        catch (ExecutionException e) {
            this.myLastException = e;
            LOG.info((Throwable)e);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        return null;
    }

    @NotNull
    public VirtualFile getPnpFile() {
        VirtualFile virtualFile = this.myPnpFile;
        if (virtualFile == null) {
            YarnPnpFile.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public YarnPnpWorkspaceList getWorkspaceList() {
        return this.myWorkspaceList;
    }

    void setWorkspaceList(@Nullable YarnPnpWorkspaceList workspaceList) {
        this.myWorkspaceList = workspaceList;
        YarnPnpEntityHelperKt.updateLibraryEntities(this.myProject, this, (Function1<? super List<? extends YarnPnpSyntheticLibrary>, Unit>)((Function1)libraries -> {
            this.myLibrariesCache = ContainerUtil.map2Map((Collection)libraries, library -> Pair.create((Object)library.getWorkspace().getLocation(), (Object)library));
            return Unit.INSTANCE;
        }));
    }

    @TestOnly
    public void checkFileRefreshedSuccessfully() throws ExecutionException {
        if (this.myLastException != null) {
            throw this.myLastException;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public YarnPnpSyntheticLibrary findSyntheticLibrary(@NotNull String workspaceLocation) {
        if (workspaceLocation == null) {
            YarnPnpFile.$$$reportNull$$$0(4);
        }
        return this.myLibrariesCache.get(workspaceLocation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpJsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSyntheticLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

