/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSRunConfigurationBuilderBase<T extends RunConfiguration, U>
implements JSRunConfigurationBuilder {
    private final Project myProject;
    private final Function<? super T, ? extends U> myGetRunSettings;
    private final BiConsumer<? super T, ? super U> mySetRunSettings;
    private final String myName;
    private final ConfigurationType myConfigurationType;

    protected JSRunConfigurationBuilderBase(@NotNull Project project, @NotNull String name, @NotNull ConfigurationType configurationType, @NotNull Function<? super T, ? extends U> getRunSettings, @NotNull BiConsumer<? super T, ? super U> setRunSettings) {
        if (project == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(1);
        }
        if (configurationType == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(2);
        }
        if (getRunSettings == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(3);
        }
        if (setRunSettings == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myName = name;
        this.myConfigurationType = configurationType;
        this.myGetRunSettings = getRunSettings;
        this.mySetRunSettings = setRunSettings;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings findSimilarRunConfiguration(@Nullable VirtualFile baseDir, @Nullable String configPath, @NotNull Map<String, Object> options) {
        if (options == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(6);
        }
        U runSettings = this.createRunSettings(baseDir, configPath, options);
        return this.getRunManager().getConfigurationSettingsList(this.myConfigurationType).stream().filter(settings -> this.isSimilar(this.myGetRunSettings.apply(settings.getConfiguration()), runSettings)).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String label, @Nullable VirtualFile baseDir, @Nullable String configPath, @NotNull Map<String, Object> options) {
        if (label == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(7);
        }
        if (options == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(8);
        }
        RunManager runManager = this.getRunManager();
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(label, this.myConfigurationType.getConfigurationFactories()[0]);
        this.mySetRunSettings.accept(settings.getConfiguration(), this.createRunSettings(baseDir, configPath, options));
        runManager.addConfiguration(settings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(9);
        }
        return runnerAndConfigurationSettings;
    }

    @NotNull
    protected RunManager getRunManager() {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager == null) {
            JSRunConfigurationBuilderBase.$$$reportNull$$$0(10);
        }
        return runManager;
    }

    @NotNull
    protected abstract U createRunSettings(@Nullable VirtualFile var1, @Nullable String var2, @NotNull Map<String, Object> var3);

    protected abstract boolean isSimilar(@NotNull U var1, @NotNull U var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getRunSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setRunSettings";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSRunConfigurationBuilderBase";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSRunConfigurationBuilderBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarRunConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

