/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.highlighting;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001!B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0017\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/razor/highlighting/WebTemplateTextCreatorState;", "", "sourceCode", "", "templateElementType", "Lcom/intellij/psi/tree/IElementType;", "transitionTokenTypes", "", "escapeTokenTypes", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/psi/tree/IElementType;Ljava/util/List;Ljava/util/List;)V", "hasSeenHtml", "", "isDummyPending", "Lcom/jetbrains/rider/razor/highlighting/WebTemplateTextCreatorState$DummyTokenPendingStatus;", "previousTokenType", "consumeTemplateRange", "", "range", "Lcom/intellij/openapi/util/TextRange;", "savePreviousTokenType", "type", "isTemplateToken", "isTransitionToken", "isEscapeToken", "consumeNonTemplateToken", "currentTokenType", "getDummyIfNeeded", "", "tokenText", "tryGetAttributeName", "isWhitespace", "text", "DummyTokenPendingStatus", "intellij.rider.plugins.razor"})
@SourceDebugExtension(value={"SMAP\nWebTemplateTextCreatorState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTemplateTextCreatorState.kt\ncom/jetbrains/rider/razor/highlighting/WebTemplateTextCreatorState\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,110:1\n1188#2,3:111\n*S KotlinDebug\n*F\n+ 1 WebTemplateTextCreatorState.kt\ncom/jetbrains/rider/razor/highlighting/WebTemplateTextCreatorState\n*L\n91#1:111,3\n*E\n"})
public final class WebTemplateTextCreatorState {
    @NotNull
    private final CharSequence sourceCode;
    @NotNull
    private final IElementType templateElementType;
    @NotNull
    private final List<IElementType> transitionTokenTypes;
    @NotNull
    private final List<IElementType> escapeTokenTypes;
    private boolean hasSeenHtml;
    @NotNull
    private DummyTokenPendingStatus isDummyPending;
    @Nullable
    private IElementType previousTokenType;

    public WebTemplateTextCreatorState(@NotNull CharSequence sourceCode, @NotNull IElementType templateElementType, @NotNull List<? extends IElementType> transitionTokenTypes, @NotNull List<? extends IElementType> escapeTokenTypes) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)templateElementType, (String)"templateElementType");
        Intrinsics.checkNotNullParameter(transitionTokenTypes, (String)"transitionTokenTypes");
        Intrinsics.checkNotNullParameter(escapeTokenTypes, (String)"escapeTokenTypes");
        this.sourceCode = sourceCode;
        this.templateElementType = templateElementType;
        this.transitionTokenTypes = transitionTokenTypes;
        this.escapeTokenTypes = escapeTokenTypes;
        this.isDummyPending = DummyTokenPendingStatus.NotPending;
    }

    public final void consumeTemplateRange(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.hasSeenHtml && !this.isWhitespace(this.sourceCode, range)) {
            this.hasSeenHtml = true;
        }
    }

    public final void savePreviousTokenType(@Nullable IElementType type) {
        this.previousTokenType = type;
    }

    public final boolean isTemplateToken(@Nullable IElementType type) {
        return Intrinsics.areEqual((Object)type, (Object)this.templateElementType);
    }

    private final boolean isTransitionToken(IElementType type) {
        return CollectionsKt.contains((Iterable)this.transitionTokenTypes, (Object)type);
    }

    private final boolean isEscapeToken(IElementType type) {
        return CollectionsKt.contains((Iterable)this.escapeTokenTypes, (Object)type);
    }

    public final void consumeNonTemplateToken(@Nullable IElementType currentTokenType) {
        if (!this.hasSeenHtml) {
            this.isDummyPending = DummyTokenPendingStatus.NotPending;
        }
        if (this.isTransitionToken(currentTokenType) && this.isTemplateToken(this.previousTokenType)) {
            this.isDummyPending = DummyTokenPendingStatus.PendingToSuppressJS;
            return;
        }
        if (this.isEscapeToken(currentTokenType)) {
            return;
        }
        if (this.isTemplateToken(this.previousTokenType) || this.isTransitionToken(this.previousTokenType)) {
            this.isDummyPending = DummyTokenPendingStatus.Pending;
        }
    }

    @Nullable
    public final String getDummyIfNeeded(@NotNull CharSequence tokenText) {
        Intrinsics.checkNotNullParameter((Object)tokenText, (String)"tokenText");
        String result2 = switch (WhenMappings.$EnumSwitchMapping$0[this.isDummyPending.ordinal()]) {
            case 1 -> null;
            case 2 -> {
                CharSequence attributeName = this.tryGetAttributeName(tokenText);
                if (attributeName != null && HtmlDescriptorsTable.isKnownAttributeDescriptor((String)((Object)attributeName).toString())) {
                    yield "jetbrainsRiderJSEmbedmentSuppression";
                }
                yield null;
            }
            case 3 -> {
                if (StringsKt.startsWith$default((CharSequence)tokenText, (CharSequence)"/>", (boolean)false, (int)2, null)) {
                    yield "dummy ";
                }
                yield "dummy";
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.isDummyPending = DummyTokenPendingStatus.NotPending;
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence tryGetAttributeName(CharSequence tokenText) {
        int attributeLengthLimit = 10;
        CharSequence $this$forEachIndexed$iv = tokenText;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            if (index >= attributeLengthLimit) {
                return null;
            }
            if (Character.isLetter((char)char_)) continue;
            return tokenText.subSequence(0, index);
        }
        return null;
    }

    private final boolean isWhitespace(CharSequence text, TextRange range) {
        int n = range.getEndOffset();
        for (int index = range.getStartOffset(); index < n; ++index) {
            if (CharsKt.isWhitespace((char)text.charAt(index))) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/razor/highlighting/WebTemplateTextCreatorState$DummyTokenPendingStatus;", "", "<init>", "(Ljava/lang/String;I)V", "NotPending", "PendingToSuppressJS", "Pending", "intellij.rider.plugins.razor"})
    private static final class DummyTokenPendingStatus
    extends Enum<DummyTokenPendingStatus> {
        public static final /* enum */ DummyTokenPendingStatus NotPending = new DummyTokenPendingStatus();
        public static final /* enum */ DummyTokenPendingStatus PendingToSuppressJS = new DummyTokenPendingStatus();
        public static final /* enum */ DummyTokenPendingStatus Pending = new DummyTokenPendingStatus();
        private static final /* synthetic */ DummyTokenPendingStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DummyTokenPendingStatus[] values() {
            return (DummyTokenPendingStatus[])$VALUES.clone();
        }

        public static DummyTokenPendingStatus valueOf(String value) {
            return Enum.valueOf(DummyTokenPendingStatus.class, value);
        }

        @NotNull
        public static EnumEntries<DummyTokenPendingStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dummyTokenPendingStatusArray = new DummyTokenPendingStatus[]{DummyTokenPendingStatus.NotPending, DummyTokenPendingStatus.PendingToSuppressJS, DummyTokenPendingStatus.Pending};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DummyTokenPendingStatus.values().length];
            try {
                nArray[DummyTokenPendingStatus.NotPending.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DummyTokenPendingStatus.PendingToSuppressJS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DummyTokenPendingStatus.Pending.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

