/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.css.services.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.jetbrains.rider.razor.psi.RazorFileViewProvider;
import com.jetbrains.rider.razor.services.formatting.RiderFormatUtilsKt;
import com.jetbrains.rider.razor.services.formatting.RiderFormatterBlockMerger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/razor/css/services/formatting/RazorCssFormattingModelBuilder;", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder;", "Lcom/intellij/formatting/CustomFormattingModelBuilder;", "<init>", "()V", "isEngagedToFormat", "", "context", "Lcom/intellij/psi/PsiElement;", "createExtension", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormattingExtension;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "RazorCssFormattingExtension", "intellij.rider.plugins.razor.css"})
public final class RazorCssFormattingModelBuilder
extends CssFormattingModelBuilder
implements CustomFormattingModelBuilder {
    public boolean isEngagedToFormat(@Nullable PsiElement context) {
        PsiFile psiFile;
        PsiElement psiElement = context;
        PsiFile psiFile2 = psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return (psiFile2 != null ? psiFile2.getViewProvider() : null) instanceof RazorFileViewProvider;
    }

    @NotNull
    protected CssFormattingModelBuilder.CssFormattingExtension createExtension(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)CSSLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(CssCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        return new RazorCssFormattingExtension(settings, commonCodeStyleSettings, (CssCodeStyleSettings)customCodeStyleSettings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J&\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/razor/css/services/formatting/RazorCssFormattingModelBuilder$RazorCssFormattingExtension;", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormattingExtension;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "customSettings", "Lcom/intellij/psi/css/codeStyle/CssCodeStyleSettings;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lcom/intellij/psi/css/codeStyle/CssCodeStyleSettings;)V", "getSettings", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "createOuterLanguageBlock", "Lcom/intellij/formatting/Block;", "element", "Lcom/intellij/psi/templateLanguages/OuterLanguageElement;", "modifySubBlocksIfNeeded", "", "parentNode", "Lcom/intellij/lang/ASTNode;", "list", "modifySpacingInCaseOfTemplateBlocks", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "defaultSpacing", "intellij.rider.plugins.razor.css"})
    public static final class RazorCssFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        @NotNull
        private final CodeStyleSettings settings;

        public RazorCssFormattingExtension(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings commonSettings, @NotNull CssCodeStyleSettings customSettings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
            Intrinsics.checkNotNullParameter((Object)customSettings, (String)"customSettings");
            super(commonSettings, customSettings);
            this.settings = settings;
        }

        @NotNull
        public final CodeStyleSettings getSettings() {
            return this.settings;
        }

        @NotNull
        public Block createOuterLanguageBlock(@NotNull OuterLanguageElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Block block = TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)element, (CodeStyleSettings)this.settings, null);
            if (block == null) {
                Block block2 = super.createOuterLanguageBlock(element);
                block = block2;
                Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"createOuterLanguageBlock(...)");
            }
            return block;
        }

        @NotNull
        public List<Block> modifySubBlocksIfNeeded(@NotNull ASTNode parentNode, @NotNull List<Block> list) {
            Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
            Intrinsics.checkNotNullParameter(list, (String)"list");
            PsiFile psiFile = parentNode.getPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return RiderFormatterBlockMerger.INSTANCE.modifySubBlocksIfNeeded(list, psiFile);
        }

        @Nullable
        public Spacing modifySpacingInCaseOfTemplateBlocks(@Nullable Block child1, @NotNull Block child2, @Nullable Spacing defaultSpacing) {
            Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
            if (child1 instanceof CssFormattingModelBuilder.CssFormatterBlock && child2 instanceof CssFormattingModelBuilder.CssFormatterBlock && Intrinsics.areEqual((Object)((CssFormattingModelBuilder.CssFormatterBlock)child1).getNode().getText(), (Object)"@")) {
                String string = ((CssFormattingModelBuilder.CssFormatterBlock)child2).getNode().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0, (int)0);
                }
            }
            return RiderFormatUtilsKt.getRiderSpacing(child1, child2, defaultSpacing);
        }
    }
}

