/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.css.analysis;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.razor.css.analysis.CssInRazorErrorFilterKt;
import com.jetbrains.rider.razor.psi.RazorFileViewProvider;
import com.jetbrains.rider.razor.psi.RazorTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/razor/css/analysis/CssInRazorErrorFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "<init>", "()V", "shouldHighlightErrorElement", "", "errorElement", "Lcom/intellij/psi/PsiErrorElement;", "isDanglingTransition", "element", "Lcom/intellij/psi/PsiElement;", "isBadCharacter", "intellij.rider.plugins.razor.css"})
final class CssInRazorErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement errorElement) {
        PsiElement nextElement;
        Intrinsics.checkNotNullParameter((Object)errorElement, (String)"errorElement");
        if (!RazorTreeUtilKt.inRazorFile((PsiElement)errorElement)) {
            return true;
        }
        if (!(errorElement.getParent() instanceof CssElement)) {
            return true;
        }
        PsiFile psiFile = errorElement.getContainingFile();
        FileViewProvider fileViewProvider = psiFile != null ? psiFile.getViewProvider() : null;
        RazorFileViewProvider razorFileViewProvider = fileViewProvider instanceof RazorFileViewProvider ? (RazorFileViewProvider)fileViewProvider : null;
        if (razorFileViewProvider == null) {
            return true;
        }
        RazorFileViewProvider provider = razorFileViewProvider;
        PsiElement psiElement = provider.findElementAt(errorElement.getTextOffset(), provider.getTemplateDataLanguage());
        if (psiElement == null) {
            return true;
        }
        PsiElement element = psiElement;
        String string = errorElement.getErrorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorDescription(...)");
        if (StringsKt.endsWith$default((String)string, (String)"unexpected token", (boolean)false, (int)2, null)) {
            if (this.isDanglingTransition(element) && (nextElement = CssInRazorErrorFilterKt.access$findNextMeaningfulElement(provider, element)) != null) {
                String string2 = nextElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string2, (String)"@", (boolean)false, (int)2, null)) {
                    return false;
                }
            }
            if (element instanceof PsiWhiteSpace && (nextElement = CssInRazorErrorFilterKt.access$findNextMeaningfulElement(provider, element)) != null) {
                String string3 = nextElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string3, (String)"@", (boolean)false, (int)2, null)) {
                    return false;
                }
            }
        }
        String string4 = errorElement.getErrorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getErrorDescription(...)");
        if (StringsKt.endsWith$default((String)string4, (String)"a term expected", (boolean)false, (int)2, null) && element instanceof PsiWhiteSpace) {
            nextElement = CssInRazorErrorFilterKt.access$findNextMeaningfulElement(provider, element);
            PsiElement nextNextElement = CssInRazorErrorFilterKt.access$findNextMeaningfulElement(provider, nextElement);
            if (this.isBadCharacter(nextElement) && RazorTreeUtilKt.isRazorOuterElement(nextNextElement)) {
                return false;
            }
        }
        return true;
    }

    private final boolean isDanglingTransition(PsiElement element) {
        return this.isBadCharacter(element) && element.textMatches((CharSequence)"@");
    }

    private final boolean isBadCharacter(PsiElement element) {
        PsiElement psiElement = element;
        IElementType iElementType = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null;
        IElementType iElementType2 = CssElementTypes.CSS_BAD_CHARACTER;
        Intrinsics.checkNotNull((Object)iElementType2);
        return Intrinsics.areEqual((Object)iElementType, (Object)iElementType2);
    }
}

