/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.asp.highlighting;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.asp.AspScriptLanguageUtils;
import com.jetbrains.rider.asp.AspTokenTypes;
import com.jetbrains.rider.asp.highlighting.AspSyntaxHighlighter;
import com.jetbrains.rider.asp.html.HtmlInAspSyntaxHighlighter;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpFileType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/asp/highlighting/AspEditorSyntaxHighlighter;", "Lcom/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "myDefaultMime", "", "calculateDefaultMime", "updateHtmlLayer", "", "updateLayers", "", "intellij.rider.plugins.razor"})
public final class AspEditorSyntaxHighlighter
extends LayeredLexerEditorHighlighter {
    @Nullable
    private final Project project;
    @Nullable
    private final VirtualFile virtualFile;
    @Nullable
    private String myDefaultMime;

    public AspEditorSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        super((SyntaxHighlighter)new AspSyntaxHighlighter(), colors);
        this.project = project;
        this.virtualFile = virtualFile;
        this.myDefaultMime = this.calculateDefaultMime();
        this.updateHtmlLayer();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)((FileType)CSharpFileType.INSTANCE), (Project)this.project, (VirtualFile)this.virtualFile);
        Intrinsics.checkNotNull((Object)syntaxHighlighter);
        SyntaxHighlighter codeHighlighter = syntaxHighlighter;
        this.registerLayer(AspTokenTypes.CODE, new LayerDescriptor(codeHighlighter, "\n"));
        this.updateLayers();
    }

    private final String calculateDefaultMime() {
        if (this.project == null) {
            return null;
        }
        if (this.virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return AspScriptLanguageUtils.INSTANCE.calculateScriptLanguage(string);
    }

    private final void updateHtmlLayer() {
        HtmlInAspSyntaxHighlighter htmlHighlighter = new HtmlInAspSyntaxHighlighter(this.myDefaultMime);
        this.registerLayer(AspTokenTypes.TEMPLATE_DATA, new LayerDescriptor((SyntaxHighlighter)htmlHighlighter, "dummy"));
    }

    protected boolean updateLayers() {
        String defaultMime = this.calculateDefaultMime();
        if (StringUtil.equalsIgnoreCase((CharSequence)this.myDefaultMime, (CharSequence)defaultMime)) {
            return false;
        }
        this.myDefaultMime = defaultMime;
        this.updateHtmlLayer();
        return true;
    }
}

