/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCFlexAdapter;
import com.intellij.cidr.cpp.lexer._OCLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/cidr/cpp/lexer/OCLexer;", "Lcom/intellij/lexer/FlexAdapter;", "settings", "Lcom/intellij/cidr/cpp/lexer/CidrLexerSettings;", "<init>", "(Lcom/intellij/cidr/cpp/lexer/CidrLexerSettings;)V", "tokenTypeProvider", "Lcom/intellij/cidr/cpp/lexer/CidrTokenTypeProvider;", "getTokenTypeProvider", "()Lcom/intellij/cidr/cpp/lexer/CidrTokenTypeProvider;", "restore", "", "position", "Lcom/intellij/lexer/LexerPosition;", "Companion", "intellij.cidr.psi.base"})
public class OCLexer
extends FlexAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrTokenTypeProvider tokenTypeProvider;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION1 = _OCLexer.FLEX_JIT_ERROR_GUARD1;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION2 = _OCLexer.FLEX_JIT_ERROR_GUARD2;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION3 = _OCLexer.FLEX_JIT_ERROR_GUARD3;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION_ = _OCLexer.FLEX_ERROR;
    public static final int INITIAL = 0;
    public static final int INITIAL_INSIDE_LINE = 1024;
    public static final int DIRECTIVE_BODY_STATE = 8;
    public static final int PRAGMA_BODY_STATE = 12;
    public static final int INCLUDE_BODY_STATE = 10;
    public static final int MAX_RAW_STRING_PREFIX_LENGTH = 16;

    public OCLexer(@NotNull CidrLexerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super((FlexLexer)new OCFlexAdapter());
        FlexLexer flexLexer = this.getFlex();
        Intrinsics.checkNotNull((Object)flexLexer, (String)"null cannot be cast to non-null type com.intellij.cidr.cpp.lexer._OCLexer");
        _OCLexer base = (_OCLexer)flexLexer;
        base.setTokenTypeProvider(settings.getTokenTypeProvider());
        this.tokenTypeProvider = settings.getTokenTypeProvider();
        if (settings.getLanguageKind().isCpp()) {
            base.allowCPPKeywords();
        }
        if (settings.getLanguageKind().isCuda()) {
            base.allowCUDAKeywords();
        }
        if (settings.getLanguageKind().isObjC()) {
            base.allowObjCKeywords();
        }
        if (settings.getAllowNullabilityKeywords()) {
            base.allowNullabilityKeywords();
        }
        if (settings.getAllowNullabilityNullableResultKeywords()) {
            base.allowNullabilityNullableResultKeywords();
        }
        if (settings.getAllowGccAutoType()) {
            base.allowGccAutoType();
        }
        if (settings.getAllowAvailabilityExpression()) {
            base.allowAvailabilityExpression();
        }
        if (settings.getAllowMsvcExtensions()) {
            base.allowMsvcExtensions();
        }
        if (settings.getAllowRiderMsvcExtensions()) {
            base.allowRiderMsvcExtensions();
        }
        base.setLanguageStandard(settings.getLanguageLevel());
        if (settings.getTreatCppAltOpsAsKeywords()) {
            base.forHighlighting();
        }
    }

    @NotNull
    public final CidrTokenTypeProvider getTokenTypeProvider() {
        return this.tokenTypeProvider;
    }

    public void restore(@NotNull LexerPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003R\u001e\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u001e\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\u001e\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/cidr/cpp/lexer/OCLexer$Companion;", "", "<init>", "()V", "CHECK_JIT_ADAPTATION1", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "getCHECK_JIT_ADAPTATION1$annotations", "CHECK_JIT_ADAPTATION2", "getCHECK_JIT_ADAPTATION2$annotations", "CHECK_JIT_ADAPTATION3", "getCHECK_JIT_ADAPTATION3$annotations", "CHECK_JIT_ADAPTATION_", "getCHECK_JIT_ADAPTATION_$annotations", "INITIAL", "", "INITIAL_INSIDE_LINE", "DIRECTIVE_BODY_STATE", "PRAGMA_BODY_STATE", "INCLUDE_BODY_STATE", "MAX_RAW_STRING_PREFIX_LENGTH", "intellij.cidr.psi.base"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getCHECK_JIT_ADAPTATION1$annotations() {
        }

        private static /* synthetic */ void getCHECK_JIT_ADAPTATION2$annotations() {
        }

        private static /* synthetic */ void getCHECK_JIT_ADAPTATION3$annotations() {
        }

        private static /* synthetic */ void getCHECK_JIT_ADAPTATION_$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

