/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssAttribute
extends CssSelectorSuffix {
    @NotNull
    public OperatorType getOperatorType();

    @NotNull
    public String getAttributeName();

    @Nullable
    public PsiElement getAttributeNameIdentifier();

    @NotNull
    public String getAttributeValue();

    @Override
    @Nullable
    public String getName();

    public CssAttribute setName(@NonNls @NotNull String var1) throws IncorrectOperationException;

    public static enum OperatorType {
        NONE(""),
        EQUALS("="),
        CONTAINS_WORD("~="),
        STARTS_WITH_BEFORE_DASH("|="),
        STARTS_WITH("^="),
        ENDS_WITH("$="),
        CONTAINS("*="),
        JQUERY_NOT_EQUALS("!=");

        private final String myPresentation;

        private OperatorType(String presentation) {
            this.myPresentation = presentation;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public static OperatorType fromString(@NotNull String presentation) {
            if (presentation == null) {
                OperatorType.$$$reportNull$$$0(0);
            }
            for (OperatorType type : OperatorType.values()) {
                if (!presentation.equals(type.myPresentation)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown operator type: " + presentation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/psi/css/CssAttribute$OperatorType", "fromString"));
        }
    }
}

