/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector;

import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.multiplatform.SafeJsExport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lai/grazie/detector/DetectedLanguage;", "", "lang", "Lai/grazie/nlp/langs/Language;", "probability", "", "<init>", "(Lai/grazie/nlp/langs/Language;D)V", "getLang", "()Lai/grazie/nlp/langs/Language;", "getProbability", "()D", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nDetectedLanguage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetectedLanguage.kt\nai/grazie/detector/DetectedLanguage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class DetectedLanguage {
    @NotNull
    private final Language lang;
    private final double probability;

    public DetectedLanguage(@NotNull Language lang, double probability) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        this.lang = lang;
        this.probability = probability;
        if (!(this.probability >= 0.0)) {
            boolean $i$a$-require-DetectedLanguage$32 = false;
            String $i$a$-require-DetectedLanguage$32 = "Probability must be >= 0 but was " + this.probability;
            throw new IllegalArgumentException($i$a$-require-DetectedLanguage$32.toString());
        }
        if (!(this.probability <= 1.0)) {
            boolean bl = false;
            String string = "Probability must be <= 1 but was " + this.probability;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Language getLang() {
        return this.lang;
    }

    public final double getProbability() {
        return this.probability;
    }

    public final int compareTo(@NotNull DetectedLanguage other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int compare = Double.compare(other.probability, this.probability);
        return compare != 0 ? compare : this.lang.getIso().compareTo((Enum)other.lang.getIso());
    }

    @NotNull
    public final Language component1() {
        return this.lang;
    }

    public final double component2() {
        return this.probability;
    }

    @NotNull
    public final DetectedLanguage copy(@NotNull Language lang, double probability) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return new DetectedLanguage(lang, probability);
    }

    public static /* synthetic */ DetectedLanguage copy$default(DetectedLanguage detectedLanguage, Language language, double d, int n, Object object) {
        if ((n & 1) != 0) {
            language = detectedLanguage.lang;
        }
        if ((n & 2) != 0) {
            d = detectedLanguage.probability;
        }
        return detectedLanguage.copy(language, d);
    }

    @NotNull
    public String toString() {
        return "DetectedLanguage(lang=" + this.lang + ", probability=" + this.probability + ")";
    }

    public int hashCode() {
        int result2 = this.lang.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.probability);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DetectedLanguage)) {
            return false;
        }
        DetectedLanguage detectedLanguage = (DetectedLanguage)other;
        if (this.lang != detectedLanguage.lang) {
            return false;
        }
        return Double.compare(this.probability, detectedLanguage.probability) == 0;
    }
}

