/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlStubElementFactory<S extends StubElement<T>, T extends SqlElement>
implements StubElementFactory<S, T> {
    public T createPsi(@NotNull S stub) {
        if (stub == null) {
            SqlStubElementFactory.$$$reportNull$$$0(0);
        }
        SqlFileImpl file = (SqlFileImpl)stub.getParentStubOfType(SqlFileImpl.class);
        assert (file != null);
        SqlLanguageDialectEx dialect = file.getSqlLanguage();
        SqlParserDefinition definition = (SqlParserDefinition)((Object)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect));
        return (T)((SqlElement)definition.createElement(stub));
    }

    @Nullable
    protected static StringRef asStringRef(PsiElement nameElement) {
        String text = nameElement == null ? null : nameElement.getText();
        return text == null ? null : StringRef.fromString((String)text);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return !SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(node.getTreeParent().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/factories/SqlStubElementFactory", "createPsi"));
    }
}

