/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.renderdoc.rdClient;

import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.SwitchLogger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.renderdoc.rdClient.RenderDocHost;
import com.jetbrains.renderdoc.rdClient.RenderDocHostException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/renderdoc/rdClient/RenderDocHost;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "binDir", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;)V", "deferredExitCode", "Lkotlinx/coroutines/Deferred;", "Ljava/lang/Process;", "deferredPort", "Lkotlinx/coroutines/CompletableDeferred;", "", "getPort", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logHostMessage", "", "serverLogger", "Lcom/jetbrains/rd/util/Logger;", "defaultLogLevel", "Lcom/jetbrains/rd/util/LogLevel;", "message", "Companion", "renderdoc-rd-client"})
@SourceDebugExtension(value={"SMAP\nRenderDocHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocHost.kt\ncom/jetbrains/renderdoc/rdClient/RenderDocHost\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,115:1\n105#2:116\n98#2,4:117\n*S KotlinDebug\n*F\n+ 1 RenderDocHost.kt\ncom/jetbrains/renderdoc/rdClient/RenderDocHost\n*L\n49#1:116\n49#1:117,4\n*E\n"})
public final class RenderDocHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private Deferred<? extends Process> deferredExitCode;
    private CompletableDeferred<Integer> deferredPort;
    private static final Pattern HostMessageRegex = Pattern.compile("^\\[[^]]+] \\[([^]]+)] \\[(trace|debug|info|warn|err|critical|off)] (.*)");
    private static final Pattern HostIntroductionRegex = Pattern.compile("^HOST_INTRODUCTION: PORT=(\\d+)");

    public RenderDocHost(@NotNull Lifetime lifetime, @NotNull String binDir) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)binDir, (String)"binDir");
        this.lifetime = lifetime;
        Path binPath = Paths.get(binDir, new String[0]);
        Path path = binPath.resolve("RenderDocHost");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String renderDocHostPath = ((Object)path.toAbsolutePath()).toString();
        String[] stringArray = new String[]{renderDocHostPath};
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(stringArray).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE);
        this.lifetime.executeOrThrow(() -> RenderDocHost._init_$lambda$3(processBuilder, this));
    }

    @Nullable
    public final Object getPort(@NotNull Continuation<? super Integer> $completion) {
        CompletableDeferred<Integer> completableDeferred = this.deferredPort;
        if (completableDeferred == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deferredPort");
            completableDeferred = null;
        }
        return completableDeferred.await($completion);
    }

    /*
     * Unable to fully structure code
     */
    private final void logHostMessage(Logger serverLogger, LogLevel defaultLogLevel, String message) {
        block24: {
            block22: {
                matcher = RenderDocHost.HostMessageRegex.matcher(message);
                if (!matcher.find()) break block22;
                var6_5 = matcher.group(2);
                if (var6_5 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var6_5.hashCode()) {
                    case 3641990: {
                        if (var6_5.equals("warn")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 110620997: {
                        if (var6_5.equals("trace")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 95458899: {
                        if (var6_5.equals("debug")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 100709: {
                        if (var6_5.equals("err")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 1952151455: {
                        if (var6_5.equals("critical")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 3237038: {
                        if (var6_5.equals("info")) {
                            tmp = 6;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        v0 = LogLevel.Trace;
                        break;
                    }
                    case 3: {
                        v0 = LogLevel.Debug;
                        break;
                    }
                    case 6: {
                        v0 = LogLevel.Info;
                        break;
                    }
                    case 1: {
                        v0 = LogLevel.Warn;
                        break;
                    }
                    case 4: {
                        v0 = LogLevel.Error;
                        break;
                    }
                    case 5: {
                        v0 = LogLevel.Fatal;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v0 = defaultLogLevel;
                    }
                }
                logLevel = v0;
                serverLogger.log(logLevel, (Object)(matcher.group(1) + " | " + matcher.group(3)), null);
                break block24;
            }
            serverLogger.log(defaultLogLevel, (Object)message, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$3$lambda$1(Process $process, RenderDocHost this$0, SwitchLogger $serverLogger, Throwable ex) {
        void $this$log$iv$iv;
        int exitCode = $process.exitValue();
        CompletableDeferred<Integer> completableDeferred = this$0.deferredPort;
        if (completableDeferred == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deferredPort");
            completableDeferred = null;
        }
        completableDeferred.completeExceptionally((Throwable)new RenderDocHostException(exitCode));
        Logger $this$info$iv = (Logger)$serverLogger;
        boolean $i$f$info = false;
        Logger logger = $this$info$iv;
        LogLevel level$iv$iv = LogLevel.Info;
        boolean $i$f$log = false;
        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
            LogLevel logLevel = level$iv$iv;
            void var11_11 = $this$log$iv$iv;
            boolean bl = false;
            String string = "RenderDocHost exited with " + exitCode + " code";
            var11_11.log(logLevel, (Object)string, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(RenderDocHost this$0, Process $process) {
        CompletableDeferred<Integer> completableDeferred = this$0.deferredPort;
        if (completableDeferred == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deferredPort");
            completableDeferred = null;
        }
        Job.DefaultImpls.cancel$default((Job)((Job)completableDeferred), null, (int)1, null);
        $process.destroy();
        $process.waitFor(1L, TimeUnit.SECONDS);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ProcessBuilder $processBuilder, RenderDocHost this$0) {
        SwitchLogger serverLogger = LoggerKt.getLogger((String)"RenderDocHost");
        Process process = $processBuilder.start();
        CompletableFuture<Process> completableFuture = process.onExit();
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"onExit(...)");
        this$0.deferredExitCode = FutureKt.asDeferred((CompletionStage)completableFuture);
        this$0.deferredPort = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        Deferred<? extends Process> deferred = this$0.deferredExitCode;
        if (deferred == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deferredExitCode");
            deferred = null;
        }
        deferred.invokeOnCompletion(arg_0 -> RenderDocHost.lambda$3$lambda$1(process, this$0, serverLogger, arg_0));
        Ref.BooleanRef introduced = new Ref.BooleanRef();
        CoroutineDispatcher watchesDispatchers = Dispatchers.getIO().limitedParallelism(2);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this$0.lifetime, (CoroutineContext)((CoroutineContext)watchesDispatchers), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, this$0, introduced, serverLogger, null){
            int label;
            final /* synthetic */ Process $process;
            final /* synthetic */ RenderDocHost this$0;
            final /* synthetic */ Ref.BooleanRef $introduced;
            final /* synthetic */ SwitchLogger $serverLogger;
            {
                this.$process = $process;
                this.this$0 = $receiver;
                this.$introduced = $introduced;
                this.$serverLogger = $serverLogger;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            this.$process.inputReader().lines().forEach(arg_0 -> 1.2.invokeSuspend$lambda$2(arg_0 -> 1.2.invokeSuspend$lambda$1(this.$introduced, this.this$0, this.$serverLogger, arg_0), arg_0));
                            return Unit.INSTANCE;
                        }
                        catch (UncheckedIOException ex) {
                            if (!RLifetimeKt.isAlive((Lifetime)RenderDocHost.access$getLifetime$p(this.this$0))) return Unit.INSTANCE;
                            throw ex;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$1(Ref.BooleanRef $introduced, RenderDocHost this$0, SwitchLogger $serverLogger, String line) {
                void $this$log$iv$iv;
                Matcher matcher;
                if (!$introduced.element && (matcher = RenderDocHost.access$getHostIntroductionRegex$cp().matcher(line)).find()) {
                    CompletableDeferred completableDeferred = RenderDocHost.access$getDeferredPort$p(this$0);
                    if (completableDeferred == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"deferredPort");
                        completableDeferred = null;
                    }
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    completableDeferred.complete((Object)Integer.parseInt(string));
                    $introduced.element = true;
                    return Unit.INSTANCE;
                }
                Logger $this$debug$iv = (Logger)$serverLogger;
                boolean $i$f$debug = false;
                Logger logger = $this$debug$iv;
                LogLevel level$iv$iv = LogLevel.Debug;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var10_10 = $this$log$iv$iv;
                    boolean bl = false;
                    Logger logger2 = (Logger)$serverLogger;
                    Intrinsics.checkNotNull((Object)line);
                    RenderDocHost.access$logHostMessage(this$0, logger2, LogLevel.Debug, line);
                    Unit unit = Unit.INSTANCE;
                    var10_10.log(logLevel, (Object)unit, null);
                }
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$2(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }), (int)2, null);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this$0.lifetime, (CoroutineContext)((CoroutineContext)watchesDispatchers), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, this$0, serverLogger, null){
            int label;
            final /* synthetic */ Process $process;
            final /* synthetic */ RenderDocHost this$0;
            final /* synthetic */ SwitchLogger $serverLogger;
            {
                this.$process = $process;
                this.this$0 = $receiver;
                this.$serverLogger = $serverLogger;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            this.$process.errorReader().lines().forEach(arg_0 -> 1.3.invokeSuspend$lambda$1(arg_0 -> 1.3.invokeSuspend$lambda$0(this.this$0, this.$serverLogger, arg_0), arg_0));
                            return Unit.INSTANCE;
                        }
                        catch (UncheckedIOException ex) {
                            if (!RLifetimeKt.isAlive((Lifetime)RenderDocHost.access$getLifetime$p(this.this$0))) return Unit.INSTANCE;
                            throw ex;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(RenderDocHost this$0, SwitchLogger $serverLogger, String it) {
                Logger logger = (Logger)$serverLogger;
                Intrinsics.checkNotNull((Object)it);
                RenderDocHost.access$logHostMessage(this$0, logger, LogLevel.Error, it);
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }), (int)2, null);
        this$0.lifetime.onTermination(() -> RenderDocHost.lambda$3$lambda$2(this$0, process));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(RenderDocHost $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ void access$logHostMessage(RenderDocHost $this, Logger serverLogger, LogLevel defaultLogLevel, String message) {
        $this.logHostMessage(serverLogger, defaultLogLevel, message);
    }

    public static final /* synthetic */ Pattern access$getHostIntroductionRegex$cp() {
        return HostIntroductionRegex;
    }

    public static final /* synthetic */ CompletableDeferred access$getDeferredPort$p(RenderDocHost $this) {
        return $this.deferredPort;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/renderdoc/rdClient/RenderDocHost$Companion;", "", "<init>", "()V", "HostMessageRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "HostIntroductionRegex", "renderdoc-rd-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

