/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.rider.plugins.renderdoc.core.RenderDocPixelInput;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocExpandedTextureDialog;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTextureSelectionPanel;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/utils/TexturePreviewUtil;", "", "<init>", "()V", "Companion", "intellij.rider.plugins.renderdoc"})
public final class TexturePreviewUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int HIGHLIGHTED_PIXEL_WIDTH_ON_PREVIEWER = 5;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J.\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J(\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J*\u0010#\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010$\u001a\u00020\u0005H\u0002J\u000e\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/utils/TexturePreviewUtil$Companion;", "", "<init>", "()V", "HIGHLIGHTED_PIXEL_WIDTH_ON_PREVIEWER", "", "showImageViewerDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "textureSelectionPanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;", "getImageWithSelectedPixel", "Ljava/awt/image/BufferedImage;", "image", "Ljava/awt/Image;", "input", "Lcom/jetbrains/rider/plugins/renderdoc/core/RenderDocPixelInput;", "originDimension", "Ljava/awt/Dimension;", "convertRGBBufferToImage", "buffer", "", "width", "height", "getZoomedSubimage", "originalImage", "x", "y", "preferredRadius", "zoomFactor", "createBorderAroundPixel", "left", "top", "scale", "getColorToSeparatePixel", "borderWidth", "copyBufferedImage", "intellij.rider.plugins.renderdoc"})
    public static final class Companion {
        private Companion() {
        }

        public final void showImageViewerDialog(@NotNull Project project, @NotNull RenderDocTextureSelectionPanel textureSelectionPanel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)textureSelectionPanel, (String)"textureSelectionPanel");
            JFrame jFrame = WindowManager.getInstance().getFrame(project);
            if (jFrame == null) {
                return;
            }
            JFrame frame = jFrame;
            Dimension frameSize = frame.getSize();
            Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
            RenderDocExpandedTextureDialog window = new RenderDocExpandedTextureDialog(project, textureSelectionPanel, (Function0<Unit>)((Function0)() -> Companion.showImageViewerDialog$lambda$0(textureSelectionPanel)));
            window.setSize(size.width, size.height);
            window.centerRelativeToParent();
            window.show();
        }

        @NotNull
        public final BufferedImage getImageWithSelectedPixel(@NotNull Image image, @NotNull RenderDocPixelInput input, @NotNull Dimension originDimension) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)originDimension, (String)"originDimension");
            BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
            BufferedImage bufferedImage2 = bufferedImage;
            double scaleX = (double)bufferedImage2.getWidth() / (double)originDimension.width;
            double scaleY = (double)bufferedImage2.getHeight() / (double)originDimension.height;
            int x = (int)((double)input.getX-pVg5ArA() * scaleX);
            int y = (int)((double)input.getY-pVg5ArA() * scaleY);
            return this.createBorderAroundPixel(bufferedImage2, x, y, (int)Math.rint(Math.max(scaleX, scaleY)));
        }

        @Nullable
        public final BufferedImage convertRGBBufferToImage(@NotNull byte[] buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (buffer.length != width * height * 3) {
                return null;
            }
            BufferedImage bufferedImage = ImageUtil.createImage((int)width, (int)height, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image = bufferedImage;
            int index = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int r = buffer[index] & 0xFF;
                    int g = buffer[index + 1] & 0xFF;
                    int b = buffer[index + 2] & 0xFF;
                    int rgb = r << 16 | g << 8 | b;
                    image.setRGB(x, y, rgb);
                    index += 3;
                }
            }
            return image.getSubimage(0, 0, width, height);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final BufferedImage getZoomedSubimage(@NotNull BufferedImage originalImage, int x, int y, int preferredRadius, int zoomFactor) {
            Intrinsics.checkNotNullParameter((Object)originalImage, (String)"originalImage");
            radius = preferredRadius + zoomFactor - preferredRadius % zoomFactor;
            originRadius = radius / zoomFactor;
            topLeftX = x - originRadius;
            topLeftY = y - originRadius;
            newWidth = 2 * radius + zoomFactor;
            newHeight = 2 * radius + zoomFactor;
            v0 = ImageUtil.createImage((int)newWidth, (int)newHeight, (int)originalImage.getType());
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createImage(...)");
            zoomedImage = v0;
            borderColor = com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.TexturePreviewUtil$Companion.getColorToSeparatePixel$default(this, originalImage, x, y, 0, 8, null);
            for (i = 0; i < newWidth; ++i) {
                for (j = 0; j < newHeight; ++j) {
                    block5: {
                        block4: {
                            originalI = i / zoomFactor + topLeftX;
                            originalJ = j / zoomFactor + topLeftY;
                            if (originalI != x || originalJ != y || !com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.TexturePreviewUtil$Companion.getZoomedSubimage$isCentralPixelBorder(zoomFactor, i, j)) break block4;
                            v1 = borderColor;
                            break block5;
                        }
                        v2 = 0 <= originalI ? originalI < originalImage.getWidth() : false;
                        if (!v2) ** GOTO lbl-1000
                        v3 = 0 <= originalJ ? originalJ < originalImage.getHeight() : false;
                        if (v3) {
                            v1 = originalImage.getRGB(originalI, originalJ);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = JBColor.DARK_GRAY.getRGB();
                        }
                    }
                    rgb = v1;
                    zoomedImage.setRGB(i, j, rgb);
                }
            }
            v4 = zoomedImage.getSubimage(0, 0, newWidth, newHeight);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getSubimage(...)");
            return v4;
        }

        private final BufferedImage createBorderAroundPixel(BufferedImage image, int left, int top, int scale) {
            block7: {
                int centerX = left + scale / 2;
                int centerY = top + scale / 2;
                boolean bl = 0 <= left ? left < image.getWidth() : false;
                if (!bl) break block7;
                boolean bl2 = 0 <= top ? top < image.getHeight() : false;
                if (!bl2) break block7;
                int borderWidth = 2;
                int half = Math.max(scale / 2, borderWidth);
                int color = this.getColorToSeparatePixel(image, centerX, centerY, borderWidth);
                IntRange innerRange = new IntRange(-half + borderWidth, half - borderWidth);
                int dx = -half;
                if (dx > half) break block7;
                while (true) {
                    block8: {
                        int dy;
                        if ((dy = -half) > half) break block8;
                        while (true) {
                            block10: {
                                block9: {
                                    int n = innerRange.getFirst();
                                    boolean bl3 = dx <= innerRange.getLast() ? n <= dx : false;
                                    if (!bl3) break block9;
                                    n = innerRange.getFirst();
                                    if (dy <= innerRange.getLast() ? n <= dy : false) break block10;
                                }
                                int i = centerX + dx;
                                int j = centerY + dy;
                                boolean bl4 = 0 <= i ? i < image.getWidth() : false;
                                if (bl4) {
                                    boolean bl5 = 0 <= j ? j < image.getHeight() : false;
                                    if (bl5) {
                                        image.setRGB(i, j, color);
                                    }
                                }
                            }
                            if (dy == half) break;
                            ++dy;
                        }
                    }
                    if (dx == half) break;
                    ++dx;
                }
            }
            return image;
        }

        private final int getColorToSeparatePixel(BufferedImage originalImage, int x, int y, int borderWidth) {
            int blue;
            int green;
            int red;
            double brightness;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int count = 0;
            Object[] objectArray = new Integer[]{-borderWidth, 0, borderWidth};
            Iterator iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
            while (iterator.hasNext()) {
                int dx = ((Number)iterator.next()).intValue();
                Object[] objectArray2 = new Integer[]{-borderWidth, 0, borderWidth};
                Iterator iterator2 = CollectionsKt.listOf((Object[])objectArray2).iterator();
                while (iterator2.hasNext()) {
                    int dy = ((Number)iterator2.next()).intValue();
                    int originalX = x + dx;
                    int originalY = y + dy;
                    boolean bl = 0 <= originalX ? originalX < originalImage.getWidth() : false;
                    if (!bl) continue;
                    boolean bl2 = 0 <= originalY ? originalY < originalImage.getHeight() : false;
                    if (!bl2) continue;
                    int rgb = originalImage.getRGB(originalX, originalY);
                    sumR += rgb >> 16 & 0xFF;
                    sumG += rgb >> 8 & 0xFF;
                    sumB += rgb & 0xFF;
                    ++count;
                }
            }
            if (count == 0) {
                ++count;
            }
            if ((brightness = (double)(red = 255 - sumR / count) * 0.299 + (double)(green = 255 - sumG / count) * 0.587 + (double)(blue = 255 - sumB / count) * 0.114) > 127.0) {
                red = Math.min(255, red + 50);
                green = Math.min(255, green + 50);
                blue = Math.min(255, blue + 50);
            } else {
                red = Math.max(0, red - 50);
                green = Math.max(0, green - 50);
                blue = Math.max(0, blue - 50);
            }
            int alpha = originalImage.getType() == 2 ? 255 : 0;
            return alpha << 24 | red << 16 | green << 8 | blue;
        }

        static /* synthetic */ int getColorToSeparatePixel$default(Companion companion, BufferedImage bufferedImage, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = 1;
            }
            return companion.getColorToSeparatePixel(bufferedImage, n, n2, n3);
        }

        @NotNull
        public final BufferedImage copyBufferedImage(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Pair pair = TuplesKt.to((Object)image.getWidth(), (Object)image.getHeight());
            int width = ((Number)pair.component1()).intValue();
            int height = ((Number)pair.component2()).intValue();
            BufferedImage bufferedImage = ImageUtil.createImage((int)width, (int)height, (int)image.getType());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage copiedImage = bufferedImage;
            copiedImage.setData(image.getData(new Rectangle(width, height)));
            BufferedImage bufferedImage2 = copiedImage.getSubimage(0, 0, width, height);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"getSubimage(...)");
            return bufferedImage2;
        }

        private static final Unit showImageViewerDialog$lambda$0(RenderDocTextureSelectionPanel $textureSelectionPanel) {
            $textureSelectionPanel.setExpandedDialog$intellij_rider_plugins_renderdoc(null);
            return Unit.INSTANCE;
        }

        private static final boolean getZoomedSubimage$isCentralPixelBorder(int $zoomFactor, int i, int j) {
            return i % $zoomFactor == 0 || j % $zoomFactor == 0 || (i + 1) % $zoomFactor == 0 || (j + 1) % $zoomFactor == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

