/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow.utils;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\b\u0010\n\u001a\u00020\u0006H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "getProjectDir", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/vfs/VirtualFile;", "hasUnityFileStructure", "", "project", "hasLibraryFolder", "isUnityProject", "isUnityPluginEnabled", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocProjectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocProjectUtils.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/utils/RenderDocProjectUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,40:1\n12970#2,2:41\n*S KotlinDebug\n*F\n+ 1 RenderDocProjectUtils.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/utils/RenderDocProjectUtilsKt\n*L\n24#1:41,2\n*E\n"})
public final class RenderDocProjectUtilsKt {
    @NotNull
    public static final VirtualFile getProjectDir(@NotNull Project $this$projectDir) {
        Intrinsics.checkNotNullParameter((Object)$this$projectDir, (String)"<this>");
        VirtualFile virtualFile = DocumentUtilKt.toVirtualFile((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)$this$projectDir), (boolean)true);
        if (virtualFile == null) {
            throw new IllegalStateException(("Virtual file not found for solution directory: " + SolutionHostExtensionsKt.getSolutionDirectory((Project)$this$projectDir)).toString());
        }
        return virtualFile;
    }

    private static final boolean hasUnityFileStructure(Project project) {
        return !project.isDefault() && RenderDocProjectUtilsKt.hasUnityFileStructure(RenderDocProjectUtilsKt.getProjectDir(project));
    }

    private static final boolean hasUnityFileStructure(VirtualFile projectDir) {
        boolean bl;
        block3: {
            VirtualFile virtualFile = projectDir.findChild("Assets");
            boolean bl2 = virtualFile != null ? !virtualFile.isDirectory() : false;
            if (bl2) {
                return false;
            }
            VirtualFile projectSettings = projectDir.findChild("ProjectSettings");
            if (projectSettings == null || !projectSettings.isDirectory()) {
                return false;
            }
            VirtualFile[] virtualFileArray = projectSettings.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"ProjectVersion.txt") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"asset"))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean hasLibraryFolder(Project project) {
        VirtualFile projectDir = RenderDocProjectUtilsKt.getProjectDir(project);
        VirtualFile virtualFile = projectDir.findChild("Library");
        return !(virtualFile != null ? !virtualFile.isDirectory() : false);
    }

    public static final boolean isUnityProject(@NotNull Project $this$isUnityProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnityProject, (String)"<this>");
        return RenderDocProjectUtilsKt.hasUnityFileStructure($this$isUnityProject) && RenderDocProjectUtilsKt.hasLibraryFolder($this$isUnityProject);
    }

    public static final boolean isUnityPluginEnabled() {
        return PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("com.intellij.resharper.unity")) != null;
    }
}

