/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow.actions;

import com.intellij.ui.JBColor;
import com.jetbrains.rider.plugins.renderdoc.fus.FrameViewerUsagesCollector;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTextureSelectionPanel;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.TexturePreviewUtil;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/actions/SelectPixelAdapter;", "Ljava/awt/event/MouseAdapter;", "texturePanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;", "selectionPreviewerHandler", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "<init>", "(Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;Lkotlin/jvm/functions/Function1;)V", "popup", "Ljavax/swing/JWindow;", "imageLabel", "Ljavax/swing/JLabel;", "PIXEL_WIDTH", "", "mousePressed", "e", "mouseDragged", "mouseReleased", "isClickOnImage", "", "point", "Ljava/awt/Point;", "component", "Ljava/awt/Component;", "showZoomedPopup", "imageComponent", "adjustPopupLocation", "pointOnScreen", "updateZoomedImage", "Ljava/awt/image/BufferedImage;", "imageSize", "Ljava/awt/Dimension;", "radius", "intellij.rider.plugins.renderdoc"})
public final class SelectPixelAdapter
extends MouseAdapter {
    @NotNull
    private final RenderDocTextureSelectionPanel texturePanel;
    @NotNull
    private final Function1<MouseEvent, Unit> selectionPreviewerHandler;
    @Nullable
    private JWindow popup;
    @NotNull
    private JLabel imageLabel;
    private final int PIXEL_WIDTH;

    public SelectPixelAdapter(@NotNull RenderDocTextureSelectionPanel texturePanel, @NotNull Function1<? super MouseEvent, Unit> selectionPreviewerHandler) {
        Intrinsics.checkNotNullParameter((Object)texturePanel, (String)"texturePanel");
        Intrinsics.checkNotNullParameter(selectionPreviewerHandler, (String)"selectionPreviewerHandler");
        this.texturePanel = texturePanel;
        this.selectionPreviewerHandler = selectionPreviewerHandler;
        this.imageLabel = new JLabel();
        this.PIXEL_WIDTH = 30;
    }

    public /* synthetic */ SelectPixelAdapter(RenderDocTextureSelectionPanel renderDocTextureSelectionPanel, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = SelectPixelAdapter::_init_$lambda$0;
        }
        this(renderDocTextureSelectionPanel, (Function1<? super MouseEvent, Unit>)function1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
        Component comp = (Component)object;
        if (SwingUtilities.isLeftMouseButton(e) && !this.texturePanel.getImageComponent().isEmpty()) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            if (this.isClickOnImage(point, comp)) {
                FrameViewerUsagesCollector.INSTANCE.logPixelSelected(this.texturePanel.getTextureType(), comp == this.texturePanel.getImageComponent() ? FrameViewerUsagesCollector.PixelSelectionLocationEnum.TOOL_WINDOW : FrameViewerUsagesCollector.PixelSelectionLocationEnum.EXPANDED_TEXTURE);
                Point point2 = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
                this.showZoomedPopup(point2, comp);
                return;
            }
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (SwingUtilities.isLeftMouseButton(e) && this.popup != null) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            Object object = e.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
            this.showZoomedPopup(point, (Component)object);
        } else {
            super.mouseDragged(e);
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (SwingUtilities.isLeftMouseButton(e) && this.popup != null) {
            this.selectionPreviewerHandler.invoke((Object)e);
            JWindow jWindow = this.popup;
            if (jWindow != null) {
                jWindow.dispose();
            }
            this.popup = null;
        } else {
            super.mouseReleased(e);
        }
    }

    private final boolean isClickOnImage(Point point, Component component) {
        RenderDocTextureSelectionPanel.BufferedImagePanel bufferedImagePanel = component instanceof RenderDocTextureSelectionPanel.BufferedImagePanel ? (RenderDocTextureSelectionPanel.BufferedImagePanel)component : null;
        if (bufferedImagePanel == null) {
            return true;
        }
        RenderDocTextureSelectionPanel.BufferedImagePanel comp = bufferedImagePanel;
        Dimension imageSize = comp.getDimensions();
        int left = (comp.getWidth() - imageSize.width) / 2;
        int top = (comp.getHeight() - imageSize.height) / 2;
        return point.x >= left && point.x < left + imageSize.width && point.y >= top && point.y < top + imageSize.height;
    }

    private final void showZoomedPopup(Point point, Component imageComponent) {
        Point point2;
        Dimension imageSize = null;
        Point $this$showZoomedPopup_u24lambda_u240 = point2 = imageComponent.getLocationOnScreen();
        boolean bl = false;
        $this$showZoomedPopup_u24lambda_u240.x += point.x;
        $this$showZoomedPopup_u24lambda_u240.y += point.y;
        Point point3 = point2;
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"apply(...)");
        Point locationOnScreen = point3;
        if (Intrinsics.areEqual((Object)imageComponent, (Object)this.texturePanel.getImageComponent())) {
            Intrinsics.checkNotNull((Object)imageComponent, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTextureSelectionPanel.BufferedImagePanel");
            RenderDocTextureSelectionPanel.BufferedImagePanel comp = (RenderDocTextureSelectionPanel.BufferedImagePanel)imageComponent;
            imageSize = comp.getDimensions();
            point.x -= (comp.getWidth() - imageSize.width) / 2;
            point.y -= (comp.getHeight() - imageSize.height) / 2;
        } else {
            Dimension dimension = imageComponent.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            imageSize = dimension;
        }
        point.x = Math.min(Math.max(0, point.x), imageSize.width);
        point.y = Math.min(Math.max(0, point.y), imageSize.height);
        int radius = Math.min((this.texturePanel.getHeight() + this.texturePanel.getWidth()) / 2, 150);
        BufferedImage zoomedImage = this.updateZoomedImage(point, imageSize, radius);
        Window parent = SwingUtilities.getWindowAncestor(imageComponent);
        JWindow jWindow = this.popup;
        if (jWindow == null) {
            JWindow jWindow2;
            JWindow $this$showZoomedPopup_u24lambda_u241 = jWindow2 = new JWindow(parent);
            boolean bl2 = false;
            $this$showZoomedPopup_u24lambda_u241.setType(Window.Type.POPUP);
            $this$showZoomedPopup_u24lambda_u241.setAlwaysOnTop(true);
            $this$showZoomedPopup_u24lambda_u241.getContentPane().add(this.imageLabel);
            $this$showZoomedPopup_u24lambda_u241.setSize(new Dimension(zoomedImage.getWidth(), zoomedImage.getHeight()));
            $this$showZoomedPopup_u24lambda_u241.setShape(new Ellipse2D.Float(0.0f, 0.0f, zoomedImage.getWidth(), zoomedImage.getHeight()));
            jWindow = jWindow2;
        }
        JWindow popup = jWindow;
        this.imageLabel.setIcon(new ImageIcon(zoomedImage));
        this.adjustPopupLocation(locationOnScreen, popup);
        popup.setVisible(true);
        this.popup = popup;
    }

    private final void adjustPopupLocation(Point pointOnScreen, JWindow popup) {
        boolean hasYOverflow;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int r = popup.getWidth() / 2;
        boolean hasXOverflow = pointOnScreen.x >= screen.width - 2 * r;
        boolean bl = hasYOverflow = pointOnScreen.y >= screen.height - 2 * r;
        if (hasXOverflow) {
            pointOnScreen.x -= 2 * r;
        }
        if (hasYOverflow) {
            pointOnScreen.y -= 2 * r;
        }
        popup.setLocation(pointOnScreen);
    }

    private final BufferedImage updateZoomedImage(Point point, Dimension imageSize, int radius) {
        BufferedImage image = this.texturePanel.getTextureImage();
        int originX = Math.min(image.getWidth() * point.x / imageSize.width, image.getWidth() - 1);
        int originY = Math.min(image.getHeight() * point.y / imageSize.height, image.getHeight() - 1);
        this.texturePanel.updatePixelInfo(originX, originY);
        BufferedImage zoomedImage = TexturePreviewUtil.Companion.getZoomedSubimage(image, originX, originY, radius, this.PIXEL_WIDTH);
        Graphics2D g2d = zoomedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(JBColor.border());
        g2d.setStroke(new BasicStroke(4.0f));
        g2d.draw(new Ellipse2D.Double(0.0, 0.0, (double)zoomedImage.getWidth() - 1.0, (double)zoomedImage.getWidth() - 1.0));
        g2d.dispose();
        return zoomedImage;
    }

    private static final Unit _init_$lambda$0(MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

