/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.plugins.renderdoc.RenderDocBundle;
import com.jetbrains.rider.plugins.renderdoc.core.RenderDocService;
import com.jetbrains.rider.plugins.renderdoc.feedback.FrameViewerFeedbackSurveyConfig;
import com.jetbrains.rider.plugins.renderdoc.feedback.RenderDocFeedbackService;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocDataKeys;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocEmptyStatePanel;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTool;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocToolContent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\"#B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0017J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent;", "Lcom/intellij/ui/components/JBLoadingPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/jetbrains/rider/plugins/renderdoc/core/RenderDocService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/renderdoc/core/RenderDocService;)V", "bannersPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "errorBannerWrapper", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent$ErrorBannerWrapper;", "feedbackBannerWrapper", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent$FeedbackBannerWrapper;", "emptyStatePanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocEmptyStatePanel;", "capturePanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTool;", "getCapturePanel$intellij_rider_plugins_renderdoc", "()Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTool;", "showCapturePanel", "", "showEmptyStatePanel", "closeCapture", "setLoadingStatus", "isLoading", "", "openCapture", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "ErrorBannerWrapper", "FeedbackBannerWrapper", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocToolContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocToolContent.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class RenderDocToolContent
extends JBLoadingPanel
implements Disposable,
UiDataProvider {
    @NotNull
    private final BorderLayoutPanel bannersPanel;
    @NotNull
    private final ErrorBannerWrapper errorBannerWrapper;
    @NotNull
    private final FeedbackBannerWrapper feedbackBannerWrapper;
    @NotNull
    private final RenderDocEmptyStatePanel emptyStatePanel;
    @NotNull
    private final RenderDocTool capturePanel;

    public RenderDocToolContent(@NotNull Project project, @NotNull RenderDocService service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)service), (String)"service");
        super((LayoutManager)new BorderLayout(), arg_0 -> RenderDocToolContent._init_$lambda$0(project, arg_0));
        this.bannersPanel = new BorderLayoutPanel();
        this.errorBannerWrapper = new ErrorBannerWrapper(project);
        this.feedbackBannerWrapper = new FeedbackBannerWrapper(project);
        this.emptyStatePanel = new RenderDocEmptyStatePanel();
        this.capturePanel = new RenderDocTool(project, service, this.feedbackBannerWrapper);
        this.bannersPanel.addToTop((Component)((Object)this.errorBannerWrapper));
        this.add((Component)this.bannersPanel, "North");
        this.showEmptyStatePanel();
    }

    @NotNull
    public final RenderDocTool getCapturePanel$intellij_rider_plugins_renderdoc() {
        return this.capturePanel;
    }

    public final void showCapturePanel() {
        this.bannersPanel.remove((Component)((Object)this.feedbackBannerWrapper));
        this.getContentPanel().remove((Component)((Object)this.emptyStatePanel));
        this.capturePanel.getUpperPanel$intellij_rider_plugins_renderdoc().addToTop((Component)((Object)this.feedbackBannerWrapper));
        this.add((Component)((Object)this.capturePanel), "Center");
        this.revalidate();
        this.repaint();
    }

    public final void showEmptyStatePanel() {
        this.errorBannerWrapper.hideBanner();
        this.capturePanel.remove((Component)((Object)this.feedbackBannerWrapper));
        this.getContentPanel().remove((Component)((Object)this.capturePanel));
        this.bannersPanel.addToBottom((Component)((Object)this.feedbackBannerWrapper));
        this.add((Component)((Object)this.emptyStatePanel), "Center");
        this.revalidate();
        this.repaint();
    }

    public final void closeCapture() {
        this.capturePanel.closeCapture();
        this.showEmptyStatePanel();
    }

    public final void setLoadingStatus(boolean isLoading) {
        if (this.getContentPanel().isAncestorOf((Component)((Object)this.capturePanel))) {
            this.capturePanel.showTopRightLoader$intellij_rider_plugins_renderdoc(isLoading);
        } else if (isLoading) {
            this.startLoading();
        } else {
            this.stopLoading();
        }
    }

    public final void openCapture() {
        boolean opened = this.capturePanel.openCapture$intellij_rider_plugins_renderdoc((Function0<Unit>)((Function0)() -> RenderDocToolContent.openCapture$lambda$0(this)), (Function0<Unit>)((Function0)() -> RenderDocToolContent.openCapture$lambda$1(this)), (Function0<Unit>)((Function0)() -> RenderDocToolContent.openCapture$lambda$2(this)));
        if (opened) {
            RenderDocFeedbackService.Companion.getInstance().scheduleFeedbackBannerCreation(this.feedbackBannerWrapper);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.capturePanel);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(RenderDocDataKeys.INSTANCE.getRENDERDOC_TOOL_WINDOW(), (Object)this);
    }

    private static final LoadingDecorator _init_$lambda$0(Project $project, JPanel panel) {
        LoadingDecorator loadingDecorator;
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        LoadingDecorator $this$_init__u24lambda_u240_u240 = loadingDecorator = new LoadingDecorator((JComponent)panel, (Disposable)$project, 0, false, null, 24, null);
        boolean bl = false;
        $this$_init__u24lambda_u240_u240.setOverlayBackground(LoadingDecorator.OVERLAY_BACKGROUND);
        return loadingDecorator;
    }

    private static final Unit openCapture$lambda$0(RenderDocToolContent this$0) {
        ActionsKt.runInEdt$default(null, () -> RenderDocToolContent.openCapture$lambda$0$0(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit openCapture$lambda$0$0(RenderDocToolContent this$0) {
        this$0.setLoadingStatus(true);
        return Unit.INSTANCE;
    }

    private static final Unit openCapture$lambda$1(RenderDocToolContent this$0) {
        ActionsKt.runInEdt$default(null, () -> RenderDocToolContent.openCapture$lambda$1$0(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit openCapture$lambda$1$0(RenderDocToolContent this$0) {
        this$0.setLoadingStatus(false);
        if (!this$0.getContentPanel().isAncestorOf((Component)((Object)this$0.capturePanel))) {
            this$0.showCapturePanel();
        }
        this$0.errorBannerWrapper.hideBanner();
        return Unit.INSTANCE;
    }

    private static final Unit openCapture$lambda$2(RenderDocToolContent this$0) {
        ActionsKt.runInEdt$default(null, () -> RenderDocToolContent.openCapture$lambda$2$0(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit openCapture$lambda$2$0(RenderDocToolContent this$0) {
        this$0.setLoadingStatus(false);
        if (!this$0.getContentPanel().isAncestorOf((Component)((Object)this$0.emptyStatePanel))) {
            this$0.showEmptyStatePanel();
        }
        this$0.errorBannerWrapper.showBanner();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent$ErrorBannerWrapper;", "Lcom/intellij/ui/components/panels/Wrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "showBanner", "", "hideBanner", "intellij.rider.plugins.renderdoc"})
    public static final class ErrorBannerWrapper
    extends Wrapper {
        @NotNull
        private final Project project;

        public ErrorBannerWrapper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void showBanner() {
            EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Error;
            EditorNotificationPanel banner2 = new EditorNotificationPanel(this, status){
                {
                    this.setText(RenderDocBundle.INSTANCE.message("renderdoc.tool.capture.error.banner.title", new Object[0]));
                    this.myGearLabel.getParent().remove(this.myGearLabel);
                    this.setCloseAction(() -> showBanner.banner.1._init_$lambda$0($receiver));
                }

                private static final void _init_$lambda$0(ErrorBannerWrapper this$0) {
                    this$0.hideBanner();
                }
            };
            this.setContent((JComponent)banner2);
        }

        public final void hideBanner() {
            this.setContent(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocToolContent$FeedbackBannerWrapper;", "Lcom/intellij/ui/components/panels/Wrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "showBanner", "", "hideBanner", "intellij.rider.plugins.renderdoc"})
    public static final class FeedbackBannerWrapper
    extends Wrapper {
        @NotNull
        private final Project project;

        public FeedbackBannerWrapper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            if (RenderDocFeedbackService.Companion.getInstance().canShowBanner(this.project)) {
                this.showBanner();
            }
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void showBanner() {
            EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Info;
            EditorNotificationPanel banner2 = new EditorNotificationPanel(this, status){
                {
                    this.setText(RenderDocBundle.INSTANCE.message("feedback.banner.title", new Object[0]));
                    this.createActionLabel(RenderDocBundle.INSTANCE.message("feedback.banner.action", new Object[0]), () -> showBanner.banner.1._init_$lambda$0($receiver));
                    this.myGearLabel.getParent().remove(this.myGearLabel);
                    this.setCloseAction(() -> showBanner.banner.1._init_$lambda$1($receiver));
                }

                private static final void _init_$lambda$0(FeedbackBannerWrapper this$0) {
                    FrameViewerFeedbackSurveyConfig.Companion.showFeedbackDialog$intellij_rider_plugins_renderdoc(this$0.getProject(), this$0);
                }

                private static final void _init_$lambda$1(FeedbackBannerWrapper this$0) {
                    this$0.hideBanner();
                }
            };
            this.setContent((JComponent)banner2);
        }

        public final void hideBanner() {
            RenderDocFeedbackService.Companion.getInstance().markBannerClosed();
            this.setContent(null);
        }
    }
}

