/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.plugins.renderdoc.RenderDocBundle;
import com.jetbrains.rider.plugins.renderdoc.core.RenderDocPixelInput;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocAbstractTextureSelectionPanel;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocDataKeys;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocExpandedTextureDialog;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocPixelInfo;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTextureSelectionPanel;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.actions.SelectPixelAdapter;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.model.EventTexturesInfo;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.model.TextureInfo;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.model.TextureType;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.RenderDocExtensionsKt;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.TexturePreviewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002:\u0002HIB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020&H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0015H\u0002J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020&J\f\u00100\u001a\u00060\u001bR\u00020\u0000H\u0016J\b\u00101\u001a\u000202H\u0016J \u00103\u001a\u00020.2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020.H\u0016J\u0018\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0016J\u0018\u0010<\u001a\u00020&2\u0006\u00107\u001a\u00020.2\u0006\u0010=\u001a\u00020.H\u0016J\u0010\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020@H\u0016J\u001a\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u0002022\b\b\u0002\u0010C\u001a\u00020.H\u0002J\b\u0010D\u001a\u00020&H\u0002J\u0014\u0010E\u001a\u00020\u0017*\u00020\u00172\u0006\u0010F\u001a\u00020:H\u0002J\u0010\u0010G\u001a\u00020\u00172\u0006\u00107\u001a\u00020.H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocAbstractTextureSelectionPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "viewModeSelector", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "expandedDialog", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocExpandedTextureDialog;", "getExpandedDialog$intellij_rider_plugins_renderdoc", "()Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocExpandedTextureDialog;", "setExpandedDialog$intellij_rider_plugins_renderdoc", "(Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocExpandedTextureDialog;)V", "textures", "Ljava/util/EnumMap;", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/TextureType;", "", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/TextureInfo;", "textureSelection", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$TextureSelection;", "toolbarPanel", "Ljavax/swing/JPanel;", "texturePanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$BufferedImagePanel;", "textureNameLabel", "Lcom/intellij/ui/components/JBLabel;", "bottomPanel", "pixelInfo", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocPixelInfo;", "counterLabel", "prevButton", "Ljavax/swing/JButton;", "nextButton", "initToolbar", "", "initTexturePreview", "initBottomPanel", "getCurrentTexture", "getTextureType", "getTextureImage", "Ljava/awt/image/BufferedImage;", "canExpandTexture", "", "closeExpandedTexture", "getImageComponent", "getCurrentPixelInput", "Lcom/jetbrains/rider/plugins/renderdoc/core/RenderDocPixelInput;", "updateTextures", "texturesInfo", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/EventTexturesInfo;", "pixelInput", "inputMode", "updatePixelInfo", "x", "", "y", "setToDefaultState", "shouldShowPixelPanel", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateWithInput", "input", "shouldShowPixelInfo", "updateButtonsAvailability", "moveOrSelf", "direction", "getInvalidSelection", "TextureSelection", "BufferedImagePanel", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocTextureSelectionPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocTextureSelectionPanel.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n306#2:298\n306#2:300\n306#2:301\n1#3:299\n*S KotlinDebug\n*F\n+ 1 RenderDocTextureSelectionPanel.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel\n*L\n36#1:298\n169#1:300\n194#1:301\n*E\n"})
public final class RenderDocTextureSelectionPanel
extends RenderDocAbstractTextureSelectionPanel
implements UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final JComponent viewModeSelector;
    @Nullable
    private RenderDocExpandedTextureDialog expandedDialog;
    @NotNull
    private EnumMap<TextureType, List<TextureInfo>> textures;
    @NotNull
    private TextureSelection textureSelection;
    @NotNull
    private final JPanel toolbarPanel;
    @NotNull
    private final BufferedImagePanel texturePanel;
    @NotNull
    private final JBLabel textureNameLabel;
    @NotNull
    private final JPanel bottomPanel;
    @NotNull
    private final RenderDocPixelInfo pixelInfo;
    @NotNull
    private final JBLabel counterLabel;
    @NotNull
    private final JButton prevButton;
    @NotNull
    private final JButton nextButton;

    public RenderDocTextureSelectionPanel(@NotNull Project project, @NotNull JComponent viewModeSelector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)viewModeSelector, (String)"viewModeSelector");
        this.project = project;
        this.viewModeSelector = viewModeSelector;
        boolean $i$f$enumMapOf = false;
        this.textures = (EnumMap)((Map)new EnumMap(TextureType.class));
        this.textureSelection = new TextureSelection(TextureType.OUTPUT_COLOR, -1);
        this.toolbarPanel = new JPanel(new BorderLayout());
        this.texturePanel = new BufferedImagePanel();
        this.textureNameLabel = new JBLabel();
        this.bottomPanel = new JPanel(new BorderLayout());
        this.pixelInfo = new RenderDocPixelInfo();
        this.counterLabel = new JBLabel("0/0");
        this.prevButton = new JButton(AllIcons.Actions.Back);
        this.nextButton = new JButton(AllIcons.Actions.Forward);
        this.initToolbar();
        this.initTexturePreview();
        this.initBottomPanel();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RenderDocExpandedTextureDialog getExpandedDialog$intellij_rider_plugins_renderdoc() {
        return this.expandedDialog;
    }

    public final void setExpandedDialog$intellij_rider_plugins_renderdoc(@Nullable RenderDocExpandedTextureDialog renderDocExpandedTextureDialog) {
        this.expandedDialog = renderDocExpandedTextureDialog;
    }

    private final void initToolbar() {
        JPanel jPanel;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction[] anActionArray = new AnAction[]{actionManager.getAction("DebugPixelAction"), actionManager.getAction("ExpandTextureAction")};
        DefaultActionGroup actionGroup2 = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = actionManager.createActionToolbar("RenderDocTextureSelectionPanel", (ActionGroup)actionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this);
        actionToolbar2.setReservePlaceAutoPopupIcon(false);
        this.pixelInfo.addPixelInfoChangeListener((Function2<? super UInt, ? super UInt, Unit>)((Function2)(arg_0, arg_1) -> RenderDocTextureSelectionPanel.initToolbar$lambda$0(this, arg_0, arg_1)));
        JPanel $this$initToolbar_u24lambda_u241 = jPanel = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl = false;
        $this$initToolbar_u24lambda_u241.add(actionToolbar2.getComponent());
        $this$initToolbar_u24lambda_u241.add(this.pixelInfo);
        JPanel wrapper = jPanel;
        this.toolbarPanel.add((Component)wrapper, "Center");
        this.toolbarPanel.add((Component)this.viewModeSelector, "East");
        this.add((Component)this.toolbarPanel, "North");
    }

    private final void initTexturePreview() {
        BufferedImagePanel bufferedImagePanel;
        BufferedImagePanel $this$initTexturePreview_u24lambda_u240 = bufferedImagePanel = this.texturePanel;
        boolean bl = false;
        $this$initTexturePreview_u24lambda_u240.setAlignmentX(0.5f);
        $this$initTexturePreview_u24lambda_u240.setMinimumSize(new Dimension(0, 0));
        SelectPixelAdapter mouseAdapter = new SelectPixelAdapter(this, (Function1<? super MouseEvent, Unit>)((Function1)arg_0 -> RenderDocTextureSelectionPanel.initTexturePreview$lambda$0$0(this, arg_0)));
        $this$initTexturePreview_u24lambda_u240.addMouseListener(mouseAdapter);
        $this$initTexturePreview_u24lambda_u240.addMouseMotionListener(mouseAdapter);
        this.add((Component)this.texturePanel, "Center");
    }

    private final void initBottomPanel() {
        JPanel jPanel;
        this.bottomPanel.setBorder((Border)JBUI.Borders.empty());
        this.textureNameLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        JPanel $this$initBottomPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$initBottomPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)5, (int)8, (int)0, (int)0));
        $this$initBottomPanel_u24lambda_u240.add((Component)this.textureNameLabel, "Center");
        JPanel textureInfoPanel = jPanel;
        this.bottomPanel.add((Component)textureInfoPanel, "Center");
        JPanel $this$initBottomPanel_u24lambda_u241 = $this$initBottomPanel_u24lambda_u240 = new JPanel(new FlowLayout(2, 0, 0));
        boolean bl2 = false;
        $this$initBottomPanel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)8));
        JPanel carouselPanel = $this$initBottomPanel_u24lambda_u240;
        this.counterLabel.setHorizontalAlignment(0);
        this.counterLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        RenderDocTextureSelectionPanel.initBottomPanel$configureNavigationAction(this.prevButton, this, RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.texture.navigation.previous", new Object[0]), -1);
        RenderDocTextureSelectionPanel.initBottomPanel$configureNavigationAction(this.nextButton, this, RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.texture.navigation.next", new Object[0]), 1);
        Box controlsBox = Box.createHorizontalBox();
        controlsBox.add((Component)this.counterLabel);
        controlsBox.add(Box.createHorizontalStrut(JBUI.scale((int)10)));
        controlsBox.add(this.prevButton);
        controlsBox.add(Box.createHorizontalStrut(JBUI.scale((int)10)));
        controlsBox.add(this.nextButton);
        carouselPanel.add(controlsBox);
        this.bottomPanel.add((Component)carouselPanel, "East");
        this.add((Component)this.bottomPanel, "South");
    }

    private final TextureInfo getCurrentTexture() {
        TextureSelection it = this.textureSelection;
        boolean bl = false;
        return RenderDocExtensionsKt.tryGetTexture(this.textures, it.getType(), it.getIndex());
    }

    @NotNull
    public final TextureType getTextureType() {
        Object object = this.getCurrentTexture();
        if (object == null || (object = object.getType()) == null) {
            throw new IllegalStateException("No texture selected".toString());
        }
        return object;
    }

    @NotNull
    public final BufferedImage getTextureImage() {
        Object object = this.getCurrentTexture();
        if (object == null || (object = ((TextureInfo)object).getImage()) == null) {
            throw new IllegalStateException("No texture selected".toString());
        }
        return object;
    }

    public final boolean canExpandTexture() {
        return this.expandedDialog == null && !this.texturePanel.isEmpty();
    }

    public final void closeExpandedTexture() {
        ActionsKt.runInEdt$default(null, () -> RenderDocTextureSelectionPanel.closeExpandedTexture$lambda$0(this), (int)1, null);
    }

    @Override
    @NotNull
    public BufferedImagePanel getImageComponent() {
        return this.texturePanel;
    }

    @Override
    @NotNull
    public RenderDocPixelInput getCurrentPixelInput() {
        Pair<UInt, UInt> it = this.pixelInfo.getInfo();
        boolean bl = false;
        TextureType type = this.textureSelection.getType();
        return new RenderDocPixelInput(type, ((UInt)it.getFirst()).unbox-impl(), ((UInt)it.getSecond()).unbox-impl(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateTextures(@NotNull EventTexturesInfo texturesInfo, @NotNull RenderDocPixelInput pixelInput, boolean inputMode) {
        Map $i$f$enumMapOf2;
        TextureInfo it;
        RenderDocTextureSelectionPanel renderDocTextureSelectionPanel;
        boolean hasTextures;
        block7: {
            Object object;
            TextureType textureType;
            void v1;
            List list;
            block9: {
                block8: {
                    void $this$updateTextures_u24lambda_u240;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)texturesInfo, (String)"texturesInfo");
                        Intrinsics.checkNotNullParameter((Object)pixelInput, (String)"pixelInput");
                        hasTextures = !((Collection)texturesInfo.getInputs()).isEmpty() || !((Collection)texturesInfo.getColorTextures()).isEmpty() || texturesInfo.getDepthTexture() != null;
                        boolean $i$f$enumMapOf2 = false;
                        Map map = $i$f$enumMapOf2 = (Map)new EnumMap(TextureType.class);
                        renderDocTextureSelectionPanel = this;
                        boolean bl = false;
                        if (!inputMode) break block6;
                        list = $this$updateTextures_u24lambda_u240.put(TextureType.INPUT, texturesInfo.getInputs());
                        break block7;
                    }
                    $this$updateTextures_u24lambda_u240.put(TextureType.OUTPUT_COLOR, texturesInfo.getColorTextures());
                    v1 = $this$updateTextures_u24lambda_u240;
                    textureType = TextureType.OUTPUT_DEPTH;
                    object = texturesInfo.getDepthTexture();
                    if (object == null) break block8;
                    TextureInfo textureInfo = object;
                    TextureType textureType2 = textureType;
                    void var11_13 = v1;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it);
                    v1 = var11_13;
                    textureType = textureType2;
                    List list3 = list2;
                    object = list3;
                    if (list3 != null) break block9;
                }
                object = CollectionsKt.emptyList();
            }
            list = (List)v1.put(textureType, object);
        }
        renderDocTextureSelectionPanel.textures = (EnumMap)$i$f$enumMapOf2;
        TextureSelection selection = this.textureSelection;
        if (selection.getType() != pixelInput.getTextureType() || RenderDocExtensionsKt.tryGetTexture(this.textures, pixelInput.getTextureType(), selection.getIndex()) == null) {
            TextureSelection textureSelection;
            TextureInfo texture = RenderDocExtensionsKt.getFirstOfTypeOrDefault(this.textures, pixelInput.getTextureType());
            RenderDocTextureSelectionPanel renderDocTextureSelectionPanel2 = this;
            TextureInfo textureInfo = texture;
            if (textureInfo != null) {
                it = textureInfo;
                renderDocTextureSelectionPanel = renderDocTextureSelectionPanel2;
                boolean bl = false;
                textureSelection = new TextureSelection(it.getType(), 0);
                renderDocTextureSelectionPanel2 = renderDocTextureSelectionPanel;
            } else {
                textureSelection = this.getInvalidSelection(inputMode);
            }
            renderDocTextureSelectionPanel2.textureSelection = textureSelection;
        }
        return this.updateWithInput(pixelInput, hasTextures);
    }

    @Override
    public void updatePixelInfo(int x, int y) {
        TextureInfo textureInfo = this.getCurrentTexture();
        if (textureInfo == null) {
            return;
        }
        TextureInfo texture = textureInfo;
        this.pixelInfo.updateRGBInfo(texture.getImage(), new RenderDocPixelInput(texture.getType(), UInt.constructor-impl((int)x), UInt.constructor-impl((int)y), null));
        this.texturePanel.setVisible(true);
        this.texturePanel.repaint();
    }

    @Override
    public void setToDefaultState(boolean inputMode, boolean shouldShowPixelPanel) {
        this.textureSelection = this.getInvalidSelection(inputMode);
        boolean $i$f$enumMapOf = false;
        this.textures = (EnumMap)((Map)new EnumMap(TextureType.class));
        this.texturePanel.setVisible(true);
        this.texturePanel.repaint();
        RenderDocExpandedTextureDialog renderDocExpandedTextureDialog = this.expandedDialog;
        if (renderDocExpandedTextureDialog != null) {
            renderDocExpandedTextureDialog.resetContent();
        }
        this.textureNameLabel.setText("");
        if (shouldShowPixelPanel) {
            this.pixelInfo.showInvalidPixelInfo();
        } else {
            this.pixelInfo.setVisible(false);
        }
        this.updateButtonsAvailability();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(RenderDocDataKeys.INSTANCE.getRENDERDOC_TEXTURE_PANEL(), (Object)this);
    }

    private final boolean updateWithInput(RenderDocPixelInput input, boolean shouldShowPixelInfo) {
        TextureInfo texture = this.getCurrentTexture();
        if (texture == null) {
            this.setToDefaultState(input.getTextureType() == TextureType.INPUT, shouldShowPixelInfo);
            return false;
        }
        Object[] objectArray = new Object[]{texture.getName(), texture.getImage().getWidth(), texture.getImage().getHeight()};
        this.textureNameLabel.setText(RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.texture.info", objectArray));
        this.textureNameLabel.setToolTipText(this.textureNameLabel.getText());
        this.pixelInfo.updateRGBInfo(texture.getImage(), input);
        this.texturePanel.setVisible(true);
        this.texturePanel.repaint();
        RenderDocExpandedTextureDialog renderDocExpandedTextureDialog = this.expandedDialog;
        if (renderDocExpandedTextureDialog != null) {
            renderDocExpandedTextureDialog.updateTexture();
        }
        this.updateButtonsAvailability();
        return true;
    }

    static /* synthetic */ boolean updateWithInput$default(RenderDocTextureSelectionPanel renderDocTextureSelectionPanel, RenderDocPixelInput renderDocPixelInput, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return renderDocTextureSelectionPanel.updateWithInput(renderDocPixelInput, bl);
    }

    private final void updateButtonsAvailability() {
        int index = RenderDocExtensionsKt.getTexturePlainIndex(this.textures, this.textureSelection.getType(), this.textureSelection.getIndex());
        int textureImagesNumber = RenderDocExtensionsKt.getTextureNumber(this.textures);
        this.prevButton.setEnabled(textureImagesNumber > 0 && index > 0);
        this.nextButton.setEnabled(textureImagesNumber > 0 && index != -1 && index < textureImagesNumber - 1);
        this.counterLabel.setText(index + 1 + "/" + textureImagesNumber);
    }

    private final TextureSelection moveOrSelf(TextureSelection $this$moveOrSelf, int direction) {
        EnumMap<TextureType, List<TextureInfo>> texturesMap = this.textures;
        List<TextureInfo> list = texturesMap.get((Object)$this$moveOrSelf.getType());
        int n = list != null ? CollectionsKt.getLastIndex(list) : -1;
        int n2 = $this$moveOrSelf.getIndex() + direction;
        boolean bl = 0 <= n2 ? n2 <= n : false;
        if (bl) {
            return new TextureSelection($this$moveOrSelf.getType(), $this$moveOrSelf.getIndex() + direction);
        }
        Set<TextureType> set = this.textures.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List types = CollectionsKt.toList((Iterable)set);
        int idx = types.indexOf((Object)$this$moveOrSelf.getType()) + direction;
        while (true) {
            boolean bl2 = 0 <= idx ? idx <= CollectionsKt.getLastIndex((List)types) : false;
            if (!bl2) break;
            List<TextureInfo> textureList = texturesMap.get(types.get(idx));
            Collection collection = textureList;
            if (!(collection == null || collection.isEmpty())) {
                Object e = types.get(idx);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                return new TextureSelection((TextureType)((Object)e), direction > 0 ? 0 : CollectionsKt.getLastIndex(textureList));
            }
            idx += direction;
        }
        return new TextureSelection($this$moveOrSelf.getType(), $this$moveOrSelf.getIndex());
    }

    private final TextureSelection getInvalidSelection(boolean inputMode) {
        TextureType type = inputMode ? TextureType.INPUT : TextureType.OUTPUT_COLOR;
        return new TextureSelection(type, -1);
    }

    private static final Unit initToolbar$lambda$0(RenderDocTextureSelectionPanel this$0, UInt x, UInt y) {
        int index;
        TextureSelection textureSelection = this$0.textureSelection;
        TextureType type = textureSelection.component1();
        if (RenderDocExtensionsKt.tryGetTexture(this$0.textures, type, index = textureSelection.component2()) != null) {
            RenderDocTextureSelectionPanel.updateWithInput$default(this$0, new RenderDocPixelInput(type, x.unbox-impl(), y.unbox-impl(), null), false, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit initTexturePreview$lambda$0$0(RenderDocTextureSelectionPanel this$0, MouseEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            RenderDocExpandedTextureDialog renderDocExpandedTextureDialog = this$0.expandedDialog;
            if (renderDocExpandedTextureDialog == null) break block0;
            renderDocExpandedTextureDialog.updateTexture();
        }
        return Unit.INSTANCE;
    }

    private static final void initBottomPanel$configureNavigationAction(JButton $this$initBottomPanel_u24configureNavigationAction, RenderDocTextureSelectionPanel this$0, String tooltipText, int direction) {
        $this$initBottomPanel_u24configureNavigationAction.setBorder(JBUI.Borders.empty((int)2));
        $this$initBottomPanel_u24configureNavigationAction.setContentAreaFilled(false);
        $this$initBottomPanel_u24configureNavigationAction.setEnabled(false);
        $this$initBottomPanel_u24configureNavigationAction.setToolTipText(tooltipText);
        $this$initBottomPanel_u24configureNavigationAction.setPreferredSize(new Dimension($this$initBottomPanel_u24configureNavigationAction.getIcon().getIconWidth() + JBUI.scale((int)4), $this$initBottomPanel_u24configureNavigationAction.getIcon().getIconHeight() + JBUI.scale((int)4)));
        Icon icon = $this$initBottomPanel_u24configureNavigationAction.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        $this$initBottomPanel_u24configureNavigationAction.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        $this$initBottomPanel_u24configureNavigationAction.addActionListener(arg_0 -> RenderDocTextureSelectionPanel.initBottomPanel$configureNavigationAction$lambda$2(this$0, direction, arg_0));
    }

    private static final void initBottomPanel$configureNavigationAction$lambda$2(RenderDocTextureSelectionPanel this$0, int $direction, ActionEvent it) {
        this$0.textureSelection = this$0.moveOrSelf(this$0.textureSelection, $direction);
        RenderDocTextureSelectionPanel.updateWithInput$default(this$0, this$0.getCurrentPixelInput(), false, 2, null);
    }

    private static final Unit closeExpandedTexture$lambda$0(RenderDocTextureSelectionPanel this$0) {
        block0: {
            RenderDocExpandedTextureDialog renderDocExpandedTextureDialog = this$0.expandedDialog;
            if (renderDocExpandedTextureDialog == null) break block0;
            renderDocExpandedTextureDialog.close(0);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$BufferedImagePanel;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;)V", "emptyText", "com/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$BufferedImagePanel$emptyText$1", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$BufferedImagePanel$emptyText$1;", "dimensions", "Ljava/awt/Dimension;", "getDimensions", "()Ljava/awt/Dimension;", "setDimensions", "(Ljava/awt/Dimension;)V", "isEmpty", "", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.rider.plugins.renderdoc"})
    public final class BufferedImagePanel
    extends JPanel {
        @NotNull
        private final emptyText.1 emptyText;
        @NotNull
        private Dimension dimensions;

        public BufferedImagePanel() {
            this.emptyText = new StatusText(this, RenderDocTextureSelectionPanel.this){
                final /* synthetic */ BufferedImagePanel this$0;
                final /* synthetic */ RenderDocTextureSelectionPanel this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super((JComponent)$receiver);
                }

                public final void updateText() {
                    Object[] objectArray = new Object[]{RenderDocTextureSelectionPanel.access$getTextureSelection$p(this.this$1).getType() == TextureType.INPUT ? RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.default.inputs", new Object[0]) : RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.default.outputs", new Object[0])};
                    this.setText(RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.default", objectArray));
                }

                protected boolean isStatusVisible() {
                    return this.this$0.isEmpty();
                }
            };
            this.dimensions = new Dimension(0, 0);
        }

        @NotNull
        public final Dimension getDimensions() {
            return this.dimensions;
        }

        public final void setDimensions(@NotNull Dimension dimension) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
            this.dimensions = dimension;
        }

        public final boolean isEmpty() {
            return RenderDocTextureSelectionPanel.this.textureSelection.getIndex() == -1;
        }

        @Override
        public void paint(@Nullable Graphics g) {
            Boolean bl;
            super.paint(g);
            TextureInfo texture = RenderDocTextureSelectionPanel.this.getCurrentTexture();
            if (texture == null) {
                this.emptyText.updateText();
                this.emptyText.paint(this, g);
                return;
            }
            BufferedImage image = texture.getImage();
            double k = Math.max((double)image.getWidth() / (double)this.getWidth(), (double)image.getHeight() / (double)this.getHeight());
            int newWidth = (int)((double)image.getWidth() / k);
            int newHeight = (int)((double)image.getHeight() / k);
            Image scaledImage = image.getScaledInstance(newWidth, newHeight, 2);
            Intrinsics.checkNotNull((Object)scaledImage);
            BufferedImage imageWithSelection = TexturePreviewUtil.Companion.getImageWithSelectedPixel(scaledImage, RenderDocTextureSelectionPanel.this.getCurrentPixelInput(), new Dimension(image.getWidth(), image.getHeight()));
            int left = (this.getWidth() - imageWithSelection.getWidth()) / 2;
            int top = (this.getHeight() - imageWithSelection.getHeight()) / 2;
            Graphics graphics = g;
            Boolean it = bl = graphics != null ? Boolean.valueOf(graphics.drawImage(imageWithSelection, left, top, this)) : null;
            boolean bl2 = false;
            this.dimensions.width = imageWithSelection.getWidth();
            this.dimensions.height = imageWithSelection.getHeight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel$TextureSelection;", "", "type", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/TextureType;", "index", "", "<init>", "(Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/TextureType;I)V", "getType", "()Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/model/TextureType;", "getIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.renderdoc"})
    private static final class TextureSelection {
        @NotNull
        private final TextureType type;
        private final int index;

        public TextureSelection(@NotNull TextureType type, int index) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.index = index;
        }

        @NotNull
        public final TextureType getType() {
            return this.type;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final TextureType component1() {
            return this.type;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final TextureSelection copy(@NotNull TextureType type, int index) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new TextureSelection(type, index);
        }

        public static /* synthetic */ TextureSelection copy$default(TextureSelection textureSelection, TextureType textureType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                textureType = textureSelection.type;
            }
            if ((n2 & 2) != 0) {
                n = textureSelection.index;
            }
            return textureSelection.copy(textureType, n);
        }

        @NotNull
        public String toString() {
            return "TextureSelection(type=" + this.type + ", index=" + this.index + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureSelection)) {
                return false;
            }
            TextureSelection textureSelection = (TextureSelection)other;
            if (this.type != textureSelection.type) {
                return false;
            }
            return this.index == textureSelection.index;
        }
    }
}

