/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow;

import com.intellij.icons.AllIcons;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.plugins.renderdoc.core.RenderDocPixelInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J \u0010\u0016\u001a\u00020\f2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f0\u0018J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocPixelInfo;", "Ljavax/swing/JPanel;", "<init>", "()V", "pixelPreview", "Ljavax/swing/JLabel;", "pixelX", "Ljavax/swing/JTextField;", "pixelY", "pixelColorLabel", "Lcom/intellij/ui/components/JBLabel;", "showInvalidPixelInfo", "", "updateRGBInfo", "image", "Ljava/awt/image/BufferedImage;", "input", "Lcom/jetbrains/rider/plugins/renderdoc/core/RenderDocPixelInput;", "updateInfo", "x", "", "y", "addPixelInfoChangeListener", "handler", "Lkotlin/Function2;", "Lkotlin/UInt;", "getInfo", "Lkotlin/Pair;", "Companion", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocPixelInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocPixelInfo.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocPixelInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1878#2,3:99\n*S KotlinDebug\n*F\n+ 1 RenderDocPixelInfo.kt\ncom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocPixelInfo\n*L\n50#1:99,3\n*E\n"})
public final class RenderDocPixelInfo
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JLabel pixelPreview = new JLabel(EMPTY_PIXEL_ICON);
    @NotNull
    private final JTextField pixelX = new JTextField("0");
    @NotNull
    private final JTextField pixelY = new JTextField("0");
    @NotNull
    private final JBLabel pixelColorLabel = new JBLabel();
    @NotNull
    private static final Icon EMPTY_PIXEL_ICON;

    /*
     * WARNING - void declaration
     */
    public RenderDocPixelInfo() {
        super(new GridBagLayout());
        this.setVisible(false);
        GridBagConstraints gridBag = new GridBagConstraints();
        gridBag.insets = (Insets)JBUI.insetsRight((int)5);
        gridBag.gridx = 0;
        gridBag.gridy = 0;
        gridBag.anchor = 17;
        InputVerifier validator2 = new InputVerifier(){

            public boolean verify(JComponent input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                JTextField field = (JTextField)input;
                String string = field.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                UInt inp = UStringsKt.toUIntOrNull((String)string);
                return inp != null;
            }
        };
        this.pixelX.setInputVerifier(validator2);
        this.pixelX.setVerifyInputWhenFocusTarget(true);
        this.pixelY.setInputVerifier(validator2);
        this.pixelY.setVerifyInputWhenFocusTarget(true);
        this.pixelColorLabel.setIconTextGap(5);
        this.pixelColorLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        Object[] objectArray = new Object[]{this.pixelPreview, this.pixelX, this.pixelY, this.pixelColorLabel};
        List components = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEachIndexed$iv = components;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void comp;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            gridBag.gridx = i + 1;
            this.add((Component)comp, gridBag);
        }
    }

    public final void showInvalidPixelInfo() {
        this.pixelPreview.setIcon(EMPTY_PIXEL_ICON);
        this.pixelColorLabel.setText("");
        this.setVisible(true);
    }

    public final void updateRGBInfo(@NotNull BufferedImage image, @Nullable RenderDocPixelInput input) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Pair pair = input != null ? new Pair((Object)input.getX-pVg5ArA(), (Object)input.getY-pVg5ArA()) : new Pair((Object)0, (Object)0);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        if (x >= image.getWidth() || y >= image.getHeight()) {
            this.pixelX.setText(String.valueOf(x));
            this.pixelY.setText(String.valueOf(y));
            this.showInvalidPixelInfo();
            return;
        }
        this.updateInfo(image, x, y);
        this.setVisible(true);
    }

    public final void updateInfo(@NotNull BufferedImage image, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int rgb = image.getRGB(x, y);
        int pixelSize = EMPTY_PIXEL_ICON.getIconHeight();
        this.pixelPreview.setIcon((Icon)new ColorIcon(pixelSize, pixelSize, pixelSize - 1, pixelSize - 1, (Color)new JBColor(rgb, rgb), JBColor.foreground(), 0));
        this.pixelX.setText(String.valueOf(x));
        this.pixelY.setText(String.valueOf(y));
        this.pixelColorLabel.setText(": " + (rgb >> 16 & 0xFF) + ", " + (rgb >> 8 & 0xFF) + ", " + (rgb & 0xFF));
        this.setVisible(true);
    }

    public final void addPixelInfoChangeListener(@NotNull Function2<? super UInt, ? super UInt, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.pixelX.addActionListener(arg_0 -> RenderDocPixelInfo.addPixelInfoChangeListener$lambda$0(this, handler2, arg_0));
        this.pixelY.addActionListener(arg_0 -> RenderDocPixelInfo.addPixelInfoChangeListener$lambda$1(this, handler2, arg_0));
    }

    @NotNull
    public final Pair<UInt, UInt> getInfo() {
        String string = this.pixelX.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        UInt uInt = UStringsKt.toUIntOrNull((String)string);
        int x = uInt != null ? uInt.unbox-impl() : 0;
        String string2 = this.pixelY.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        UInt uInt2 = UStringsKt.toUIntOrNull((String)string2);
        int y = uInt2 != null ? uInt2.unbox-impl() : 0;
        return new Pair((Object)UInt.box-impl((int)x), (Object)UInt.box-impl((int)y));
    }

    private static final void addPixelInfoChangeListener$update(RenderDocPixelInfo this$0, Function2<? super UInt, ? super UInt, Unit> $handler) {
        Pair<UInt, UInt> pair = this$0.getInfo();
        int x = ((UInt)pair.component1()).unbox-impl();
        int y = ((UInt)pair.component2()).unbox-impl();
        $handler.invoke((Object)UInt.box-impl((int)x), (Object)UInt.box-impl((int)y));
    }

    private static final void addPixelInfoChangeListener$lambda$0(RenderDocPixelInfo this$0, Function2 $handler, ActionEvent it) {
        RenderDocPixelInfo.addPixelInfoChangeListener$update(this$0, (Function2<? super UInt, ? super UInt, Unit>)$handler);
    }

    private static final void addPixelInfoChangeListener$lambda$1(RenderDocPixelInfo this$0, Function2 $handler, ActionEvent it) {
        RenderDocPixelInfo.addPixelInfoChangeListener$update(this$0, (Function2<? super UInt, ? super UInt, Unit>)$handler);
    }

    static {
        Icon icon = AllIcons.Stub;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Stub");
        EMPTY_PIXEL_ICON = icon;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocPixelInfo$Companion;", "", "<init>", "()V", "EMPTY_PIXEL_ICON", "Ljavax/swing/Icon;", "intellij.rider.plugins.renderdoc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

