/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.toolWindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rider.plugins.renderdoc.RenderDocBundle;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.RenderDocTextureSelectionPanel;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.actions.SelectPixelAdapter;
import com.jetbrains.rider.plugins.renderdoc.toolWindow.utils.TexturePreviewUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.ui.ImageComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocExpandedTextureDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "textureSelectionPanel", "Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;", "onDisposeCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/renderdoc/toolWindow/RenderDocTextureSelectionPanel;Lkotlin/jvm/functions/Function0;)V", "editorComponent", "Lorg/intellij/images/editor/impl/ImageEditorUI;", "imageDocument", "Lorg/intellij/images/editor/ImageDocument;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "updateTexture", "resetContent", "dispose", "intellij.rider.plugins.renderdoc"})
public final class RenderDocExpandedTextureDialog
extends DialogWrapper {
    @NotNull
    private final RenderDocTextureSelectionPanel textureSelectionPanel;
    @NotNull
    private final Function0<Unit> onDisposeCallback;
    private ImageEditorUI editorComponent;
    private ImageDocument imageDocument;

    public RenderDocExpandedTextureDialog(@NotNull Project project, @NotNull RenderDocTextureSelectionPanel textureSelectionPanel, @NotNull Function0<Unit> onDisposeCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textureSelectionPanel, (String)"textureSelectionPanel");
        Intrinsics.checkNotNullParameter(onDisposeCallback, (String)"onDisposeCallback");
        super(project, null, true, DialogWrapper.IdeModalityType.MODELESS, true, true);
        this.textureSelectionPanel = textureSelectionPanel;
        this.onDisposeCallback = onDisposeCallback;
        this.init();
        this.setTitle(RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.texture.expanded.title", new Object[0]));
        this.textureSelectionPanel.setExpandedDialog$intellij_rider_plugins_renderdoc(this);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[1];
        String string = RenderDocBundle.INSTANCE.message("renderdoc.tool.previewer.texture.expanded.close", new Object[0]);
        actionArray[0] = new AbstractAction(this, string){
            final /* synthetic */ RenderDocExpandedTextureDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                RenderDocExpandedTextureDialog.access$doOKAction(this.this$0);
            }
        };
        return actionArray;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        BufferedImage textureImage = this.textureSelectionPanel.getTextureImage();
        int w = textureImage.getWidth();
        int h = textureImage.getHeight();
        BufferedImage bufferedImage = TexturePreviewUtil.Companion.copyBufferedImage(textureImage);
        ImageIcon icon = new ImageIcon(TexturePreviewUtil.Companion.getImageWithSelectedPixel(bufferedImage, this.textureSelectionPanel.getCurrentPixelInput(), new Dimension(w, h)));
        BufferedImage panel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = panel.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)panel);
        Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"createImageEditorUI(...)");
        ImageEditorUI comp = imageEditorUI;
        ImageComponent imageComponent = ImageEditorManagerImpl.getImageComponent((ImageEditorUI)comp);
        this.editorComponent = comp;
        ImageDocument imageDocument = imageComponent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)imageDocument, (String)"getDocument(...)");
        this.imageDocument = imageDocument;
        SelectPixelAdapter mouseAdapter = new SelectPixelAdapter(this.textureSelectionPanel, (Function1<? super MouseEvent, Unit>)((Function1)arg_0 -> RenderDocExpandedTextureDialog.createCenterPanel$lambda$0(this, arg_0)));
        imageComponent.addMouseListener((MouseListener)mouseAdapter);
        imageComponent.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        return (JComponent)comp;
    }

    public final void updateTexture() {
        BufferedImage textureImage = this.textureSelectionPanel.getTextureImage();
        ImageDocument imageDocument = this.imageDocument;
        if (imageDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageDocument");
            imageDocument = null;
        }
        imageDocument.setValue(TexturePreviewUtil.Companion.getImageWithSelectedPixel(TexturePreviewUtil.Companion.copyBufferedImage(textureImage), this.textureSelectionPanel.getCurrentPixelInput(), new Dimension(textureImage.getWidth(), textureImage.getHeight())));
        ImageEditorUI imageEditorUI = this.editorComponent;
        if (imageEditorUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editorComponent");
            imageEditorUI = null;
        }
        imageEditorUI.setVisible(true);
    }

    public final void resetContent() {
        ImageEditorUI imageEditorUI = this.editorComponent;
        if (imageEditorUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editorComponent");
            imageEditorUI = null;
        }
        imageEditorUI.setVisible(false);
    }

    protected void dispose() {
        super.dispose();
        ImageEditorUI imageEditorUI = this.editorComponent;
        if (imageEditorUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editorComponent");
            imageEditorUI = null;
        }
        Disposer.dispose((Disposable)((Disposable)imageEditorUI));
        this.onDisposeCallback.invoke();
    }

    private static final Unit createCenterPanel$lambda$0(RenderDocExpandedTextureDialog this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateTexture();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doOKAction(RenderDocExpandedTextureDialog $this) {
        $this.doOKAction();
    }
}

