/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.debugger.frame;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.renderdoc.rdClient.model.RdcSourceVariableMapping;
import com.jetbrains.renderdoc.rdClient.model.RdcVarType;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocArrayValue;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocEvaluationExtensionsKt;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocNamedValue;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocVariableInfo;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocVariableResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariablesGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "resolver", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariableResolver;", "vars", "", "Lcom/jetbrains/renderdoc/rdClient/model/RdcSourceVariableMapping;", "depth", "", "name", "", "<init>", "(Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariableResolver;Ljava/util/List;ILjava/lang/String;)V", "rdcVariables", "", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "addChildren", "children", "intellij.rider.plugins.renderdoc"})
public final class RenderDocVariablesGroup
extends XValueGroup {
    @NotNull
    private final RenderDocVariableResolver resolver;
    private final int depth;
    @NotNull
    private final List<RdcSourceVariableMapping> rdcVariables;

    public RenderDocVariablesGroup(@NotNull RenderDocVariableResolver resolver, @NotNull List<RdcSourceVariableMapping> vars, int depth, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.resolver = resolver;
        this.depth = depth;
        this.rdcVariables = CollectionsKt.toMutableList((Collection)vars);
    }

    public /* synthetic */ RenderDocVariablesGroup(RenderDocVariableResolver renderDocVariableResolver, List list, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(renderDocVariableResolver, list, n, string);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        XValueChildrenList varList = new XValueChildrenList(this.rdcVariables.size());
        for (Map.Entry<RenderDocVariableInfo, List<RdcSourceVariableMapping>> entry : RenderDocEvaluationExtensionsKt.groupVariables(this.rdcVariables, this.depth).entrySet()) {
            RenderDocVariableInfo info = entry.getKey();
            List<RdcSourceVariableMapping> vars = entry.getValue();
            if (((CharSequence)info.getName()).length() == 0 || info.getType() == RdcVarType.Unknown) continue;
            if (info.isLeaf()) {
                if (vars.size() == 1) {
                    varList.add((XNamedValue)new RenderDocNamedValue(this.resolver, (RdcSourceVariableMapping)CollectionsKt.single(vars), info.getName()));
                    continue;
                }
                varList.add((XNamedValue)new RenderDocArrayValue(this.resolver, vars, info.getName()));
                continue;
            }
            varList.addTopGroup((XValueGroup)new RenderDocVariablesGroup(this.resolver, vars, this.depth + 1, info.getName()));
        }
        node.addChildren(varList, true);
    }

    public final void addChildren(@NotNull List<RdcSourceVariableMapping> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.rdcVariables.addAll((Collection<RdcSourceVariableMapping>)children);
    }
}

