/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.debugger.frame;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.renderdoc.rdClient.model.RdcDebugVariableReference;
import com.jetbrains.renderdoc.rdClient.model.RdcShaderVariable;
import com.jetbrains.renderdoc.rdClient.model.RdcSourceVariableMapping;
import com.jetbrains.renderdoc.rdClient.model.RdcVarType;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocEvaluationExtensionsKt;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocVariableResolver;
import com.jetbrains.rider.plugins.renderdoc.debugger.frame.RenderDocVectorValue;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocValue;", "Lcom/intellij/xdebugger/frame/XValue;", "resolver", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariableResolver;", "variable", "Lcom/jetbrains/renderdoc/rdClient/model/RdcShaderVariable;", "outerType", "Lcom/jetbrains/renderdoc/rdClient/model/RdcVarType;", "<init>", "(Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariableResolver;Lcom/jetbrains/renderdoc/rdClient/model/RdcShaderVariable;Lcom/jetbrains/renderdoc/rdClient/model/RdcVarType;)V", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeChildren", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "Companion", "intellij.rider.plugins.renderdoc"})
public class RenderDocValue
extends XValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderDocVariableResolver resolver;
    @Nullable
    private final RdcShaderVariable variable;
    @NotNull
    private final RdcVarType outerType;

    public RenderDocValue(@NotNull RenderDocVariableResolver resolver, @Nullable RdcShaderVariable variable, @NotNull RdcVarType outerType) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)outerType, (String)"outerType");
        this.resolver = resolver;
        this.variable = variable;
        this.outerType = outerType;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (this.variable == null) {
            return;
        }
        RdcVarType type = this.variable.getType();
        if (type == RdcVarType.Unknown) {
            type = this.outerType;
        }
        node.setPresentation(null, type.name(), (String)CollectionsKt.first(RenderDocEvaluationExtensionsKt.evaluate(this.variable, this.resolver, this.outerType, 0)), !(this.variable.getMembers().length == 0));
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.variable == null) {
            return;
        }
        RdcShaderVariable[] members = this.variable.getMembers();
        XValueChildrenList varList = new XValueChildrenList(members.length);
        for (RdcShaderVariable child : members) {
            varList.add(child.getName(), Companion.create(this.resolver, child));
        }
        node.addChildren(varList, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocValue$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/xdebugger/frame/XValue;", "resolver", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/frame/RenderDocVariableResolver;", "rdcVariable", "Lcom/jetbrains/renderdoc/rdClient/model/RdcSourceVariableMapping;", "variable", "Lcom/jetbrains/renderdoc/rdClient/model/RdcShaderVariable;", "intellij.rider.plugins.renderdoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XValue create(@NotNull RenderDocVariableResolver resolver, @NotNull RdcSourceVariableMapping rdcVariable) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter((Object)rdcVariable, (String)"rdcVariable");
            if (rdcVariable.getType() != RdcVarType.ConstantBlock && Integer.compareUnsigned(UInt.constructor-impl((int)(rdcVariable.getRows-pVg5ArA() * rdcVariable.getColumns-pVg5ArA())), 0) >= 0) {
                return new RenderDocVectorValue(resolver, rdcVariable, 0, 4, null);
            }
            return new RenderDocValue(resolver, resolver.resolveVariableReference((RdcDebugVariableReference)ArraysKt.first((Object[])rdcVariable.getVariables())), rdcVariable.getType());
        }

        @NotNull
        public final XValue create(@NotNull RenderDocVariableResolver resolver, @NotNull RdcShaderVariable variable) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            if (variable.getType() != RdcVarType.ConstantBlock && Integer.compareUnsigned(UInt.constructor-impl((int)(variable.getRows-pVg5ArA() * variable.getColumns-pVg5ArA())), 0) >= 0) {
                return new RenderDocVectorValue(resolver, variable, 0, 4, null);
            }
            return new RenderDocValue(resolver, (RdcShaderVariable)ArraysKt.first((Object[])variable.getMembers()), variable.getType());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

