/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.renderdoc.rdClient.model.RdcDebugSession;
import com.jetbrains.renderdoc.rdClient.model.RdcSourceBreakpoint;
import com.jetbrains.rider.plugins.renderdoc.debugger.RenderDocDebugProcess;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.RdcBreakpointFactory;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.RenderDocBreakpointProperties;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.SourceShaderLineBreakpointType;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00050\u0004B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0013\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocSourceLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocBreakpointProperties;", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RdcBreakpointFactory;", "Lcom/jetbrains/renderdoc/rdClient/model/RdcSourceBreakpoint;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "project", "Lcom/intellij/openapi/project/Project;", "debugProcess", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocDebugProcess;", "<init>", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocDebugProcess;)V", "debugSession", "Lcom/jetbrains/renderdoc/rdClient/model/RdcDebugSession;", "registerBreakpoint", "", "breakpoint", "unregisterBreakpoint", "temporary", "", "processBreakpoint", "sourceSignal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "createRdcBreakpoint", "Lcom/intellij/xdebugger/XSourcePosition;", "transformFilePath", "", "path", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocSourceLineBreakpointHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocSourceLineBreakpointHandler.kt\ncom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocSourceLineBreakpointHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class RenderDocSourceLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<RenderDocBreakpointProperties>>
implements RdcBreakpointFactory<RdcSourceBreakpoint> {
    @NotNull
    private final IScheduler scheduler;
    @NotNull
    private final Project project;
    @NotNull
    private final RdcDebugSession debugSession;

    public RenderDocSourceLineBreakpointHandler(@NotNull IScheduler scheduler, @NotNull Project project, @NotNull RenderDocDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        super(SourceShaderLineBreakpointType.class);
        this.scheduler = scheduler;
        this.project = project;
        this.debugSession = debugProcess.getRdcSession$intellij_rider_plugins_renderdoc();
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<RenderDocBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.processBreakpoint(breakpoint, (ISignal<RdcSourceBreakpoint>)this.debugSession.getAddSourceBreakpoint());
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<RenderDocBreakpointProperties> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.processBreakpoint(breakpoint, (ISignal<RdcSourceBreakpoint>)this.debugSession.getRemoveSourceBreakpoint());
    }

    private final void processBreakpoint(XLineBreakpoint<RenderDocBreakpointProperties> breakpoint, ISignal<RdcSourceBreakpoint> sourceSignal) {
        this.scheduler.queue(() -> RenderDocSourceLineBreakpointHandler.processBreakpoint$lambda$0(breakpoint, sourceSignal, this));
    }

    @Override
    @NotNull
    public RdcSourceBreakpoint createRdcBreakpoint(@NotNull XSourcePosition breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        int line = UInt.constructor-impl((int)(UInt.constructor-impl((int)breakpoint.getLine()) + 1));
        String string = breakpoint.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = this.transformFilePath(string);
        return new RdcSourceBreakpoint(filePath, line, null);
    }

    private final String transformFilePath(String path) {
        String filePath;
        String string = this.project.getBasePath();
        if (string == null) {
            string = "";
        }
        if (!Intrinsics.areEqual((Object)(filePath = StringsKt.removePrefix((String)path, (CharSequence)string)), (Object)path)) {
            filePath = StringsKt.drop((String)filePath, (int)1);
        }
        return filePath;
    }

    private static final Unit processBreakpoint$lambda$0(XLineBreakpoint $breakpoint, ISignal $sourceSignal, RenderDocSourceLineBreakpointHandler this$0) {
        XSourcePosition xSourcePosition;
        block3: {
            block2: {
                xSourcePosition = $breakpoint.getSourcePosition();
                if (xSourcePosition == null) break block2;
                XSourcePosition it = xSourcePosition;
                boolean bl = false;
                RdcSourceBreakpoint rdcSourceBreakpoint = this$0.createRdcBreakpoint(it);
                xSourcePosition = rdcSourceBreakpoint;
                if (rdcSourceBreakpoint != null) break block3;
            }
            return Unit.INSTANCE;
        }
        XSourcePosition rdcBreakpoint = xSourcePosition;
        $sourceSignal.fire((Object)rdcBreakpoint);
        return Unit.INSTANCE;
    }
}

