/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.renderdoc.rdClient.model.RdcDebugSession;
import com.jetbrains.renderdoc.rdClient.model.RdcLineBreakpoint;
import com.jetbrains.rider.plugins.renderdoc.debugger.RenderDocDebugProcess;
import com.jetbrains.rider.plugins.renderdoc.debugger.ShaderDebugUserDataKeys;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.GeneratedShaderLineBreakpointType;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.RdcBreakpointFactory;
import com.jetbrains.rider.plugins.renderdoc.debugger.breakpoints.RenderDocBreakpointProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00050\u0004B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0013\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u001b\u0010\u001b\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocGeneratedLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocBreakpointProperties;", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RdcBreakpointFactory;", "Lcom/jetbrains/renderdoc/rdClient/model/RdcLineBreakpoint;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "project", "Lcom/intellij/openapi/project/Project;", "debugProcess", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocDebugProcess;", "<init>", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocDebugProcess;)V", "debugSession", "Lcom/jetbrains/renderdoc/rdClient/model/RdcDebugSession;", "registerBreakpoint", "", "breakpoint", "unregisterBreakpoint", "temporary", "", "processBreakpoint", "lineSignal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "createRdcBreakpoint", "Lcom/intellij/xdebugger/XSourcePosition;", "cleanBreakpointsForFiles", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "cleanBreakpointsForFiles$intellij_rider_plugins_renderdoc", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nRenderDocGeneratedLineBreakpointHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderDocGeneratedLineBreakpointHandler.kt\ncom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocGeneratedLineBreakpointHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1634#2,3:62\n774#2:66\n865#2,2:67\n1869#2,2:69\n1#3:65\n*S KotlinDebug\n*F\n+ 1 RenderDocGeneratedLineBreakpointHandler.kt\ncom/jetbrains/rider/plugins/renderdoc/debugger/breakpoints/RenderDocGeneratedLineBreakpointHandler\n*L\n49#1:62,3\n52#1:66\n52#1:67,2\n56#1:69,2\n*E\n"})
public final class RenderDocGeneratedLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<RenderDocBreakpointProperties>>
implements RdcBreakpointFactory<RdcLineBreakpoint> {
    @NotNull
    private final IScheduler scheduler;
    @NotNull
    private final Project project;
    @NotNull
    private final RenderDocDebugProcess debugProcess;
    @NotNull
    private final RdcDebugSession debugSession;

    public RenderDocGeneratedLineBreakpointHandler(@NotNull IScheduler scheduler, @NotNull Project project, @NotNull RenderDocDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        super(GeneratedShaderLineBreakpointType.class);
        this.scheduler = scheduler;
        this.project = project;
        this.debugProcess = debugProcess;
        this.debugSession = this.debugProcess.getRdcSession$intellij_rider_plugins_renderdoc();
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<RenderDocBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.processBreakpoint(breakpoint, (ISignal<RdcLineBreakpoint>)this.debugSession.getAddLineBreakpoint());
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<RenderDocBreakpointProperties> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.processBreakpoint(breakpoint, (ISignal<RdcLineBreakpoint>)this.debugSession.getRemoveLineBreakpoint());
    }

    private final void processBreakpoint(XLineBreakpoint<RenderDocBreakpointProperties> breakpoint, ISignal<RdcLineBreakpoint> lineSignal) {
        this.scheduler.queue(() -> RenderDocGeneratedLineBreakpointHandler.processBreakpoint$lambda$0(breakpoint, lineSignal, this));
    }

    @Override
    @Nullable
    public RdcLineBreakpoint createRdcBreakpoint(@NotNull XSourcePosition breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        VirtualFile virtualFile = breakpoint.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        if (!this.debugProcess.isDrawCallSourceFile$intellij_rider_plugins_renderdoc(virtualFile)) {
            return null;
        }
        int line = UInt.constructor-impl((int)(UInt.constructor-impl((int)breakpoint.getLine()) + 1));
        Integer n = (Integer)breakpoint.getFile().getUserData(ShaderDebugUserDataKeys.INSTANCE.getSHADER_SOURCE_FILE_INDEX());
        int index = n != null ? n : -1;
        return new RdcLineBreakpoint(index, line, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanBreakpointsForFiles$intellij_rider_plugins_renderdoc(@NotNull Collection<? extends VirtualFile> files) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        Iterable iterable = files;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv;
            void var11_10 = destination$iv;
            boolean bl = false;
            var11_10.add(it.getUrl());
        }
        Set fileUrls = (Set)destination$iv;
        ReadAction.nonBlocking(() -> RenderDocGeneratedLineBreakpointHandler.cleanBreakpointsForFiles$lambda$1(breakpointManager, this, fileUrls)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> RenderDocGeneratedLineBreakpointHandler.cleanBreakpointsForFiles$lambda$3(arg_0 -> RenderDocGeneratedLineBreakpointHandler.cleanBreakpointsForFiles$lambda$2(breakpointManager, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Unit processBreakpoint$lambda$0(XLineBreakpoint $breakpoint, ISignal $lineSignal, RenderDocGeneratedLineBreakpointHandler this$0) {
        XSourcePosition xSourcePosition;
        block3: {
            block2: {
                xSourcePosition = $breakpoint.getSourcePosition();
                if (xSourcePosition == null) break block2;
                XSourcePosition it = xSourcePosition;
                boolean bl = false;
                RdcLineBreakpoint rdcLineBreakpoint = this$0.createRdcBreakpoint(it);
                xSourcePosition = rdcLineBreakpoint;
                if (rdcLineBreakpoint != null) break block3;
            }
            return Unit.INSTANCE;
        }
        XSourcePosition rdcBreakpoint = xSourcePosition;
        $lineSignal.fire((Object)rdcBreakpoint);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List cleanBreakpointsForFiles$lambda$1(XBreakpointManager $breakpointManager, RenderDocGeneratedLineBreakpointHandler this$0, Set $fileUrls) {
        void $this$filterTo$iv$iv;
        Collection collection = $breakpointManager.getBreakpoints(this$0.getBreakpointTypeClass());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XLineBreakpoint it = (XLineBreakpoint)element$iv$iv;
            boolean bl = false;
            if (!$fileUrls.contains(it.getFileUrl())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit cleanBreakpointsForFiles$lambda$2(XBreakpointManager $breakpointManager, List breakpoints) {
        Intrinsics.checkNotNull((Object)breakpoints);
        if (!((Collection)breakpoints).isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> RenderDocGeneratedLineBreakpointHandler.cleanBreakpointsForFiles$lambda$2$0(breakpoints, $breakpointManager));
        }
        return Unit.INSTANCE;
    }

    private static final void cleanBreakpointsForFiles$lambda$2$0(List $breakpoints, XBreakpointManager $breakpointManager) {
        Intrinsics.checkNotNull((Object)$breakpoints);
        Iterable $this$forEach$iv = $breakpoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XBreakpoint p0 = (XBreakpoint)element$iv;
            boolean bl = false;
            $breakpointManager.removeBreakpoint(p0);
        }
    }

    private static final void cleanBreakpointsForFiles$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

