/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocSourcePosition;", "Lcom/intellij/xdebugger/impl/ui/ExecutionPointHighlighter$HighlighterProvider;", "Lcom/intellij/xdebugger/XSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineStart", "", "offsetStart", "offsetEnd", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;III)V", "frame", "Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocSourcePosition$ContentFrame;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocSourcePosition$ContentFrame;)V", "getLine", "getOffset", "getFile", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "ContentFrame", "intellij.rider.plugins.renderdoc"})
public final class RenderDocSourcePosition
implements ExecutionPointHighlighter.HighlighterProvider,
XSourcePosition {
    @NotNull
    private final VirtualFile file;
    private final int lineStart;
    private final int offsetStart;
    private final int offsetEnd;

    public RenderDocSourcePosition(@NotNull VirtualFile file, int lineStart, int offsetStart, int offsetEnd) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.lineStart = lineStart;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
    }

    public RenderDocSourcePosition(@NotNull VirtualFile file, @NotNull ContentFrame frame) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.file = file;
        this.lineStart = frame.getLineStart();
        this.offsetStart = frame.getOffsetStart();
        this.offsetEnd = frame.getOffsetEnd();
    }

    public int getLine() {
        return this.lineStart;
    }

    public int getOffset() {
        return this.offsetStart;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Navigatable navigatable = XDebuggerUtilImpl.createNavigatable((Project)project, (XSourcePosition)this);
        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
        return navigatable;
    }

    @NotNull
    public TextRange getHighlightRange() {
        return new TextRange(this.offsetStart, this.offsetEnd);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/debugger/RenderDocSourcePosition$ContentFrame;", "", "lineStart", "", "offsetStart", "offsetEnd", "<init>", "(III)V", "getLineStart", "()I", "getOffsetStart", "getOffsetEnd", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.renderdoc"})
    public static final class ContentFrame {
        private final int lineStart;
        private final int offsetStart;
        private final int offsetEnd;

        public ContentFrame(int lineStart, int offsetStart, int offsetEnd) {
            this.lineStart = lineStart;
            this.offsetStart = offsetStart;
            this.offsetEnd = offsetEnd;
        }

        public final int getLineStart() {
            return this.lineStart;
        }

        public final int getOffsetStart() {
            return this.offsetStart;
        }

        public final int getOffsetEnd() {
            return this.offsetEnd;
        }

        public final int component1() {
            return this.lineStart;
        }

        public final int component2() {
            return this.offsetStart;
        }

        public final int component3() {
            return this.offsetEnd;
        }

        @NotNull
        public final ContentFrame copy(int lineStart, int offsetStart, int offsetEnd) {
            return new ContentFrame(lineStart, offsetStart, offsetEnd);
        }

        public static /* synthetic */ ContentFrame copy$default(ContentFrame contentFrame, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = contentFrame.lineStart;
            }
            if ((n4 & 2) != 0) {
                n2 = contentFrame.offsetStart;
            }
            if ((n4 & 4) != 0) {
                n3 = contentFrame.offsetEnd;
            }
            return contentFrame.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ContentFrame(lineStart=" + this.lineStart + ", offsetStart=" + this.offsetStart + ", offsetEnd=" + this.offsetEnd + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lineStart);
            result = result * 31 + Integer.hashCode(this.offsetStart);
            result = result * 31 + Integer.hashCode(this.offsetEnd);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContentFrame)) {
                return false;
            }
            ContentFrame contentFrame = (ContentFrame)other;
            if (this.lineStart != contentFrame.lineStart) {
                return false;
            }
            if (this.offsetStart != contentFrame.offsetStart) {
                return false;
            }
            return this.offsetEnd == contentFrame.offsetEnd;
        }
    }
}

