/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.renderdoc.common.rd;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/renderdoc/common/rd/SharedLifetimeDefinition;", "", "initialLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "usageCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tryShareTo", "", "sharingLifetimeTerminated", "", "intellij.rider.plugins.renderdoc"})
@SourceDebugExtension(value={"SMAP\nSharedLifetimeDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedLifetimeDefinition.kt\ncom/jetbrains/rider/plugins/renderdoc/common/rd/SharedLifetimeDefinition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class SharedLifetimeDefinition {
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final AtomicInteger usageCount;

    public SharedLifetimeDefinition(@NotNull Lifetime initialLifetime) {
        Intrinsics.checkNotNullParameter((Object)initialLifetime, (String)"initialLifetime");
        this.lifetimeDefinition = new LifetimeDefinition();
        this.usageCount = new AtomicInteger(1);
        initialLifetime.onTermination(() -> SharedLifetimeDefinition._init_$lambda$0(this));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetimeDefinition.getLifetime();
    }

    public final boolean tryShareTo(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        int currentUsageCount = 0;
        do {
            if ((currentUsageCount = this.usageCount.get()) != 0) continue;
            return false;
        } while (!this.usageCount.weakCompareAndSetPlain(currentUsageCount, currentUsageCount + 1));
        lifetime.onTermination(() -> SharedLifetimeDefinition.tryShareTo$lambda$0(this));
        return true;
    }

    private final void sharingLifetimeTerminated() {
        boolean shouldTerminate;
        boolean bl;
        int n;
        int it = n = this.usageCount.decrementAndGet();
        boolean bl2 = false;
        boolean bl3 = bl = it >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Shared lifetime released after termination.";
            throw new AssertionError((Object)string);
        }
        boolean bl5 = shouldTerminate = n == 0;
        if (shouldTerminate) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    private static final Unit _init_$lambda$0(SharedLifetimeDefinition this$0) {
        this$0.sharingLifetimeTerminated();
        return Unit.INSTANCE;
    }

    private static final Unit tryShareTo$lambda$0(SharedLifetimeDefinition this$0) {
        this$0.sharingLifetimeTerminated();
        return Unit.INSTANCE;
    }
}

