/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.noesis.preview;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rider.noesis.NoesisPluginBundle;
import com.jetbrains.rider.noesis.preview.NoesisPreview;
import com.jetbrains.rider.xaml.core.XamlPreviewEditor;
import com.jetbrains.rider.xaml.previewEditor.PreviewEditorToolbar;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010/\u001a\u000200H\u0016J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020!H\u0016J\b\u00104\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020'H\u0016J\b\u00109\u001a\u00020'H\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010>\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\f0!\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/noesis/preview/NoesisPreviewEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/jetbrains/rider/xaml/core/XamlPreviewEditor;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentEditor", "Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditor;", "toolbar", "Lcom/jetbrains/rider/xaml/previewEditor/PreviewEditorToolbar;", "zoomFactorLive", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditor;Lcom/jetbrains/rider/xaml/previewEditor/PreviewEditorToolbar;Lcom/jetbrains/rd/util/reactive/IPropertyView;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getParentEditor", "()Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditor;", "getToolbar", "()Lcom/jetbrains/rider/xaml/previewEditor/PreviewEditorToolbar;", "getZoomFactorLive", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "preview", "Lcom/jetbrains/rider/noesis/preview/NoesisPreview;", "getPreviewOrNull", "getOrCreatePreview", "virtualFilePath", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "getVirtualFilePath", "()Ljava/lang/String;", "updateLayout", "", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getComponent", "Ljavax/swing/JPanel;", "getPreferredFocusedComponent", "", "getName", "getFile", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "selectNotify", "deselectNotify", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "dispose", "intellij.rider.plugins.noesis"})
public final class NoesisPreviewEditor
extends UserDataHolderBase
implements XamlPreviewEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile currentFile;
    @NotNull
    private final XamlSplitEditor parentEditor;
    @Nullable
    private final PreviewEditorToolbar toolbar;
    @NotNull
    private final IPropertyView<Double> zoomFactorLive;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    private NoesisPreview preview;
    @NotNull
    private final String virtualFilePath;

    public NoesisPreviewEditor(@NotNull Project project, @NotNull VirtualFile currentFile, @NotNull XamlSplitEditor parentEditor, @Nullable PreviewEditorToolbar toolbar, @NotNull IPropertyView<Double> zoomFactorLive) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)parentEditor, (String)"parentEditor");
        Intrinsics.checkNotNullParameter(zoomFactorLive, (String)"zoomFactorLive");
        this.project = project;
        this.currentFile = currentFile;
        this.parentEditor = parentEditor;
        this.toolbar = toolbar;
        this.zoomFactorLive = zoomFactorLive;
        this.lifetimeDefinition = new LifetimeDefinition();
        String string = this.currentFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.virtualFilePath = string;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getCurrentFile() {
        return this.currentFile;
    }

    @NotNull
    public XamlSplitEditor getParentEditor() {
        return this.parentEditor;
    }

    @Nullable
    public PreviewEditorToolbar getToolbar() {
        return this.toolbar;
    }

    @NotNull
    public IPropertyView<Double> getZoomFactorLive() {
        return this.zoomFactorLive;
    }

    @Nullable
    public final NoesisPreview getPreviewOrNull() {
        NoesisPreview noesisPreview;
        if (this.preview != null) {
            noesisPreview = this.preview;
            if (noesisPreview == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preview");
                noesisPreview = null;
            }
        } else {
            noesisPreview = null;
        }
        return noesisPreview;
    }

    private final NoesisPreview getOrCreatePreview() {
        NoesisPreview noesisPreview;
        if (this.preview == null) {
            this.preview = new NoesisPreview(this, this.getProject());
        }
        if ((noesisPreview = this.preview) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preview");
            noesisPreview = null;
        }
        return noesisPreview;
    }

    @NotNull
    public String getVirtualFilePath() {
        return this.virtualFilePath;
    }

    public void updateLayout() {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @NotNull
    public JPanel getComponent() {
        return this.getOrCreatePreview().getPanel();
    }

    @Nullable
    public Void getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return NoesisPluginBundle.Companion.message("previewer.editor.name", new Object[0]);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.currentFile;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
    }
}

