/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.noesis.lang.service;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.noesis.lang.service.NoesisLspServer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020\u001bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0006*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0006*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0006*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher;", "", "<init>", "()V", "loopBackAddress", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "myServer", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rider/noesis/lang/service/NoesisLspServer;", "getMyServer", "()Lcom/jetbrains/rd/util/reactive/Property;", "patternServerPort", "Ljava/util/regex/Pattern;", "patternServerName", "patternServerPriority", "patternCanRenderPreview", "refreshPeriod", "", "selector", "Ljava/nio/channels/Selector;", "syncLock", "Ljava/lang/Object;", "portRange", "Lkotlin/ranges/IntRange;", "serverPortRange", "initializeIfNeeded", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sendUpdateMessageToServers", "listenUdp", "startListeningUdp", "", "port", "", "parse", "json", "", "remoteAddress", "Ljava/net/SocketAddress;", "onClientDisconnected", "Companion", "intellij.rider.plugins.noesis"})
@SourceDebugExtension(value={"SMAP\nNoesisUdpAnnouncementWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoesisUdpAnnouncementWatcher.kt\ncom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n23#2:178\n23#2:179\n23#2:180\n23#2:181\n23#2:182\n23#2:183\n23#2:184\n23#2:185\n23#2:188\n23#2:189\n23#2:190\n1869#3,2:186\n*S KotlinDebug\n*F\n+ 1 NoesisUdpAnnouncementWatcher.kt\ncom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher\n*L\n66#1:178\n78#1:179\n91#1:180\n98#1:181\n124#1:182\n142#1:183\n160#1:184\n166#1:185\n55#1:188\n108#1:189\n117#1:190\n54#1:186,2\n*E\n"})
public final class NoesisUdpAnnouncementWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final InetAddress loopBackAddress = InetAddress.getLoopbackAddress();
    @NotNull
    private final Property<NoesisLspServer> myServer = new Property(null);
    private final Pattern patternServerPort = Pattern.compile("\"serverPort\":\\s*(?<serverPort>\\d+)");
    private final Pattern patternServerName = Pattern.compile("\"serverName\":\\s*\"(?<serverName>[^\"]+)\"");
    private final Pattern patternServerPriority = Pattern.compile("\"serverPriority\":\\s*(?<serverPriority>\\d+)");
    private final Pattern patternCanRenderPreview = Pattern.compile("\"canRenderPreview\":\\s*(?<canRenderPreview>[01])");
    private final long refreshPeriod;
    private final Selector selector = Selector.open();
    @NotNull
    private final Object syncLock = new Object();
    @NotNull
    private final IntRange portRange = new IntRange(16629, 16649);
    @NotNull
    private final IntRange serverPortRange = new IntRange(16529, 16549);

    public NoesisUdpAnnouncementWatcher() {
        this.refreshPeriod = 1000L;
    }

    @NotNull
    public final Property<NoesisLspServer> getMyServer() {
        return this.myServer;
    }

    public final void initializeIfNeeded(@NotNull Lifetime lifetime) {
        Timer timer2;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        lifetime.onTermination(() -> NoesisUdpAnnouncementWatcher.initializeIfNeeded$lambda$0(this));
        IntRange intRange = this.portRange;
        int port = intRange.getFirst();
        int n = intRange.getLast();
        if (port <= n) {
            while (!this.startListeningUdp(port)) {
                if (port == this.portRange.getLast()) {
                    NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("No UDP broadcast listener started on a port range.");
                }
                if (port == n) break;
                ++port;
            }
        }
        this.sendUpdateMessageToServers();
        String string = "Listen for Noesis LSP";
        n = 1;
        long l = 0L;
        long l2 = this.refreshPeriod;
        Timer timer3 = timer2 = TimersKt.timer((String)string, n != 0);
        timer3.schedule(new TimerTask(this){
            final /* synthetic */ NoesisUdpAnnouncementWatcher this$0;
            {
                this.this$0 = noesisUdpAnnouncementWatcher;
            }

            public void run() {
                TimerTask $this$initializeIfNeeded_u24lambda_u241 = this;
                boolean bl = false;
                NoesisUdpAnnouncementWatcher.access$listenUdp(this.this$0);
            }
        }, l, l2);
        Timer refreshTimer = timer2;
        lifetime.onTermination(() -> NoesisUdpAnnouncementWatcher.initializeIfNeeded$lambda$2(refreshTimer));
    }

    private final void sendUpdateMessageToServers() {
        NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
        boolean $i$f$thisLogger22 = false;
        Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Sending update messages via " + this.selector + " to the " + this.loopBackAddress.getHostAddress() + " ports: " + this.serverPortRange);
        String $i$f$thisLogger22 = "NoesisLangServer";
        byte[] byArray = $i$f$thisLogger22.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] payload = byArray;
        try {
            $i$f$thisLogger22 = this.serverPortRange;
            int port = $i$f$thisLogger22.getFirst();
            int n = $i$f$thisLogger22.getLast();
            if (port <= n) {
                while (true) {
                    ByteBuffer buffer = ByteBuffer.wrap(payload);
                    this.selector.selectNow(arg_0 -> NoesisUdpAnnouncementWatcher.sendUpdateMessageToServers$lambda$0(buffer, this, port, arg_0));
                    if (port != n) {
                        ++port;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            NoesisUdpAnnouncementWatcher $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void listenUdp() {
        Object object = this.syncLock;
        synchronized (object) {
            boolean bl = false;
            NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.trace("listenUdp ...");
            int n = this.selector.selectNow(arg_0 -> NoesisUdpAnnouncementWatcher.listenUdp$lambda$0$0(this, arg_0));
        }
    }

    private final boolean startListeningUdp(int port) {
        NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Attempt to setup UDP listener on port " + port);
        try {
            DatagramChannel channel = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(port));
            channel.configureBlocking(false);
            channel.register(this.selector, 1);
            DatagramChannel channel2 = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(this.loopBackAddress, port));
            channel2.configureBlocking(false);
            channel2.register(this.selector, 5);
            return true;
        }
        catch (Exception e) {
            NoesisUdpAnnouncementWatcher $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn(e.getMessage());
            return false;
        }
    }

    private final NoesisLspServer parse(String json, SocketAddress remoteAddress) {
        try {
            Matcher matcherServerPort = this.patternServerPort.matcher(json);
            Matcher matcherServerName = this.patternServerName.matcher(json);
            Matcher matcherServerPriority = this.patternServerPriority.matcher(json);
            Matcher matcherCanRenderPreview = this.patternCanRenderPreview.matcher(json);
            if (matcherServerName.find() && matcherServerPriority.find() && matcherCanRenderPreview.find()) {
                int n;
                if (matcherServerPort.find()) {
                    String string = matcherServerPort.group("serverPort");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    n = Integer.parseInt(string);
                } else {
                    Intrinsics.checkNotNull((Object)remoteAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                    n = ((InetSocketAddress)remoteAddress).getPort();
                }
                int serverPort = n;
                String serverName = matcherServerName.group("serverName");
                String string = matcherServerPriority.group("serverPriority");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                int serverPriority = Integer.parseInt(string);
                String string2 = matcherCanRenderPreview.group("canRenderPreview");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                boolean canRenderPreview = Integer.parseInt(string2) == 1;
                NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Parsed server: port = " + serverPort + ", name = " + serverName + ", priority = " + serverPriority + ", canRenderPreview = " + canRenderPreview);
                Intrinsics.checkNotNull((Object)serverName);
                return new NoesisLspServer(serverPort, serverName, serverPriority, canRenderPreview);
            }
        }
        catch (Exception e) {
            NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        return null;
    }

    public final void onClientDisconnected() {
        this.myServer.set(null);
        this.sendUpdateMessageToServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit initializeIfNeeded$lambda$0(NoesisUdpAnnouncementWatcher this$0) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            try {
                Set<SelectionKey> set = this$0.selector.keys();
                Intrinsics.checkNotNullExpressionValue(set, (String)"keys(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SelectionKey it = (SelectionKey)element$iv;
                    boolean bl2 = false;
                    it.channel().close();
                }
            }
            catch (Exception e) {
                NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
            finally {
                this$0.selector.close();
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit initializeIfNeeded$lambda$2(Timer $refreshTimer) {
        $refreshTimer.cancel();
        return Unit.INSTANCE;
    }

    private static final void sendUpdateMessageToServers$lambda$0(ByteBuffer $buffer, NoesisUdpAnnouncementWatcher this$0, int $port, SelectionKey key) {
        SelectableChannel selectableChannel = key.channel();
        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.DatagramChannel");
        DatagramChannel channel = (DatagramChannel)selectableChannel;
        channel.send($buffer, new InetSocketAddress(this$0.loopBackAddress, $port));
    }

    private static final void listenUdp$lambda$0$0(NoesisUdpAnnouncementWatcher this$0, SelectionKey key) {
        block7: {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            try {
                SelectableChannel selectableChannel = key.channel();
                Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.DatagramChannel");
                DatagramChannel channel = (DatagramChannel)selectableChannel;
                SocketAddress remote = channel.receive(buffer);
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                byte[] byArray2 = byArray;
                int n = 0;
                int n2 = buffer.position();
                String descriptor = new String(byArray2, n, n2, Charsets.UTF_8);
                if (((CharSequence)descriptor).length() == 0) {
                    return;
                }
                NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Received descriptor: " + descriptor);
                if (remote == null) {
                    return;
                }
                NoesisLspServer server = this$0.parse(descriptor, remote);
                if (server == null) {
                    return;
                }
                if (this$0.myServer.getValue() != null) {
                    int n3 = server.getPriority();
                    Object object = this$0.myServer.getValue();
                    Intrinsics.checkNotNull((Object)object);
                    if (n3 <= ((NoesisLspServer)object).getPriority()) break block7;
                }
                this$0.myServer.set((Object)server);
            }
            catch (Exception e) {
                NoesisUdpAnnouncementWatcher $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NoesisUdpAnnouncementWatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
    }

    public static final /* synthetic */ void access$listenUdp(NoesisUdpAnnouncementWatcher $this) {
        $this.listenUdp();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher$Companion;", "", "<init>", "()V", "getService", "Lcom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.noesis"})
    @SourceDebugExtension(value={"SMAP\nNoesisUdpAnnouncementWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoesisUdpAnnouncementWatcher.kt\ncom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,177:1\n30#2,2:178\n*S KotlinDebug\n*F\n+ 1 NoesisUdpAnnouncementWatcher.kt\ncom/jetbrains/rider/noesis/lang/service/NoesisUdpAnnouncementWatcher$Companion\n*L\n19#1:178,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NoesisUdpAnnouncementWatcher getService(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NoesisUdpAnnouncementWatcher> serviceClass$iv = NoesisUdpAnnouncementWatcher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NoesisUdpAnnouncementWatcher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

